/**
 * SoundManager 2 homepage demo JS
 * -------------------------------
 * Numerous demo CSS minified + combined
 * for optimal performance.
 * For raw source, see individual demo pages.
 * --------------------------------
 * Source files:
 * demo/play-mp3-links/script/inlineplayer.js
 * demo/page-player/script/page-player.js
 * demo/mp3-player-button/script/mp3-player-button.js
 * demo/360-player/script/berniecode-animator.js
 * demo/360-player/script/360player.js
 * demo/index.js
 */

/*

 Animator.js 1.1.9

 This library is released under the BSD license:

 Copyright (c) 2006, Bernard Sumption. All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name BernieCode nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.


 SoundManager 2: "Turntable UI": Base and API
 Copyright (c) 2015, Scott Schiller. All rights reserved.
 http://www.schillmania.com/projects/soundmanager2/
 Code provided under BSD license.
 http://schillmania.com/projects/soundmanager2/license.txt

 SoundManager 2: "Turntable UI": Demo application
 Copyright (c) 2015, Scott Schiller. All rights reserved.
 http://www.schillmania.com/projects/soundmanager2/
 Code provided under BSD license.
 http://schillmania.com/projects/soundmanager2/license.txt
*/
(function(){function a(){var b=this,a=this,c=soundManager,k=navigator.userAgent.match(/msie/i);this.playableClass="inline-playable";this.excludeClass="inline-exclude";this.links=[];this.sounds=[];this.soundsByURL=[];this.indexByURL=[];this.lastSound=null;this.soundCount=0;this.config={playNext:!1,autoPlay:!1};this.css={sDefault:"sm2_link",sLoading:"sm2_loading",sPlaying:"sm2_playing",sPaused:"sm2_paused"};this.addEventHandler="undefined"!==typeof window.addEventListener?function(b,a,c){return b.addEventListener(a,
c,!1)}:function(b,a,c){b.attachEvent("on"+a,c)};this.removeEventHandler="undefined"!==typeof window.removeEventListener?function(b,a,c){return b.removeEventListener(a,c,!1)}:function(b,a,c){return b.detachEvent("on"+a,c)};this.classContains=function(b,a){return"undefined"!==typeof b.className?b.className.match(new RegExp("(\\s|^)"+a+"(\\s|$)")):!1};this.addClass=function(a,d){a&&d&&!b.classContains(a,d)&&(a.className=(a.className?a.className+" ":"")+d)};this.removeClass=function(a,d){a&&d&&b.classContains(a,
d)&&(a.className=a.className.replace(new RegExp("( "+d+")|("+d+")","g"),""))};this.getSoundByURL=function(a){return"undefined"!==typeof b.soundsByURL[a]?b.soundsByURL[a]:null};this.isChildOfNode=function(a,b){if(!a||!a.parentNode)return!1;b=b.toLowerCase();do a=a.parentNode;while(a&&a.parentNode&&a.nodeName.toLowerCase()!==b);return a.nodeName.toLowerCase()===b?a:null};this.events={play:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=a.css.sPlaying;a.addClass(this._data.oLink,
this._data.className)},stop:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=""},pause:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=a.css.sPaused;a.addClass(this._data.oLink,this._data.className)},resume:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=a.css.sPlaying;a.addClass(this._data.oLink,this._data.className)},finish:function(){a.removeClass(this._data.oLink,this._data.className);
this._data.className="";if(a.config.playNext){var b=a.indexByURL[this._data.oLink.href]+1;b<a.links.length&&a.handleClick({target:a.links[b]})}}};this.stopEvent=function(a){"undefined"!==typeof a&&"undefined"!==typeof a.preventDefault?a.preventDefault():"undefined"!==typeof event&&"undefined"!==typeof event.returnValue&&(event.returnValue=!1);return!1};this.getTheDamnLink=k?function(a){return a&&a.target?a.target:window.event.srcElement}:function(a){return a.target};this.handleClick=function(a){if("undefined"!==
typeof a.button&&1<a.button)return!0;var d=b.getTheDamnLink(a);if("a"!==d.nodeName.toLowerCase()&&(d=b.isChildOfNode(d,"a"),!d)||!d.href||!c.canPlayLink(d)&&!b.classContains(d,b.playableClass)||b.classContains(d,b.excludeClass))return!0;var e=d.href,g=b.getSoundByURL(e);g?(g!==b.lastSound&&(c._writeDebug("sound different than last sound: "+b.lastSound.id),b.lastSound&&b.stopSound(b.lastSound)),g.togglePause()):(b.lastSound&&b.stopSound(b.lastSound),g=c.createSound({id:"inlineMP3Sound"+b.soundCount++,
url:e,onplay:b.events.play,onstop:b.events.stop,onpause:b.events.pause,onresume:b.events.resume,onfinish:b.events.finish,type:d.type||null}),g._data={oLink:d,className:b.css.sPlaying},b.soundsByURL[e]=g,b.sounds.push(g),g.play());b.lastSound=g;"undefined"!==typeof a&&"undefined"!==typeof a.preventDefault?a.preventDefault():event.returnValue=!1;return!1};this.stopSound=function(a){soundManager.stop(a.id);soundManager.unload(a.id)};this.init=function(){c._writeDebug("inlinePlayer.init()");for(var a=
document.getElementsByTagName("a"),d=0,e=0,g=a.length;e<g;e++)!c.canPlayLink(a[e])&&!b.classContains(a[e],b.playableClass)||b.classContains(a[e],b.excludeClass)||(b.addClass(a[e],b.css.sDefault),b.links[d]=a[e],b.indexByURL[a[e].href]=d,d++);0<d&&(b.addEventHandler(document,"click",b.handleClick),b.config.autoPlay&&b.handleClick({target:b.links[0],preventDefault:function(){}}));c._writeDebug("inlinePlayer.init(): Found "+d+" relevant items.")};this.init()}var c=null;window.inlinePlayer=c;soundManager.setup({debugMode:!0,
preferFlash:!1,useFlashBlock:!0,url:"../../swf/",flashVersion:9});soundManager.onready(function(){c=new a})})();var pagePlayer=null;
function PagePlayer(){var a=this,c=this,b=soundManager,f,n=null,k=null,q=document.getElementsByTagName("head")[0],d=null,e=navigator.userAgent,g=e.match(/(opera|firefox)/i),t=e.match(/ipad|ipod|iphone/i),p;this.config={usePeakData:!1,useWaveformData:!1,useEQData:!1,fillGraph:!1,allowRightClick:!0,useThrottling:!0,autoStart:!1,playNext:!0,updatePageTitle:!0,emptyTime:"-:--",useFavIcon:!1};this.css={sDefault:"sm2_link",sLoading:"sm2_loading",sPlaying:"sm2_playing",sPaused:"sm2_paused"};this.sounds=
[];this.soundsByObject=[];this.lastSound=null;this.soundCount=0;this.strings=[];this.dragActive=!1;this.dragExec=new Date;this.dragTimer=null;this.pageTitle=document.title;this.lastWPExec=new Date;this.lastWLExec=new Date;this.vuMeterData=[];this.oControls=null;this._mergeObjects=function(a,b){var m={},r,d;for(r in a)a.hasOwnProperty(r)&&(m[r]=a[r]);r="undefined"===typeof b?{}:b;for(d in r)"undefined"===typeof m[d]&&(m[d]=r[d]);return m};f=function(){function a(b){b=r.call(b);var l=b.length;m?(b[1]=
"on"+b[1],3<l&&b.pop()):3===l&&b.push(!1);return b}function b(a,l){var h=a.shift(),r=[d[l]];if(m)h[r](a[0],a[1]);else h[r].apply(h,a)}var m=window.attachEvent&&!window.addEventListener,r=Array.prototype.slice,d={add:m?"attachEvent":"addEventListener",remove:m?"detachEvent":"removeEventListener"};return{add:function(){b(a(arguments),"add")},remove:function(){b(a(arguments),"remove")}}}();this.hasClass=function(a,b){return"undefined"!==typeof a.className?a.className.match(new RegExp("(\\s|^)"+b+"(\\s|$)")):
!1};this.addClass=function(b,h){b&&h&&!a.hasClass(b,h)&&(b.className=(b.className?b.className+" ":"")+h)};this.removeClass=function(b,h){b&&h&&a.hasClass(b,h)&&(b.className=b.className.replace(new RegExp("( "+h+")|("+h+")","g"),""))};this.select=function(b,h){var m=a.getByClassName(b,"div",h||null);return m?m[0]:null};this.getByClassName=document.querySelectorAll?function(a,b,m){a="."+a;b&&(b=b.split(" "));b=1<b.length?b.join(a+", "):b[0]+a;return(m||document).querySelectorAll(b)}:function(b,h,m){var r=
m||document;m=[];var d,c=[];h&&(h=h.split(" "));if(h instanceof Array){for(d=h.length;d--;)c&&c[h[d]]||(c[h[d]]=r.getElementsByTagName(h[d]));for(d=h.length;d--;)for(r=c[h[d]].length;r--;)a.hasClass(c[h[d]][r],b)&&m.push(c[h[d]][r])}else for(c=r.all||r.getElementsByTagName("*"),d=0,r=c.length;d<r;d++)a.hasClass(c[d],b)&&m.push(c[d]);return m};this.isChildOfClass=function(b,h){if(!b||!h)return!1;for(;b.parentNode&&!a.hasClass(b,h);)b=b.parentNode;return a.hasClass(b,h)};this.getParentByNodeName=function(a,
b){if(!a||!b)return!1;for(b=b.toLowerCase();a.parentNode&&b!==a.parentNode.nodeName.toLowerCase();)a=a.parentNode;return a.parentNode&&b===a.parentNode.nodeName.toLowerCase()?a.parentNode:null};this.getOffX=function(a){var b=0;if(a.offsetParent)for(;a.offsetParent;)b+=a.offsetLeft,a=a.offsetParent;else a.x&&(b+=a.x);return b};this.getTime=function(a,b){var m=Math.floor(a/1E3),d=Math.floor(m/60),m=m-60*d;return b?d+":"+(10>m?"0"+m:m):{min:d,sec:m}};this.getSoundByObject=function(b){return"undefined"!==
typeof a.soundsByObject[b.id]?a.soundsByObject[b.id]:null};this.getPreviousItem=function(a){if(a.previousElementSibling)a=a.previousElementSibling;else for(a=a.previousSibling;a&&a.previousSibling&&1!==a.previousSibling.nodeType;)a=a.previousSibling;return"li"!==a.nodeName.toLowerCase()?null:a.getElementsByTagName("a")[0]};this.playPrevious=function(b){b||(b=a.lastSound);if(!b)return!1;(b=a.getPreviousItem(b._data.oLI))&&c.handleClick({target:b});return b};this.getNextItem=function(a){if(a.nextElementSibling)a=
a.nextElementSibling;else for(a=a.nextSibling;a&&a.nextSibling&&1!==a.nextSibling.nodeType;)a=a.nextSibling;return"li"!==a.nodeName.toLowerCase()?null:a.getElementsByTagName("a")[0]};this.playNext=function(b){b||(b=a.lastSound);if(!b)return!1;(b=a.getNextItem(b._data.oLI))&&c.handleClick({target:b});return b};this.setPageTitle=function(b){if(a.config.updatePageTitle)try{document.title=(b?b+" - ":"")+a.pageTitle}catch(d){a.setPageTitle=function(){}}};this.events={play:function(){c.removeClass(this._data.oLI,
this._data.className);this._data.className=c.css.sPlaying;c.addClass(this._data.oLI,this._data.className);a.setPageTitle(this._data.originalTitle)},stop:function(){c.removeClass(this._data.oLI,this._data.className);this._data.className="";this._data.oPosition.style.width="0px";a.setPageTitle();a.resetPageIcon()},pause:function(){c.dragActive||(c.removeClass(this._data.oLI,this._data.className),this._data.className=c.css.sPaused,c.addClass(this._data.oLI,this._data.className),a.setPageTitle(),a.resetPageIcon())},
resume:function(){c.dragActive||(c.removeClass(this._data.oLI,this._data.className),this._data.className=c.css.sPlaying,c.addClass(this._data.oLI,this._data.className))},finish:function(){c.removeClass(this._data.oLI,this._data.className);this._data.className="";this._data.oPosition.style.width="0px";a.config.playNext?c.playNext(this):(a.setPageTitle(),a.resetPageIcon())},whileloading:function(){function b(){this._data.oLoading.style.width=this.bytesLoaded/this.bytesTotal*100+"%";!this._data.didRefresh&&
this._data.metadata&&(this._data.didRefresh=!0,this._data.metadata.refresh())}if(c.config.useThrottling){var d=new Date;if(d&&50<d-a.lastWLExec||this.bytesLoaded===this.bytesTotal)b.apply(this),a.lastWLExec=d}else b.apply(this)},onload:function(){if(this.loaded)this._data.metadata&&this._data.metadata.refresh();else{var a=this._data.oLI.getElementsByTagName("a")[0],d=a.innerHTML;a.innerHTML=d+' <span style="font-size:0.5em"> | Load failed, d\'oh! '+(b.sandbox.noRemote?" Possible cause: Flash sandbox is denying remote URL access.":
b.sandbox.noLocal?"Flash denying local filesystem access":"404?")+"</span>";setTimeout(function(){a.innerHTML=d},5E3)}},whileplaying:function(){var l=null;c.dragActive||!c.config.useThrottling?(a.updateTime.apply(this),9<=b.flashVersion&&(c.config.usePeakData&&this.instanceOptions.usePeakData&&a.updatePeaks.apply(this),(c.config.useWaveformData&&this.instanceOptions.useWaveformData||c.config.useEQData&&this.instanceOptions.useEQData)&&a.updateGraph.apply(this)),this._data.metadata&&(l=new Date)&&
500<l-a.lastWPExec&&(this._data.metadata.refreshMetadata(this),a.lastWPExec=l),this._data.oPosition.style.width=this.position/a.getDurationEstimate(this)*100+"%"):(l=new Date,30<l-a.lastWPExec&&(a.updateTime.apply(this),9<=b.flashVersion&&(c.config.usePeakData&&this.instanceOptions.usePeakData&&a.updatePeaks.apply(this),(c.config.useWaveformData&&this.instanceOptions.useWaveformData||c.config.useEQData&&this.instanceOptions.useEQData)&&a.updateGraph.apply(this)),this._data.metadata&&this._data.metadata.refreshMetadata(this),
this._data.oPosition.style.width=this.position/a.getDurationEstimate(this)*100+"%",a.lastWPExec=l))}};this.setPageIcon=function(b){if(a.config.useFavIcon&&a.config.usePeakData&&b){var d=document.getElementById("sm2-favicon");d&&(q.removeChild(d),d=null);d||(d=document.createElement("link"),d.id="sm2-favicon",d.rel="shortcut icon",d.type="image/png",d.href=b,document.getElementsByTagName("head")[0].appendChild(d))}};this.resetPageIcon=function(){if(a.config.useFavIcon){var b=document.getElementById("favicon");
b&&(b.href="/favicon.ico")}};this.updatePeaks=function(){var d=this._data.oPeak.getElementsByTagName("span");d[0].style.marginTop=13-Math.floor(15*this.peakData.left)+"px";d[1].style.marginTop=13-Math.floor(15*this.peakData.right)+"px";8<b.flashVersion&&a.config.useFavIcon&&a.config.usePeakData&&a.setPageIcon(a.vuMeterData[parseInt(16*this.peakData.left,10)][parseInt(16*this.peakData.right,10)])};this.updateGraph=function(){if(!(9>c.config.flashVersion||!c.config.useWaveformData&&!c.config.useEQData)){var a=
this._data.oGraph.getElementsByTagName("div"),b;if(c.config.useWaveformData)for(b=255;b--;)a[255-b].style.marginTop=9+Math.ceil(-8*this.waveformData.left[b])+"px";else for(b=255;b--;)a[255-b].style.marginTop=18-(1+Math.ceil(-9*this.eqData[b]))+"px"}};this.resetGraph=function(){if(c.config.useEQData&&!(9>c.config.flashVersion)){var a=this._data.oGraph.getElementsByTagName("div"),b=c.config.useEQData?"17px":"9px",m=c.config.fillGraph?"32px":"1px",d;for(d=255;d--;)a[255-d].style.marginTop=b,a[255-d].style.height=
m}};this.updateTime=function(){var b=a.strings.timing.replace("%s1",a.getTime(this.position,!0)),b=b.replace("%s2",a.getTime(a.getDurationEstimate(this),!0));this._data.oTiming.innerHTML=b};this.getTheDamnTarget=function(b){return b.target||(window.event?window.event.srcElement:null)};this.withinStatusBar=function(b){return a.isChildOfClass(b,"playlist")&&a.isChildOfClass(b,"controls")};this.handleClick=function(l){if(2===l.button)return c.config.allowRightClick||c.stopEvent(l),c.config.allowRightClick;
var h=a.getTheDamnTarget(l),m,r,e;if(!h)return!0;a.dragActive&&a.stopDrag();if(a.withinStatusBar(h))return!1;"a"!==h.nodeName.toLowerCase()&&(h=a.getParentByNodeName(h,"a"));if(!h||!h.href||!b.canPlayLink(h)&&!a.hasClass(h,"playable")||a.hasClass(h,"exclude"))return!0;a.initUL(a.getParentByNodeName(h,"ul"));a.initItem(h);m=h.href;(r=a.getSoundByObject(h))?(a.setPageTitle(r._data.originalTitle),r===a.lastSound?2!==r.readyState?1!==r.playState?r.play():r.togglePause():b._writeDebug("Warning: sound failed to load (security restrictions, 404 or bad format)",
2):(a.lastSound&&a.stopSound(a.lastSound),d&&r._data.oTimingBox.appendChild(d),r.togglePause())):(r=b.createSound({id:h.id,url:decodeURI(m),onplay:a.events.play,onstop:a.events.stop,onpause:a.events.pause,onresume:a.events.resume,onfinish:a.events.finish,type:h.type||null,whileloading:a.events.whileloading,whileplaying:a.events.whileplaying,onmetadata:a.events.metadata,onload:a.events.onload}),m=a.oControls.cloneNode(!0),e=h.parentNode,e.appendChild(m),d&&e.appendChild(d),a.soundsByObject[h.id]=r,
r._data={oLink:h,oLI:e,oControls:a.select("controls",e),oStatus:a.select("statusbar",e),oLoading:a.select("loading",e),oPosition:a.select("position",e),oTimingBox:a.select("timing",e),oTiming:a.select("timing",e).getElementsByTagName("div")[0],oPeak:a.select("peak",e),oGraph:a.select("spectrum-box",e),className:a.css.sPlaying,originalTitle:h.innerHTML,metadata:null},d&&r._data.oTimingBox.appendChild(d),r._data.oLI.getElementsByTagName("ul").length&&(r._data.metadata=new Metadata(r)),h=a.strings.timing.replace("%s1",
a.config.emptyTime),h=h.replace("%s2",a.config.emptyTime),r._data.oTiming.innerHTML=h,a.sounds.push(r),a.lastSound&&a.stopSound(a.lastSound),a.resetGraph.apply(r),r.play());a.lastSound=r;return a.stopEvent(l)};this.handleMouseDown=function(b){t&&b.touches&&(b=b.touches[0]);if(2===b.button)return c.config.allowRightClick||c.stopEvent(b),c.config.allowRightClick;var d=a.getTheDamnTarget(b);if(!d||!a.withinStatusBar(d))return!0;a.dragActive=!0;a.lastSound.pause();a.setPosition(b);t?f.add(document,"touchmove",
a.handleMouseMove):f.add(document,"mousemove",a.handleMouseMove);a.addClass(a.lastSound._data.oControls,"dragging");return a.stopEvent(b)};this.handleMouseMove=function(b){t&&b.touches&&(b=b.touches[0]);if(a.dragActive)if(a.config.useThrottling){var d=new Date;20<d-a.dragExec?a.setPosition(b):(window.clearTimeout(a.dragTimer),a.dragTimer=window.setTimeout(function(){a.setPosition(b)},20));a.dragExec=d}else a.setPosition(b);else a.stopDrag();b.stopPropagation=!0;return!1};this.stopDrag=function(b){return a.dragActive?
(a.removeClass(a.lastSound._data.oControls,"dragging"),t?f.remove(document,"touchmove",a.handleMouseMove):f.remove(document,"mousemove",a.handleMouseMove),c.hasClass(a.lastSound._data.oLI,a.css.sPaused)||a.lastSound.resume(),a.dragActive=!1,a.stopEvent(b),!1):!0};this.handleStatusClick=function(b){a.setPosition(b);c.hasClass(a.lastSound._data.oLI,a.css.sPaused)||a.resume();a.stopEvent(b);return!1};this.stopEvent=function(b){"undefined"!==typeof b&&("undefined"!==typeof b.preventDefault?b.preventDefault():
(b.stopPropagation=!0,b.returnValue=!1));return!1};this.setPosition=function(b){var d=a.getTheDamnTarget(b),m;if(d){for(m=d;!a.hasClass(m,"controls")&&m.parentNode;)m=m.parentNode;d=a.lastSound;b=parseInt(b.clientX,10);b=Math.floor((b-a.getOffX(m)-4)/m.offsetWidth*a.getDurationEstimate(d));isNaN(b)||(b=Math.min(b,d.duration));isNaN(b)||d.setPosition(b)}};this.stopSound=function(a){b._writeDebug("stopping sound: "+a.id);b.stop(a.id);t||b.unload(a.id)};this.getDurationEstimate=function(b){return b.instanceOptions.isMovieStar?
b.duration:b._data.metadata&&b._data.metadata.data.givenDuration?b._data.metadata.data.givenDuration:b.durationEstimate||0};this.createVUData=function(){var b=0,d=0,m=n.getContext("2d"),r=m.createLinearGradient(0,16,0,0),c;r.addColorStop(0,"rgb(0,192,0)");r.addColorStop(.3,"rgb(0,255,0)");r.addColorStop(.625,"rgb(255,255,0)");r.addColorStop(.85,"rgb(255,0,0)");c=m.createLinearGradient(0,16,0,0);c.addColorStop(0,"rgba(0,0,0,0.2)");c.addColorStop(1,"rgba(0,0,0,0.5)");for(b=0;16>b;b++)a.vuMeterData[b]=
[];for(b=0;16>b;b++)for(d=0;16>d;d++)n.setAttribute("width",16),n.setAttribute("height",16),m.fillStyle=c,m.fillRect(0,0,7,15),m.fillRect(8,0,7,15),m.fillStyle=r,m.fillRect(0,15-b,7,16-(16-b)),m.fillRect(8,15-d,7,16-(16-d)),m.clearRect(0,3,16,1),m.clearRect(0,7,16,1),m.clearRect(0,11,16,1),a.vuMeterData[b][d]=n.toDataURL("image/png")};this.testCanvas=function(){var b=document.createElement("canvas"),a=null;if(!b||"undefined"===typeof b.getContext)return null;a=b.getContext("2d");if(!a||"function"!==
typeof b.toDataURL)return null;try{b.toDataURL("image/png")}catch(m){return null}return b};this.initItem=function(b){b.id||(b.id="pagePlayerMP3Sound"+a.soundCount++);a.addClass(b,a.css.sDefault)};this.initUL=function(d){9<=b.flashVersion&&a.addClass(d,a.cssBase)};this.init=function(l){function h(b){f[b](document,"click",a.handleClick);t?(f[b](document,"touchstart",a.handleMouseDown),f[b](document,"touchend",a.stopDrag)):(f[b](document,"mousedown",a.handleMouseDown),f[b](document,"mouseup",a.stopDrag));
f[b](window,"unload",p)}l?(b._writeDebug("pagePlayer.init(): Using custom configuration"),this.config=this._mergeObjects(l,this.config)):b._writeDebug("pagePlayer.init(): Using default configuration");var m,r,e,x;this.cssBase=[];b.useFlashBlock=!0;!b.html5Only&&9<=b.flashVersion?(b.defaultOptions.usePeakData=this.config.usePeakData,b.defaultOptions.useWaveformData=this.config.useWaveformData,b.defaultOptions.useEQData=this.config.useEQData,this.config.usePeakData&&this.cssBase.push("use-peak"),(this.config.useWaveformData||
this.config.useEQData)&&this.cssBase.push("use-spectrum"),this.cssBase=this.cssBase.join(" "),this.config.useFavIcon&&((n=a.testCanvas())&&g?a.createVUData():this.config.useFavIcon=!1)):(this.config.usePeakData||this.config.useWaveformData||this.config.useEQData)&&b._writeDebug("Page player: Note: soundManager.flashVersion = 9 is required for peak/waveform/EQ features.");k=document.createElement("div");k.innerHTML='  <div class="controls">\n   <div class="statusbar">\n    <div class="loading"></div>\n    <div class="position"></div>\n   </div>\n  </div>\n  <div class="timing">\n   <div id="sm2_timing" class="timing-data">\n    <span class="sm2_position">%s1</span> / <span class="sm2_total">%s2</span>\n   </div>\n  </div>\n  <div class="peak">\n   <div class="peak-box"><span class="l"></span><span class="r"></span></div>\n  </div>\n <div class="spectrum-container">\n  <div class="spectrum-box">\n   <div class="spectrum"></div>\n  </div>\n </div>';
if(9<=b.flashVersion){d=a.select("spectrum-container",k);d=k.removeChild(d);m=a.select("spectrum-box",d);r=m.getElementsByTagName("div")[0];e=document.createDocumentFragment();x=null;for(l=256;l--;)x=r.cloneNode(!1),x.style.left=l+"px",e.appendChild(x);m.removeChild(r);m.appendChild(e)}else k.removeChild(a.select("spectrum-container",k)),k.removeChild(a.select("peak",k));a.oControls=k.cloneNode(!0);l=a.select("timing-data",k);a.strings.timing=l.innerHTML;l.innerHTML="";l.id="";p=function(){h("remove")};
h("add");b._writeDebug("pagePlayer.init(): Ready",1);a.config.autoStart&&c.handleClick({target:c.getByClassName("playlist","ul")[0].getElementsByTagName("a")[0]})}}soundManager.useFlashBlock=!0;soundManager.onready(function(){pagePlayer=new PagePlayer;pagePlayer.init("undefined"!==typeof PP_CONFIG?PP_CONFIG:null)});
(function(){function a(){var b=this,a=this,c=soundManager,k=navigator.userAgent.match(/ipad|iphone/i),q=navigator.userAgent.match(/msie/i);this.excludeClass="button-exclude";this.links=[];this.sounds=[];this.soundsByURL={};this.indexByURL={};this.lastSound=null;this.soundCount=0;this.config={playNext:!1,autoPlay:!1};this.css={sDefault:"sm2_button",sLoading:"sm2_loading",sPlaying:"sm2_playing",sPaused:"sm2_paused"};this.includeClass=this.css.sDefault;this.addEventHandler="undefined"!==typeof window.addEventListener?
function(b,a,c){return b.addEventListener(a,c,!1)}:function(b,a,c){b.attachEvent("on"+a,c)};this.removeEventHandler="undefined"!==typeof window.removeEventListener?function(b,a,c){return b.removeEventListener(a,c,!1)}:function(b,a,c){return b.detachEvent("on"+a,c)};this.classContains=function(b,a){return"undefined"!==typeof b.className?b.className.match(new RegExp("(\\s|^)"+a+"(\\s|$)")):!1};this.addClass=function(a,c){a&&c&&!b.classContains(a,c)&&(a.className=(a.className?a.className+" ":"")+c)};
this.removeClass=function(a,c){a&&c&&b.classContains(a,c)&&(a.className=a.className.replace(new RegExp("( "+c+")|("+c+")","g"),""))};this.getSoundByURL=function(a){return"undefined"!==typeof b.soundsByURL[a]?b.soundsByURL[a]:null};this.isChildOfNode=function(b,a){if(!b||!b.parentNode)return null;a=a.toLowerCase();do b=b.parentNode;while(b&&b.parentNode&&b.nodeName.toLowerCase()!==a);return b.nodeName.toLowerCase()===a?b:null};this.events={play:function(){a.removeClass(this._data.oLink,this._data.className);
this._data.className=a.css.sPlaying;a.addClass(this._data.oLink,this._data.className)},stop:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=""},pause:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=a.css.sPaused;a.addClass(this._data.oLink,this._data.className)},resume:function(){a.removeClass(this._data.oLink,this._data.className);this._data.className=a.css.sPlaying;a.addClass(this._data.oLink,this._data.className)},finish:function(){a.removeClass(this._data.oLink,
this._data.className);this._data.className="";if(a.config.playNext){var b=a.indexByURL[this._data.oLink.href]+1;b<a.links.length&&a.handleClick({target:a.links[b]})}}};this.stopEvent=function(b){"undefined"!==typeof b&&"undefined"!==typeof b.preventDefault?b.preventDefault():"undefined"!==typeof window.event&&(window.event.returnValue=!1);return!1};this.getTheDamnLink=q?function(b){return b&&b.target?b.target:window.event.srcElement}:function(b){return b.target};this.handleClick=function(a){if("undefined"!==
typeof a.button&&1<a.button)return!0;var e=b.getTheDamnLink(a),g,f;if("a"!==e.nodeName.toLowerCase()&&(e=b.isChildOfNode(e,"a"),!e)||!e.href||!soundManager.canPlayLink(e)||b.classContains(e,b.excludeClass)||!b.classContains(e,b.includeClass))return!0;c._writeDebug("handleClick()");g=e.href;(f=b.getSoundByURL(g))?f===b.lastSound?f.togglePause():(f.togglePause(),c._writeDebug("sound different than last sound: "+b.lastSound.id),b.lastSound&&b.stopSound(b.lastSound)):(f=c.createSound({id:"basicMP3Sound"+
b.soundCount++,url:g,onplay:b.events.play,onstop:b.events.stop,onpause:b.events.pause,onresume:b.events.resume,onfinish:b.events.finish,type:e.type||null}),f._data={oLink:e,className:b.css.sPlaying},b.soundsByURL[g]=f,b.sounds.push(f),b.lastSound&&b.stopSound(b.lastSound),f.play());b.lastSound=f;return b.stopEvent(a)};this.stopSound=function(b){soundManager.stop(b.id);k||soundManager.unload(b.id)};this.init=function(){c._writeDebug("basicMP3Player.init()");var a,e,g=0,f=document.getElementsByTagName("a");
a=0;for(e=f.length;a<e;a++)b.classContains(f[a],b.css.sDefault)&&!b.classContains(f[a],b.excludeClass)&&(b.links[g]=f[a],b.indexByURL[f[a].href]=g,g++);0<g&&(b.addEventHandler(document,"click",b.handleClick),b.config.autoPlay&&b.handleClick({target:b.links[0],preventDefault:function(){}}));c._writeDebug("basicMP3Player.init(): Found "+g+" relevant items.")};this.init()}var c=null;window.basicMP3Player=c;soundManager.setup({preferFlash:!1,onready:function(){c=new a}})})();
function Animator(a){this.setOptions(a);var c=this;this.timerDelegate=function(){c.onTimerEvent()};this.subjects=[];this.subjectScopes=[];this.state=this.target=0;this.lastTime=null}
Animator.prototype={setOptions:function(a){this.options=Animator.applyDefaults({interval:20,duration:400,onComplete:function(){},onStep:function(){},transition:Animator.tx.easeInOut},a)},seekTo:function(a){this.seekFromTo(this.state,a)},seekFromTo:function(a,c){this.target=Math.max(0,Math.min(1,c));this.state=Math.max(0,Math.min(1,a));this.lastTime=(new Date).getTime();this.intervalId||(this.intervalId=window.setInterval(this.timerDelegate,this.options.interval))},jumpTo:function(a){this.target=this.state=
Math.max(0,Math.min(1,a));this.propagate()},toggle:function(){this.seekTo(1-this.target)},addSubject:function(a,c){this.subjects[this.subjects.length]=a;this.subjectScopes[this.subjectScopes.length]=c;return this},clearSubjects:function(){this.subjects=[];this.subjectScopes=[]},propagate:function(){for(var a=this.options.transition(this.state),c=0;c<this.subjects.length;c++)this.subjects[c].setState?this.subjects[c].setState(a):this.subjects[c].apply(this.subjectScopes[c],[a])},onTimerEvent:function(){var a=
(new Date).getTime(),c=a-this.lastTime;this.lastTime=a;a=c/this.options.duration*(this.state<this.target?1:-1);Math.abs(a)>=Math.abs(this.state-this.target)?this.state=this.target:this.state+=a;try{this.propagate()}finally{this.options.onStep.call(this),this.target==this.state&&(window.clearInterval(this.intervalId),this.intervalId=null,this.options.onComplete.call(this))}},play:function(){this.seekFromTo(0,1)},reverse:function(){this.seekFromTo(1,0)},inspect:function(){for(var a="#<Animator:\n",
c=0;c<this.subjects.length;c++)a+=this.subjects[c].inspect();return a+">"}};Animator.applyDefaults=function(a,c){c=c||{};var b,f={};for(b in a)f[b]=void 0!==c[b]?c[b]:a[b];return f};Animator.makeArray=function(a){if(null==a)return[];if(!a.length)return[a];for(var c=[],b=0;b<a.length;b++)c[b]=a[b];return c};
Animator.camelize=function(a){var c=a.split("-");if(1==c.length)return c[0];a=0==a.indexOf("-")?c[0].charAt(0).toUpperCase()+c[0].substring(1):c[0];for(var b=1,f=c.length;b<f;b++){var n=c[b];a+=n.charAt(0).toUpperCase()+n.substring(1)}return a};Animator.apply=function(a,c,b){return c instanceof Array?(new Animator(b)).addSubject(new CSSStyleSubject(a,c[0],c[1])):(new Animator(b)).addSubject(new CSSStyleSubject(a,c))};Animator.makeEaseIn=function(a){return function(c){return Math.pow(c,2*a)}};
Animator.makeEaseOut=function(a){return function(c){return 1-Math.pow(1-c,2*a)}};Animator.makeElastic=function(a){return function(c){c=Animator.tx.easeInOut(c);return(1-Math.cos(c*Math.PI*a))*(1-c)+c}};Animator.makeADSR=function(a,c,b,f){null==f&&(f=.5);return function(n){return n<a?n/a:n<c?1-(n-a)/(c-a)*(1-f):n<b?f:f*(1-(n-b)/(1-b))}};Animator.makeBounce=function(a){var c=Animator.makeElastic(a);return function(b){b=c(b);return 1>=b?b:2-b}};
Animator.tx={easeInOut:function(a){return-Math.cos(a*Math.PI)/2+.5},linear:function(a){return a},easeIn:Animator.makeEaseIn(1.5),easeOut:Animator.makeEaseOut(1.5),strongEaseIn:Animator.makeEaseIn(2.5),strongEaseOut:Animator.makeEaseOut(2.5),elastic:Animator.makeElastic(1),veryElastic:Animator.makeElastic(3),bouncy:Animator.makeBounce(1),veryBouncy:Animator.makeBounce(3)};
function NumericalStyleSubject(a,c,b,f,n){this.els=Animator.makeArray(a);this.property="opacity"==c&&window.ActiveXObject?"filter":Animator.camelize(c);this.from=parseFloat(b);this.to=parseFloat(f);this.units=null!=n?n:"px"}
NumericalStyleSubject.prototype={setState:function(a){a=this.getStyle(a);for(var c=0,b=0;b<this.els.length;b++){try{this.els[b].style[this.property]=a}catch(f){if("fontWeight"!=this.property)throw f;}if(20<c++)break}},getStyle:function(a){a=this.from+(this.to-this.from)*a;return"filter"==this.property?"alpha(opacity="+Math.round(100*a)+")":"opacity"==this.property?a:Math.round(a)+this.units},inspect:function(){return"\t"+this.property+"("+this.from+this.units+" to "+this.to+this.units+")\n"}};
function ColorStyleSubject(a,c,b,f){this.els=Animator.makeArray(a);this.property=Animator.camelize(c);this.to=this.expandColor(f);this.from=this.expandColor(b);this.origFrom=b;this.origTo=f}
ColorStyleSubject.prototype={expandColor:function(a){var c,b;if(c=ColorStyleSubject.parseColor(a))return a=parseInt(c.slice(1,3),16),b=parseInt(c.slice(3,5),16),c=parseInt(c.slice(5,7),16),[a,b,c];window.DEBUG&&alert("Invalid colour: '"+a+"'")},getValueForState:function(a,c){return Math.round(this.from[a]+(this.to[a]-this.from[a])*c)},setState:function(a){a="#"+ColorStyleSubject.toColorPart(this.getValueForState(0,a))+ColorStyleSubject.toColorPart(this.getValueForState(1,a))+ColorStyleSubject.toColorPart(this.getValueForState(2,
a));for(var c=0;c<this.els.length;c++)this.els[c].style[this.property]=a},inspect:function(){return"\t"+this.property+"("+this.origFrom+" to "+this.origTo+")\n"}};
ColorStyleSubject.parseColor=function(a){var c="#",b;if(b=ColorStyleSubject.parseColor.rgbRe.exec(a)){for(var f=1;3>=f;f++)a=Math.max(0,Math.min(255,parseInt(b[f]))),c+=ColorStyleSubject.toColorPart(a);return c}if(b=ColorStyleSubject.parseColor.hexRe.exec(a)){if(3==b[1].length){for(f=0;3>f;f++)c+=b[1].charAt(f)+b[1].charAt(f);return c}return"#"+b[1]}return!1};ColorStyleSubject.toColorPart=function(a){255<a&&(a=255);var c=a.toString(16);return 16>a?"0"+c:c};ColorStyleSubject.parseColor.rgbRe=/^rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/i;
ColorStyleSubject.parseColor.hexRe=/^\#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;function DiscreteStyleSubject(a,c,b,f,n){this.els=Animator.makeArray(a);this.property=Animator.camelize(c);this.from=b;this.to=f;this.threshold=n||.5}DiscreteStyleSubject.prototype={setState:function(a){for(var c=0;c<this.els.length;c++)this.els[c].style[this.property]=a<=this.threshold?this.from:this.to},inspect:function(){return"\t"+this.property+"("+this.from+" to "+this.to+" @ "+this.threshold+")\n"}};
function CSSStyleSubject(a,c,b){a=Animator.makeArray(a);this.subjects=[];if(0!=a.length){var f;if(b)c=this.parseStyle(c,a[0]),b=this.parseStyle(b,a[0]);else for(f in b=this.parseStyle(c,a[0]),c={},b)c[f]=CSSStyleSubject.getStyle(a[0],f);for(f in c)c[f]==b[f]&&(delete c[f],delete b[f]);var n,k,q,d;for(f in c){var e=String(c[f]),g=String(b[f]);if(null==b[f])window.DEBUG&&alert("No to style provided for '"+f+'"');else{if(q=ColorStyleSubject.parseColor(e))d=ColorStyleSubject.parseColor(g),k=ColorStyleSubject;
else if(e.match(CSSStyleSubject.numericalRe)&&g.match(CSSStyleSubject.numericalRe))q=parseFloat(e),d=parseFloat(g),k=NumericalStyleSubject,n=CSSStyleSubject.numericalRe.exec(e),g=CSSStyleSubject.numericalRe.exec(g),n=null!=n[1]?n[1]:null!=g[1]?g[1]:g;else if(e.match(CSSStyleSubject.discreteRe)&&g.match(CSSStyleSubject.discreteRe))q=e,d=g,k=DiscreteStyleSubject,n=0;else{window.DEBUG&&alert("Unrecognised format for value of "+f+": '"+c[f]+"'");continue}this.subjects[this.subjects.length]=new k(a,f,
q,d,n)}}}}
CSSStyleSubject.prototype={parseStyle:function(a,c){var b={};if(-1!=a.indexOf(":"))for(var f=a.split(";"),n=0;n<f.length;n++){var k=CSSStyleSubject.ruleRe.exec(f[n]);k&&(b[k[1]]=k[2])}else{var q;q=c.className;c.className=a;for(n=0;n<CSSStyleSubject.cssProperties.length;n++)f=CSSStyleSubject.cssProperties[n],k=CSSStyleSubject.getStyle(c,f),null!=k&&(b[f]=k);c.className=q}return b},setState:function(a){for(var c=0;c<this.subjects.length;c++)this.subjects[c].setState(a)},inspect:function(){for(var a="",
c=0;c<this.subjects.length;c++)a+=this.subjects[c].inspect();return a}};CSSStyleSubject.getStyle=function(a,c){var b;if(document.defaultView&&document.defaultView.getComputedStyle&&(b=document.defaultView.getComputedStyle(a,"").getPropertyValue(c)))return b;c=Animator.camelize(c);a.currentStyle&&(b=a.currentStyle[c]);return b||a.style[c]};CSSStyleSubject.ruleRe=/^\s*([a-zA-Z\-]+)\s*:\s*(\S(.+\S)?)\s*$/;CSSStyleSubject.numericalRe=/^-?\d+(?:\.\d+)?(%|[a-zA-Z]{2})?$/;CSSStyleSubject.discreteRe=/^\w+$/;
CSSStyleSubject.cssProperties="azimuth background background-attachment background-color background-image background-position background-repeat border-collapse border-color border-spacing border-style border-top border-top-color border-right-color border-bottom-color border-left-color border-top-style border-right-style border-bottom-style border-left-style border-top-width border-right-width border-bottom-width border-left-width border-width bottom clear clip color content cursor direction display elevation empty-cells css-float font font-family font-size font-size-adjust font-stretch font-style font-variant font-weight height left letter-spacing line-height list-style list-style-image list-style-position list-style-type margin margin-top margin-right margin-bottom margin-left max-height max-width min-height min-width orphans outline outline-color outline-style outline-width overflow padding padding-top padding-right padding-bottom padding-left pause position right size table-layout text-align text-decoration text-indent text-shadow text-transform top vertical-align visibility white-space width word-spacing z-index opacity outline-offset overflow-x overflow-y".split(" ");
function AnimatorChain(a,c){this.animators=a;this.setOptions(c);for(var b=0;b<this.animators.length;b++)this.listenTo(this.animators[b]);this.forwards=!1;this.current=0}
AnimatorChain.prototype={setOptions:function(a){this.options=Animator.applyDefaults({resetOnPlay:!0},a)},play:function(){this.forwards=!0;this.current=-1;if(this.options.resetOnPlay)for(var a=0;a<this.animators.length;a++)this.animators[a].jumpTo(0);this.advance()},reverse:function(){this.forwards=!1;this.current=this.animators.length;if(this.options.resetOnPlay)for(var a=0;a<this.animators.length;a++)this.animators[a].jumpTo(1);this.advance()},toggle:function(){this.forwards?this.seekTo(0):this.seekTo(1)},
listenTo:function(a){var c=a.options.onComplete,b=this;a.options.onComplete=function(){c&&c.call(a);b.advance()}},advance:function(){this.forwards?null!=this.animators[this.current+1]&&(this.current++,this.animators[this.current].play()):null!=this.animators[this.current-1]&&(this.current--,this.animators[this.current].reverse())},seekTo:function(a){0>=a?(this.forwards=!1,this.animators[this.current].seekTo(0)):(this.forwards=!0,this.animators[this.current].seekTo(1))}};
function Accordion(a){this.setOptions(a);a=this.options.initialSection;var c;this.options.rememberance&&(c=document.location.hash.substring(1));this.rememberanceTexts=[];this.ans=[];for(var b=this,f=0;f<this.options.sections.length;f++){var n=this.options.sections[f],k=new Animator(this.options.animatorOptions);k.addSubject(new NumericalStyleSubject(n,this.options.property,this.options.from+this.options.shift*f,this.options.to+this.options.shift*f,this.options.units));k.jumpTo(0);n=this.options.getActivator(n);
n.index=f;n.onclick=function(){b.show(this.index)};this.ans[this.ans.length]=k;this.rememberanceTexts[f]=n.innerHTML.replace(/\s/g,"");this.rememberanceTexts[f]===c&&(a=f)}this.show(a)}
Accordion.prototype={setOptions:function(a){this.options=Object.extend({sections:null,getActivator:function(a){return document.getElementById(a.getAttribute("activator"))},shift:0,initialSection:0,rememberance:!0,animatorOptions:{}},a||{})},show:function(a){for(var c=0;c<this.ans.length;c++)this.ans[c].seekTo(c>a?1:0);this.options.rememberance&&(document.location.hash=this.rememberanceTexts[a])}};var threeSixtyPlayer;
(function(a){function c(){var b=this,c=this,n=soundManager,k=navigator.userAgent,q=k.match(/msie/i),d=k.match(/opera/i),e=k.match(/safari/i),g=k.match(/chrome/i),t=k.match(/ipad|iphone/i),p="undefined"===typeof a.G_vmlCanvasManager&&"undefined"!==typeof document.createElement("canvas").getContext("2d"),l=d||g?359.9:360,h=navigator.userAgent.match(/msie [678]/i)?1:2;this.excludeClass="threesixty-exclude";this.links=[];this.sounds=[];this.soundsByURL=[];this.indexByURL=[];this.lastTouchedSound=this.lastSound=
null;this.soundCount=0;this.vuMeter=this.oUIImageMap=this.oUITemplate=null;this.callbackCount=0;this.peakDataHistory=[];this.config={playNext:!1,autoPlay:!1,allowMultiple:!1,loadRingColor:"#ccc",playRingColor:"#000",backgroundRingColor:"#eee",segmentRingColor:"rgba(255,255,255,0.33)",segmentRingColorAlt:"rgba(0,0,0,0.1)",loadRingColorMetadata:"#ddd",playRingColorMetadata:"rgba(128,192,256,0.9)",circleDiameter:null,circleRadius:null,animDuration:500,animTransition:a.Animator.tx.bouncy,showHMSTime:!1,
scaleFont:!0,useWaveformData:!1,waveformDataColor:"#0099ff",waveformDataDownsample:3,waveformDataOutside:!1,waveformDataConstrain:!1,waveformDataLineRatio:.64,useEQData:!1,eqDataColor:"#339933",eqDataDownsample:4,eqDataOutside:!0,eqDataLineRatio:.54,usePeakData:!0,peakDataColor:"#ff33ff",peakDataOutside:!0,peakDataLineRatio:.5,useAmplifier:!0,fontSizeMax:null,scaleArcWidth:1,useFavIcon:!1};this.css={sDefault:"sm2_link",sBuffering:"sm2_buffering",sPlaying:"sm2_playing",sPaused:"sm2_paused"};this.addEventHandler=
"undefined"!==typeof a.addEventListener?function(b,a,c){return b.addEventListener(a,c,!1)}:function(b,a,c){b.attachEvent("on"+a,c)};this.removeEventHandler="undefined"!==typeof a.removeEventListener?function(b,a,c){return b.removeEventListener(a,c,!1)}:function(b,a,c){return b.detachEvent("on"+a,c)};this.hasClass=function(b,a){return"undefined"!==typeof b.className?b.className.match(new RegExp("(\\s|^)"+a+"(\\s|$)")):!1};this.addClass=function(a,c){a&&c&&!b.hasClass(a,c)&&(a.className=(a.className?
a.className+" ":"")+c)};this.removeClass=function(a,c){a&&c&&b.hasClass(a,c)&&(a.className=a.className.replace(new RegExp("( "+c+")|("+c+")","g"),""))};this.getElementsByClassName=function(a,c,d){var h=d||document;d=[];var l,e=[];if("undefined"!==typeof c&&"string"!==typeof c)for(l=c.length;l--;)e&&e[c[l]]||(e[c[l]]=h.getElementsByTagName(c[l]));else e=c?h.getElementsByTagName(c):h.all||h.getElementsByTagName("*");if("string"!==typeof c)for(l=c.length;l--;)for(h=e[c[l]].length;h--;)b.hasClass(e[c[l]][h],
a)&&d.push(e[c[l]][h]);else for(l=0;l<e.length;l++)b.hasClass(e[l],a)&&d.push(e[l]);return d};this.getParentByNodeName=function(b,a){if(!b||!a)return!1;for(a=a.toLowerCase();b.parentNode&&a!==b.parentNode.nodeName.toLowerCase();)b=b.parentNode;return b.parentNode&&a===b.parentNode.nodeName.toLowerCase()?b.parentNode:null};this.getParentByClassName=function(a,c){if(!a||!c)return null;for(;a.parentNode&&!b.hasClass(a.parentNode,c);)a=a.parentNode;return a.parentNode&&b.hasClass(a.parentNode,c)?a.parentNode:
null};this.getSoundByURL=function(a){return"undefined"!==typeof b.soundsByURL[a]?b.soundsByURL[a]:null};this.isChildOfNode=function(b,a){if(!b||!b.parentNode)return!1;a=a.toLowerCase();do b=b.parentNode;while(b&&b.parentNode&&b.nodeName.toLowerCase()!==a);return b&&b.nodeName.toLowerCase()===a?b:null};this.isChildOfClass=function(a,c){if(!a||!c)return!1;for(;a.parentNode&&!b.hasClass(a,c);)a=b.findParent(a);return b.hasClass(a,c)};this.findParent=function(b){if(!b||!b.parentNode)return!1;b=b.parentNode;
if(2===b.nodeType)for(;b&&b.parentNode&&2===b.parentNode.nodeType;)b=b.parentNode;return b};this.getStyle=function(b,c){try{if(b.currentStyle)return b.currentStyle[c];if(a.getComputedStyle)return document.defaultView.getComputedStyle(b,null).getPropertyValue(c)}catch(d){}return null};this.findXY=function(b){var a=0,c=0;do a+=b.offsetLeft,c+=b.offsetTop;while(b=b.offsetParent);return[a,c]};this.getMouseXY=function(m){m=m||a.event;t&&m.touches&&(m=m.touches[0]);return m.pageX||m.pageY?[m.pageX,m.pageY]:
m.clientX||m.clientY?[m.clientX+b.getScrollLeft(),m.clientY+b.getScrollTop()]:[void 0,void 0]};this.getScrollLeft=function(){return document.body.scrollLeft+document.documentElement.scrollLeft};this.getScrollTop=function(){return document.body.scrollTop+document.documentElement.scrollTop};this.events={play:function(){c.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=c.css.sPlaying;c.addClass(this._360data.oUIBox,this._360data.className);b.fanOut(this)},stop:function(){c.removeClass(this._360data.oUIBox,
this._360data.className);this._360data.className="";b.fanIn(this)},pause:function(){c.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=c.css.sPaused;c.addClass(this._360data.oUIBox,this._360data.className)},resume:function(){c.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=c.css.sPlaying;c.addClass(this._360data.oUIBox,this._360data.className)},finish:function(){var a;c.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=
"";this._360data.didFinish=!0;b.fanIn(this);c.config.playNext&&(a=c.indexByURL[this._360data.oLink.href]+1,a<c.links.length&&c.handleClick({target:c.links[a]}))},whileloading:function(){this.paused&&b.updatePlaying.apply(this)},whileplaying:function(){b.updatePlaying.apply(this);this._360data.fps++},bufferchange:function(){this.isBuffering?c.addClass(this._360data.oUIBox,c.css.sBuffering):c.removeClass(this._360data.oUIBox,c.css.sBuffering)}};this.stopEvent=function(b){"undefined"!==typeof b&&"undefined"!==
typeof b.preventDefault?b.preventDefault():"undefined"!==typeof a.event&&"undefined"!==typeof a.event.returnValue&&(a.event.returnValue=!1);return!1};this.getTheDamnLink=q?function(b){return b&&b.target?b.target:a.event.srcElement}:function(b){return b.target};this.handleClick=function(c){if(1<c.button)return!0;var d=b.getTheDamnLink(c),l,e,g,f,p,q;if("a"!==d.nodeName.toLowerCase()&&(d=b.isChildOfNode(d,"a"),!d)||!b.isChildOfClass(d,"ui360")||!d.href||!n.canPlayLink(d)||b.hasClass(d,b.excludeClass))return!0;
n._writeDebug("handleClick()");e=d.href;(g=b.getSoundByURL(e))?g===b.lastSound?g.togglePause():(g.togglePause(),n._writeDebug("sound different than last sound: "+b.lastSound.id),!b.config.allowMultiple&&b.lastSound&&b.stopSound(b.lastSound)):(f=d.parentNode,p=b.getElementsByClassName("ui360-vis","div",f.parentNode).length,g=n.createSound({id:"ui360Sound"+b.soundCount++,url:e,onplay:b.events.play,onstop:b.events.stop,onpause:b.events.pause,onresume:b.events.resume,onfinish:b.events.finish,onbufferchange:b.events.bufferchange,
type:d.type||null,whileloading:b.events.whileloading,whileplaying:b.events.whileplaying,useWaveformData:p&&b.config.useWaveformData,useEQData:p&&b.config.useEQData,usePeakData:p&&b.config.usePeakData}),q=parseInt(b.getElementsByClassName("sm2-360ui","div",f)[0].offsetWidth*h,10),l=b.getElementsByClassName("sm2-canvas","canvas",f),g._360data={oUI360:b.getParentByClassName(d,"ui360"),oLink:d,className:b.css.sPlaying,oUIBox:b.getElementsByClassName("sm2-360ui","div",f)[0],oCanvas:l[l.length-1],oButton:b.getElementsByClassName("sm2-360btn",
"span",f)[0],oTiming:b.getElementsByClassName("sm2-timing","div",f)[0],oCover:b.getElementsByClassName("sm2-cover","div",f)[0],circleDiameter:q,circleRadius:q/2,lastTime:null,didFinish:null,pauseCount:0,radius:0,fontSize:1,fontSizeMax:b.config.fontSizeMax,scaleFont:p&&b.config.scaleFont,showHMSTime:p,amplifier:p&&b.config.usePeakData?.9:1,radiusMax:.175*q,width:0,widthMax:.4*q,lastValues:{bytesLoaded:0,bytesTotal:0,position:0,durationEstimate:0},animating:!1,oAnim:new a.Animator({duration:b.config.animDuration,
transition:b.config.animTransition,onComplete:function(){}}),oAnimProgress:function(a){this._360data.radius=parseInt(this._360data.radiusMax*this._360data.amplifier*a,10);this._360data.width=parseInt(this._360data.widthMax*this._360data.amplifier*a,10);this._360data.scaleFont&&null!==this._360data.fontSizeMax&&(this._360data.oTiming.style.fontSize=parseInt(Math.max(1,this._360data.fontSizeMax*a),10)+"px",this._360data.oTiming.style.opacity=a);(this.paused||0===this.playState||0===this._360data.lastValues.bytesLoaded||
0===this._360data.lastValues.position)&&b.updatePlaying.apply(this)},fps:0},"undefined"!==typeof b.Metadata&&b.getElementsByClassName("metadata","div",g._360data.oUI360).length&&(g._360data.metadata=new b.Metadata(g,b)),g._360data.scaleFont&&null!==g._360data.fontSizeMax&&(g._360data.oTiming.style.fontSize="1px"),g._360data.oAnim.addSubject(g._360data.oAnimProgress,g),b.refreshCoords(g),b.updatePlaying.apply(g),b.soundsByURL[e]=g,b.sounds.push(g),!b.config.allowMultiple&&b.lastSound&&b.stopSound(b.lastSound),
g.play());b.lastSound=g;"undefined"!==typeof c&&"undefined"!==typeof c.preventDefault?c.preventDefault():"undefined"!==typeof a.event&&(a.event.returnValue=!1);return!1};this.fanOut=function(c){1!==c._360data.animating&&(c._360data.animating=0,soundManager._writeDebug("fanOut: "+c.id+": "+c._360data.oLink.href),c._360data.oAnim.seekTo(1),a.setTimeout(function(){c._360data.animating=0},b.config.animDuration+20))};this.fanIn=function(c){-1!==c._360data.animating&&(c._360data.animating=-1,soundManager._writeDebug("fanIn: "+
c.id+": "+c._360data.oLink.href),c._360data.oAnim.seekTo(0),a.setTimeout(function(){c._360data.didFinish=!1;c._360data.animating=0;b.resetLastValues(c)},b.config.animDuration+20))};this.resetLastValues=function(b){b._360data.lastValues.position=0};this.refreshCoords=function(a){a._360data.canvasXY=b.findXY(a._360data.oCanvas);a._360data.canvasMid=[a._360data.circleRadius,a._360data.circleRadius];a._360data.canvasMidXY=[a._360data.canvasXY[0]+a._360data.canvasMid[0],a._360data.canvasXY[1]+a._360data.canvasMid[1]]};
this.stopSound=function(b){soundManager._writeDebug("stopSound: "+b.id);soundManager.stop(b.id);t||soundManager.unload(b.id)};this.buttonClick=function(c){b.handleClick({target:b.getParentByClassName(c?c.target?c.target:c.srcElement:a.event.srcElement,"sm2-360ui").nextSibling});return!1};this.buttonMouseDown=function(a){t?b.addEventHandler(document,"touchmove",b.mouseDown):document.onmousemove=function(a){b.mouseDown(a)};b.stopEvent(a);return!1};this.mouseDown=function(c){if(!t&&1<c.button)return!0;
if(!b.lastSound)return b.stopEvent(c),!1;var d=c||a.event;t&&d.touches&&(d=d.touches[0]);d=b.getSoundByURL(b.getElementsByClassName("sm2_link","a",b.getParentByClassName(d.target||d.srcElement,"ui360"))[0].href);b.lastTouchedSound=d;b.refreshCoords(d);d=d._360data;b.addClass(d.oUIBox,"sm2_dragging");d.pauseCount=b.lastTouchedSound.paused?1:0;b.mmh(c||a.event);t?(b.removeEventHandler(document,"touchmove",b.mouseDown),b.addEventHandler(document,"touchmove",b.mmh),b.addEventHandler(document,"touchend",
b.mouseUp)):(document.onmousemove=b.mmh,document.onmouseup=b.mouseUp);b.stopEvent(c);return!1};this.mouseUp=function(){var a=b.lastTouchedSound._360data;b.removeClass(a.oUIBox,"sm2_dragging");0===a.pauseCount&&b.lastTouchedSound.resume();t?(b.removeEventHandler(document,"touchmove",b.mmh),b.removeEventHandler(document,"touchend",b.mouseUP)):(document.onmousemove=null,document.onmouseup=null)};this.mmh=function(c){"undefined"===typeof c&&(c=a.event);var d=b.lastTouchedSound,h=b.getMouseXY(c),h=Math.floor(l-
(b.rad2deg(Math.atan2(h[0]-d._360data.canvasMidXY[0],h[1]-d._360data.canvasMidXY[1]))+180));d.setPosition(h/l*d.durationEstimate);b.stopEvent(c);return!1};this.drawSolidArc=function(a,c,h,l,g,f,p){var q=a,n;q.getContext&&(n=q.getContext("2d"));a=n;p||b.clearCanvas(q);c&&(n.fillStyle=c);a.beginPath();isNaN(g)&&(g=0);c=h-l;l=d||e;if(!l||l&&0<h)a.arc(0,0,h,f,g,!1),h=b.getArcEndpointCoords(c,g),a.lineTo(h.x,h.y),a.arc(0,0,c,g,f,!0),a.closePath(),a.fill()};this.getArcEndpointCoords=function(b,a){return{x:b*
Math.cos(a),y:b*Math.sin(a)}};this.deg2rad=function(b){return Math.PI/180*b};this.rad2deg=function(b){return 180/Math.PI*b};this.getTime=function(b,a){var c=Math.floor(b/1E3),d=Math.floor(c/60),c=c-60*d;return a?d+":"+(10>c?"0"+c:c):{min:d,sec:c}};this.clearCanvas=function(b){var a=null,c;b.getContext&&(a=b.getContext("2d"));a&&(c=b.offsetWidth,b=b.offsetHeight,a.clearRect(-(c/2),-(b/2),c,b))};this.updatePlaying=function(){var a=this._360data.showHMSTime?b.getTime(this.position,!0):parseInt(this.position/
1E3,10),c=b.config.scaleArcWidth;this.bytesLoaded&&(this._360data.lastValues.bytesLoaded=this.bytesLoaded,this._360data.lastValues.bytesTotal=this.bytesTotal);this.position&&(this._360data.lastValues.position=this.position);this.durationEstimate&&(this._360data.lastValues.durationEstimate=this.durationEstimate);b.drawSolidArc(this._360data.oCanvas,b.config.backgroundRingColor,this._360data.width,this._360data.radius*c,b.deg2rad(l),!1);b.drawSolidArc(this._360data.oCanvas,this._360data.metadata?b.config.loadRingColorMetadata:
b.config.loadRingColor,this._360data.width,this._360data.radius*c,b.deg2rad(this._360data.lastValues.bytesLoaded/this._360data.lastValues.bytesTotal*l),0,!0);0!==this._360data.lastValues.position&&b.drawSolidArc(this._360data.oCanvas,this._360data.metadata?b.config.playRingColorMetadata:b.config.playRingColor,this._360data.width,this._360data.radius*c,b.deg2rad(1===this._360data.didFinish?l:this._360data.lastValues.position/this._360data.lastValues.durationEstimate*l),0,!0);this._360data.metadata&&
this._360data.metadata.events.whileplaying();a!==this._360data.lastTime&&(this._360data.lastTime=a,this._360data.oTiming.innerHTML=a);(this.instanceOptions.useWaveformData||this.instanceOptions.useEQData)&&p&&b.updateWaveform(this);b.config.useFavIcon&&b.vuMeter&&b.vuMeter.updateVU(this)};this.updateWaveform=function(a){if((b.config.useWaveformData||b.config.useEQData)&&(n.features.waveformData||n.features.eqData)&&(a.waveformData.left.length||a.eqData.length||a.peakData.left)){var c=parseInt(a._360data.circleDiameter/
2,10)/2,d,h,l,e,g,f,p,q,t;if(b.config.useWaveformData)for(l=b.config.waveformDataDownsample,l=Math.max(1,l),e=256/l,p=b.config.waveformDataOutside?1:b.config.waveformDataConstrain?.5:.565,c=b.config.waveformDataOutside?.7:.75,q=b.deg2rad(360/e*b.config.waveformDataLineRatio),d=0;256>d;d+=l)g=b.deg2rad(1/l*(d/e)*360),f=g+q,h=a.waveformData.left[d],0>h&&b.config.waveformDataConstrain&&(h=Math.abs(h)),b.drawSolidArc(a._360data.oCanvas,b.config.waveformDataColor,a._360data.width*p*(2-b.config.scaleArcWidth),
a._360data.radius*c*1.25*h,f,g,!0);if(b.config.useEQData)for(l=b.config.eqDataDownsample,l=Math.max(1,l),e=192,p=b.config.eqDataOutside?1:.565,h=b.config.eqDataOutside?-1:1,c=b.config.eqDataOutside?.5:.75,q=b.deg2rad(360/(e/l)*b.config.eqDataLineRatio),t=b.deg2rad(1===a._360data.didFinish?360:a._360data.lastValues.position/a._360data.lastValues.durationEstimate*360),d=0;d<e;d+=l)g=b.deg2rad(d/e*360),f=g+q,b.drawSolidArc(a._360data.oCanvas,f>t?b.config.eqDataColor:b.config.playRingColor,a._360data.width*
p,a._360data.radius*c*a.eqData.left[d]*h,f,g,!0);if(b.config.usePeakData&&!a._360data.animating){c=a.peakData.left||a.peakData.right;e=3;for(d=0;d<e;d++)c=c||a.eqData[d];a._360data.amplifier=b.config.useAmplifier?.9+.1*c:1;a._360data.radiusMax=.175*a._360data.circleDiameter*a._360data.amplifier;a._360data.widthMax=.4*a._360data.circleDiameter*a._360data.amplifier;a._360data.radius=parseInt(a._360data.radiusMax*a._360data.amplifier,10);a._360data.width=parseInt(a._360data.widthMax*a._360data.amplifier,
10)}}};this.getUIHTML=function(a){return['<canvas class="sm2-canvas" width="'+a+'" height="'+a+'"></canvas>',' <span class="sm2-360btn sm2-360btn-default"></span>',' <div class="sm2-timing'+(navigator.userAgent.match(/safari/i)?" alignTweak":"")+'"></div>',' <div class="sm2-cover"></div>']};this.uiTest=function(a){var c=document.createElement("div"),d,l,e;c.className="sm2-360ui";d=document.createElement("div");d.className="ui360"+(a?" "+a:"");c=d.appendChild(c.cloneNode(!0));d.style.position="absolute";
d.style.left="-9999px";a=document.body.appendChild(d);l=c.offsetWidth*h;e=b.getUIHTML(l);c.innerHTML=e[1]+e[2]+e[3];c=parseInt(l,10);l=parseInt(c/2,10);a=b.getElementsByClassName("sm2-timing","div",a)[0];a=parseInt(b.getStyle(a,"font-size"),10);isNaN(a)&&(a=null);d.parentNode.removeChild(d);return{circleDiameter:c,circleRadius:l,fontSizeMax:a}};this.init=function(){n._writeDebug("threeSixtyPlayer.init()");var c=b.getElementsByClassName("ui360","div"),d,l,e=[],g=!1,f=0,p,k,w,v,A;d=0;for(l=c.length;d<
l;d++)e.push(c[d].getElementsByTagName("a")[0]),c[d].style.backgroundImage="none";b.oUITemplate=document.createElement("div");b.oUITemplate.className="sm2-360ui";b.oUITemplateVis=document.createElement("div");b.oUITemplateVis.className="sm2-360ui";k=b.uiTest();b.config.circleDiameter=k.circleDiameter;b.config.circleRadius=k.circleRadius;w=b.uiTest("ui360-vis");b.config.fontSizeMax=w.fontSizeMax;b.oUITemplate.innerHTML=b.getUIHTML(b.config.circleDiameter).join("");b.oUITemplateVis.innerHTML=b.getUIHTML(w.circleDiameter).join("");
d=0;for(l=e.length;d<l;d++)!n.canPlayLink(e[d])||b.hasClass(e[d],b.excludeClass)||b.hasClass(e[d],b.css.sDefault)||(b.addClass(e[d],b.css.sDefault),b.links[f]=e[d],b.indexByURL[e[d].href]=f,f++,g=b.hasClass(e[d].parentNode,"ui360-vis"),p=(g?w:k).circleDiameter,c=(g?w:k).circleRadius,g=e[d].parentNode.insertBefore((g?b.oUITemplateVis:b.oUITemplate).cloneNode(!0),e[d]),q&&"undefined"!==typeof a.G_vmlCanvasManager?(v=document.createElement("canvas"),v.className="sm2-canvas",A="sm2_canvas_"+d+(new Date).getTime(),
v.id=A,v.width=p,v.height=p,g.appendChild(v),a.G_vmlCanvasManager.initElement(v),p=document.getElementById(A),g=p.parentNode.getElementsByTagName("canvas"),1<g.length&&(p=g[g.length-1])):p=e[d].parentNode.getElementsByTagName("canvas")[0],1<h&&b.addClass(p,"hi-dpi"),g=b.getElementsByClassName("sm2-cover","div",e[d].parentNode)[0],v=e[d].parentNode.getElementsByTagName("span")[0],b.addEventHandler(v,"click",b.buttonClick),t?b.addEventHandler(g,"touchstart",b.mouseDown):b.addEventHandler(g,"mousedown",
b.mouseDown),p=p.getContext("2d"),p.translate(c,c),p.rotate(b.deg2rad(-90)));0<f&&(b.addEventHandler(document,"click",b.handleClick),b.config.autoPlay&&b.handleClick({target:b.links[0],preventDefault:function(){}}));n._writeDebug("threeSixtyPlayer.init(): Found "+f+" relevant items.");b.config.useFavIcon&&"undefined"!==typeof this.VUMeter&&(this.vuMeter=new this.VUMeter(this))}}c.prototype.VUMeter=function(a){var c=this,n=document.getElementsByTagName("head")[0],k=navigator.userAgent.match(/opera/i),
q=navigator.userAgent.match(/firefox/i);this.vuMeterData=[];this.vuDataCanvas=null;this.setPageIcon=function(c){if(a.config.useFavIcon&&a.config.usePeakData&&c){var e=document.getElementById("sm2-favicon");e&&(n.removeChild(e),e=null);e||(e=document.createElement("link"),e.id="sm2-favicon",e.rel="shortcut icon",e.type="image/png",e.href=c,document.getElementsByTagName("head")[0].appendChild(e))}};this.resetPageIcon=function(){if(a.config.useFavIcon){var c=document.getElementById("favicon");c&&(c.href=
"/favicon.ico")}};this.updateVU=function(d){9<=soundManager.flashVersion&&a.config.useFavIcon&&a.config.usePeakData&&c.setPageIcon(c.vuMeterData[parseInt(16*d.peakData.left,10)][parseInt(16*d.peakData.right,10)])};this.createVUData=function(){var a=0,b=0,g=c.vuDataCanvas.getContext("2d"),q=g.createLinearGradient(0,16,0,0),p=g.createLinearGradient(0,16,0,0);q.addColorStop(0,"rgb(0,192,0)");q.addColorStop(.3,"rgb(0,255,0)");q.addColorStop(.625,"rgb(255,255,0)");q.addColorStop(.85,"rgb(255,0,0)");p.addColorStop(0,
"rgba(0,0,0,0.2)");p.addColorStop(1,"rgba(0,0,0,0.5)");for(a=0;16>a;a++)c.vuMeterData[a]=[];for(a=0;16>a;a++)for(b=0;16>b;b++)c.vuDataCanvas.setAttribute("width",16),c.vuDataCanvas.setAttribute("height",16),g.fillStyle=p,g.fillRect(0,0,7,15),g.fillRect(8,0,7,15),g.fillStyle=q,g.fillRect(0,15-a,7,16-(16-a)),g.fillRect(8,15-b,7,16-(16-b)),g.clearRect(0,3,16,1),g.clearRect(0,7,16,1),g.clearRect(0,11,16,1),c.vuMeterData[a][b]=c.vuDataCanvas.toDataURL("image/png")};this.testCanvas=function(){var a=document.createElement("canvas"),
b=null;if(!a||"undefined"===typeof a.getContext)return null;b=a.getContext("2d");if(!b||"function"!==typeof a.toDataURL)return null;try{a.toDataURL("image/png")}catch(c){return null}return a};this.init=function(){a.config.useFavIcon&&(c.vuDataCanvas=c.testCanvas(),c.vuDataCanvas&&(q||k)?c.createVUData():a.config.useFavIcon=!1)};this.init()};c.prototype.Metadata=function(a,c){soundManager._wD("Metadata()");var n=this,k=a._360data.oUI360,q=k.getElementsByTagName("ul")[0].getElementsByTagName("li"),
d;this.lastWPExec=0;this.refreshInterval=250;this.totalTime=0;this.events={whileplaying:function(){var e=a._360data.width,g=a._360data.radius,q=a.durationEstimate||1E3*n.totalTime,p=null,l,h;l=0;for(h=n.data.length;l<h;l++)p=0===l%2,c.drawSolidArc(a._360data.oCanvas,p?c.config.segmentRingColorAlt:c.config.segmentRingColor,e,g/2,c.deg2rad(n.data[d].endTimeMS/q*360),c.deg2rad((n.data[d].startTimeMS||1)/q*360),!0);e=new Date;e-n.lastWPExec>n.refreshInterval&&(n.refresh(),n.lastWPExec=e)}};this.refresh=
function(){var c,d,f=null,p=a.position,l=a._360data.metadata.data;c=0;for(d=l.length;c<d;c++)if(p>=l[c].startTimeMS&&p<=l[c].endTimeMS){f=c;break}f!==l.currentItem&&f<l.length&&(a._360data.oLink.innerHTML=l.mainTitle+' <span class="metadata"><span class="sm2_divider"> | </span><span class="sm2_metadata">'+l[f].title+"</span></span>",l.currentItem=f)};this.strToTime=function(a){a=a.split(":");var b=0,c;for(c=a.length;c--;)b+=parseInt(a[c],10)*Math.pow(60,a.length-1-c);return b};this.data=[];this.data.givenDuration=
null;this.data.currentItem=null;this.data.mainTitle=a._360data.oLink.innerHTML;for(d=0;d<q.length;d++)this.data[d]={o:null,title:q[d].getElementsByTagName("p")[0].innerHTML,startTime:q[d].getElementsByTagName("span")[0].innerHTML,startSeconds:n.strToTime(q[d].getElementsByTagName("span")[0].innerHTML.replace(/[()]/g,"")),duration:0,durationMS:null,startTimeMS:null,endTimeMS:null,oNote:null};k=c.getElementsByClassName("duration","div",k);this.data.givenDuration=k.length?1E3*n.strToTime(k[0].innerHTML):
0;for(d=0;d<this.data.length;d++)this.data[d].duration=parseInt(this.data[d+1]?this.data[d+1].startSeconds:(n.data.givenDuration?n.data.givenDuration:a.durationEstimate)/1E3,10)-this.data[d].startSeconds,this.data[d].startTimeMS=1E3*this.data[d].startSeconds,this.data[d].durationMS=1E3*this.data[d].duration,this.data[d].endTimeMS=this.data[d].startTimeMS+this.data[d].durationMS,this.totalTime+=this.data[d].duration};navigator.userAgent.match(/webkit/i)&&navigator.userAgent.match(/mobile/i)&&soundManager.setup({useHTML5Audio:!0});
soundManager.setup({html5PollingInterval:50,debugMode:a.location.href.match(/debug=1/i),consoleOnly:!0,flashVersion:9,useHighPerformance:!0});soundManager.debugMode&&a.setInterval(function(){var b=a.threeSixtyPlayer;b&&b.lastSound&&b.lastSound._360data.fps&&"undefined"===typeof a.isHome&&(soundManager._writeDebug("fps: ~"+b.lastSound._360data.fps),b.lastSound._360data.fps=0)},1E3);a.ThreeSixtyPlayer=c;a.threeSixtyPlayer=new c})(window);soundManager.onready(threeSixtyPlayer.init);
(function(a){function c(c,d){function e(a){k.css.add(h.o,a)}function g(a){k.css.remove(h.o,a)}function f(a){if(a)if(l.on&&l.on[a])l.on[a](l);else if(b.on[a])b.on[a](l)}function p(){0<=m.tonearm.angle&&(h.tonearm.style[k.features.transform.prop]="rotate("+m.tonearm.angle+"deg)")}var l,h,m,r,u;r="tt_"+n;n++;d=d||{};void 0===d.hideLabelWithArtwork&&(d.hideLabelWithArtwork=!0);m={power:{turntable:!1,motor:!1,motorVelocity:0},tonearm:{angle:0,maxAngle:42,minAngle:0},record:{hasArtwork:!1}};u={start:function(){m.power.turntable&&
!m.power.motor&&(m.power.motor=!0,e("motor-on"),f("start"))},stop:function(){m.power.motor&&(m.power.motor=!1,g("motor-on"),f("stop"))},toggle:function(){m.power.motor?u.stop():u.start()},powerOn:function(){m.power.turntable||(m.power.turntable=!0,e("power-on"),f("powerOn"))},powerOff:function(){m.power.turntable&&(m.power.turntable=!1,g("power-on"),f("powerOff"));u.stop()},powerToggle:function(){m.power.turntable?u.powerOff():u.powerOn()},setTonearmAngle:function(a){isNaN(a)||(m.tonearm.angle=Math.max(m.tonearm.minAngle,
Math.min(m.tonearm.maxAngle,a)),k.features.transform.prop&&(k.features.getAnimationFrame?k.features.getAnimationFrame(p):p()))},addSlipmat:function(){e("has-slipmat")},removeSlipmat:function(){g("has-slipmat")},toggleSlipmat:function(){k.css.toggle(h.o,"has-slipmat")},addRecord:function(){e("has-record")},removeRecord:function(){g("has-record")},toggleRecord:function(){k.css.toggle(h.o,"has-record")},setArtwork:function(a){a?(h.record.style.backgroundImage="url("+a+")",m.record.hasArtwork||(e("has-artwork"),
m.record.hasArtwork=!0)):m.record.hasArtwork&&(h.record.style.backgroundImage="none",g("has-artwork"),m.record.hasArtwork=!1);d.hideLabelWithArtwork?e("hide-label-with-artwork"):g("hide-label-with-artwork")}};h={o:c,platter:k.dom.get(c,".platter"),record:k.dom.get(c,".record"),slipmat:k.dom.get(c,".slipmat"),tonearm:k.dom.get(c,".tonearm")};h.o.id?r=h.o.id:h.o.id=r;k.events.add(h.o,"mousedown",function(a){var b;if((b=a.target)&&(b=b.getAttribute("data-method"))&&u[b])u[b](a)});k.events.add(h.o,"click",
function(a){return a.target&&"A"===a.target.nodeName?(k.events.preventDefault(a),!1):!0});a.setTimeout(u.powerToggle,500);return l={id:r,data:m,methods:u,on:{}}}var b=[],f={},n=0,k;b.on={};k={array:function(){return{compare:function(a){var b;return function(c,g){return b=c[a]<g[a]?-1:c[a]>g[a]?1:0}},shuffle:function(a){var b,c,g;for(b=a.length-1;0<b;b--)c=Math.floor(Math.random()*(b+1)),g=a[b],a[b]=a[c],a[c]=g;return a}}}(),css:function(){function a(b,c){return void 0!==b.className?!!(new RegExp("(^|\\s)"+
c+"(\\s|$)")).test(b.className):!1}function b(c,d){c&&d&&!a(c,d)&&(c.className=(c.className?c.className+" ":"")+d)}function c(b,d){b&&d&&a(b,d)&&(b.className=b.className.replace(new RegExp("( "+d+")|("+d+")","g"),""))}return{has:a,add:b,remove:c,swap:function(a,f,p){var l={className:a.className};c(l,f);b(l,p);a.className=l.className},toggle:function(g,f){var p;p=a(g,f);(p?c:b)(g,f);return!p}}}(),dom:function(){function a(b,c){var g,f,p;1===arguments.length?(g=document.documentElement,f=b):(g=b,f=
c);g&&g.querySelectorAll&&(p=g.querySelectorAll(f));return p}return{get:function(){var b=a.apply(this,arguments);return b&&b.length?b[b.length-1]:b&&0===b.length?null:b},getAll:a}}(),position:function(){return{getOffX:function(a){var b=0;if(a.offsetParent)for(;a.offsetParent;)b+=a.offsetLeft,a=a.offsetParent;else a.x&&(b+=a.x);return b},getOffY:function(a){var b=0;if(a.offsetParent)for(;a.offsetParent;)b+=a.offsetTop,a=a.offsetParent;else a.y&&(b+=a.y);return b}}}(),style:function(){return{get:function(b,
c){var e;b.currentStyle?e=b.currentStyle[c]:a.getComputedStyle&&(e=document.defaultView.getComputedStyle(b,null).getPropertyValue(c));return e}}}(),events:function(){var b;b=void 0!==a.removeEventListener?function(a,b,c){return a.removeEventListener(b,c,!1)}:function(a,b,c){return a.detachEvent("on"+b,c)};return{add:function(c,e,g){a.addEventListener?c.addEventListener(e,g,!1):c.attachEvent("on"+e,g);return{detach:function(){return b(c,e,g)}}},preventDefault:function(a){a.preventDefault?a.preventDefault():
(a.returnValue=!1,a.cancelBubble=!0);return!1},remove:b}}(),features:function(){function b(a){return void 0!==p.style[a]?a:null}function c(a){try{p.style[l]=a}catch(b){return!1}return!!p.style[l]}var e,g,f,p,l;p=document.createElement("div");e=(g=a.requestAnimationFrame||a.webkitRequestAnimationFrame||a.mozRequestAnimationFrame||a.oRequestAnimationFrame||a.msRequestAnimationFrame||null)?function(){return g.apply(a,arguments)}:null;e={transform:{ie:b("-ms-transform"),opera:b("OTransform"),webkit:b("webkitTransform"),
w3:b("transform"),prop:null},rotate:{has3D:!1,prop:null},getAnimationFrame:e};e.transform.prop=e.transform.w3||e.transform.moz||e.transform.webkit||e.transform.ie||e.transform.opera;e.transform.prop&&(l=e.transform.prop,c("rotate3d(0,0,0,0deg)")?(e.rotate.has3D=!0,f="rotate3d"):c("rotate(0deg)")&&(f="rotate"),e.rotate.prop=f);p=null;return e}()};soundManager.setup({html5PollingInterval:50,flashVersion:9});soundManager.onready(function(){var a,d,e,g;if((a=k.dom.getAll(".turntable"))&&a.length)for(d=
0,e=a.length;d<e;d++)g=new c(a[d]),b.push(g),f[g.id]=g});a.turntables=b;a.turntablesById=f;a.turntables.utils=k})(window);
(function(a){var c;function b(a){return a&&soundManager.canPlayLink(a)&&(!d.requireCSS||q.css.has(a,d.requireCSS))&&(!d.excludeCSS||!q.css.has(a,d.excludeCSS))}function f(){var a,b;n.on.start=function(a){soundManager.play(a.id,d.soundOptions)};n.on.stop=function(a){soundManager.pause(a.id);e.endOfRecordNoise&&e.endOfRecordNoise.stop()};if(t.load.bind)for(a=0,b=n.length;a<b;a++)n[a].methods.load=t.load.bind(n[a]);n.config=d}var n,k,q,d,e,g,t,p;d={requireCSS:null,excludeCSS:"turntable-exclude",playNext:!0,
hasRecordAtStart:!1,useEndOfRecordNoise:!0,endOfRecordNoise:["audio/record-noise-1.mp3","audio/record-noise-2.mp3"],htmlAttribute:"data-turntable",turntable:{tonearm:{angleToRecord:16,recordAngleSpan:26}},soundOptions:{multiShot:!1,onload:function(a){a||this.duration||k.sound.error.apply(this,arguments)},whileplaying:function(){k.sound.whileplaying.apply(this,arguments)},onfinish:function(){k.sound.finish.apply(this,arguments)}}};c=[];e={endOfRecordNoise:null,soundFinished:!1,lastLink:null};g=navigator.userAgent.match(/iphone|ipad|android|tablet|mobile/i);
k={mouse:{click:function(a){var c,d;c=a.target;if((!c||"A"!==c.nodeName)&&c&&c.parentNode){do c=c.parentNode;while(c&&"A"!==c.nodeName&&c.parentNode)}return b(c)?(d=c.getAttribute("data-turntable"),d=turntablesById[d]||n[0],e.lastLink=c,p(d,c.href),d.methods.setArtwork(c.getAttribute("data-artwork")||""),q.events.preventDefault(a),!1):!0}},sound:{whileplaying:function(){var a=this.position/this.durationEstimate;0<=a&&this._turntable&&this._turntable.methods.setTonearmAngle(d.turntable.tonearm.angleToRecord+
d.turntable.tonearm.recordAngleSpan*a)},error:function(){a.console&&console.warn&&console.warn("Turntable failed to load "+this.url);k.sound.finish.apply(this)},finish:function(){var a;e.finished=!0;if(d.playNext){a=e.lastLink;var h,m,g,f,p,n,q;q=a.getAttribute(d.htmlAttribute);f=document.getElementsByTagName("a");p=[];m=0;for(g=f.length;m<g;m++)if(b(f[m])&&(!q||f[m].getAttribute(d.htmlAttribute)===q)){p.push(f[m]);if(h){n=f[m];break}a===f[m]&&(h=!0)}h||(n=p[0]);n===a&&(n=null);(a=n)&&k.mouse.click({target:a})}!a&&
this._turntable&&(d.useEndOfRecordNoise&&c.length?(this._turntable.methods.setTonearmAngle(d.turntable.tonearm.angleToRecord+d.turntable.tonearm.recordAngleSpan),e.endOfRecordNoise=c[parseInt(Math.random()*c.length,10)],e.endOfRecordNoise.play({loops:999})):this._turntable.methods.stop())}}};p=function(a,b,c){var g,f;g=a||n[0];g.id&&(f=soundManager.getSoundById(g.id,!0));f?f.url!==b&&f.stop():f=soundManager.createSound({id:g.id,url:b});e.finished=!1;f._turntable=a;d.soundOptions.url=b;e.endOfRecordNoise&&
(e.endOfRecordNoise.stop(),e.endOfRecordNoise=null);!g.data.power.motor||f.playState||c||f.play(d.soundOptions);g.methods.addSlipmat();g.methods.addRecord();c||(g.methods.powerOn(),g.methods.start(),k.sound.whileplaying.apply(f))};t={load:function(a,b){p(this,a,!0);b&&this.methods.setArtwork(b)}};soundManager.onready(function(){var b,h;if(!g&&d.useEndOfRecordNoise&&d.endOfRecordNoise.length)for(b=0,h=d.endOfRecordNoise.length;b<h;b++)c.push(soundManager.createSound({url:d.endOfRecordNoise[b]}));if(d.hasRecordAtStart)for(b=
0,h=n.length;b<h;b++)n[b].methods.addRecord();n=a.turntables;f();q=n.utils;q.events.add(document,"click",k.mouse.click)})})(window);
(function(){function a(a){return document.getElementById(a)}function c(b){var c=null;a("filter-box").style.display="none";g.removeClass(a("main"),"filtered");for(var d=g.getElementsByClassName("f-block",["div","dl"],a("main")),e=d.length;e--;)if(d[e].style.display="block",c=g.getParentByClassName(d[e],"columnar",a("main")))c.style.display="block";t&&g.removeClass(t,"active");b&&(t=b);return!1}function b(a,b){function c(){this.onload=this.onreadystatechange=null;window.setTimeout(b,20)}var d=function(){var a=
this.readyState;if("loaded"===a||"complete"===a)this.onload=this.onreadystatechange=null,window.setTimeout(b,20)},g=document.createElement("script");g.type="text/javascript";b&&(g.onreadystatechange=d,g.onload=c);g.src=a;document.getElementsByTagName("head")[0].appendChild(g)}function f(){if(!document.location.protocol.match(/http/i))for(var a=document.getElementsByTagName("a"),b=null,c=null,d=a.length;d--;)b=a[d].href.toString(),b.match(/http/i)||g.hasClass(a[d],"norewrite")||!(b.match(/doc/i)||
b.match(/demo/i)||b.match(/../))||(c=Math.max(b.lastIndexOf("?"),-1),c=Math.max(b.lastIndexOf("#"),c),c=Math.max(b.lastIndexOf("/")+1,c),-1===c&&(c=b.length),b.match(/\.html/i)||a[d].setAttribute("href",b.substr(0,c)+"index.html"+b.substr(c)))}function n(){if(navigator.userAgent.match(/msie 6/i)){var b=a("nav").getElementsByTagName("li")[1],c=b.getElementsByTagName("a")[0],d=b.getElementsByTagName("ul")[0];c.onclick=function(){d.style.display="block";setTimeout(function(){document.onclick=function(){d.style.display=
"none";document.onclick=null}},20);return!1}}}function k(){var b=a("version");b&&(b.innerHTML=soundManager.versionNumber)}function q(){e&&(window.XLSF_URL_BASE="demo/christmas-lights/",window.XLSF_LIGHT_CLASS="pico",b("demo/christmas-lights/christmaslights.js",function(){window.smashInit&&window.setTimeout(window.smashInit,20)}))}function d(){navigator.userAgent.match(/safari/i)&&(document.getElementsByTagName("html")[0].className="isSafari");k();n();f();b("http://www.schillmania.com/services/soundmanager2/info/?version="+
soundManager.versionNumber+"&rnd="+parseInt(1048576*Math.random(),10));soundManager.onready(function(){window.turntables&&(window.turntables.config.requireCSS="turntable-include")})}var e=document.domain.match(/schillmania.com/i)&&11===(new Date).getMonth()||window.location.toString().match(/christmas/i),g;window.init=function(){var a,b,c;b=document.getElementById("main");c=b.getElementsByTagName("dt");for(a=c.length;a--;)0===(a+1)%2&&g.addClass(c[a],"alt");c=b.getElementsByTagName("dl");for(a=c.length;a--;)0===
(a+1)%2&&g.addClass(c[a],"alt");e&&(a=document.body.className.split(" "),a.push("has-lights"),document.body.className=a.join(" "))};g=new function(){var a=this;this.hasClass=function(a,b){return"undefined"!==typeof a.className?(new RegExp("(^|\\s)"+b+"(\\s|$)")).test(a.className):!1};this.addClass=function(b,c){b&&c&&!a.hasClass(b,c)&&(b.className=(b.className?b.className+" ":"")+c)};this.removeClass=function(b,c){b&&c&&a.hasClass(b,c)&&(b.className=b.className.replace(new RegExp("( "+c+")|("+c+")",
"g"),""))};this.toggleClass=function(b,c){(a.hasClass(b,c)?a.removeClass:a.addClass)(b,c)};this.getElementsByClassName=function(b,c,d){var g=d||document;d=[];var e,f=[];if("undefined"!==typeof c&&"string"!==typeof c)for(e=c.length;e--;)f&&f[c[e]]||(f[c[e]]=g.getElementsByTagName(c[e]));else f=c?g.getElementsByTagName(c):g.all||g.getElementsByTagName("*");if("string"!==typeof c)for(e=c.length;e--;)for(g=f[c[e]].length;g--;)a.hasClass(f[c[e]][g],b)&&(d[d.length]=f[c[e]][g]);else for(e=0;e<f.length;e++)a.hasClass(f[e],
b)&&(d[d.length]=f[e]);return d};this.findParent=function(a){if(!a||!a.parentNode)return!1;a=a.parentNode;if(2===a.nodeType)for(;a&&a.parentNode&&2===a.parentNode.nodeType;)a=a.parentNode;return a};this.getOffY=function(a){var b=0;if(a.offsetParent)for(;a.offsetParent;)b+=a.offsetTop,a=a.offsetParent;else a.y&&(b+=a.y);return b};this.isChildOfClass=function(b,c){if(!b||!c)return!1;for(;b.parentNode&&!a.hasClass(b,c);)b=a.findParent(b);return a.hasClass(b,c)};this.getParentByClassName=function(b,c){if(!b||
!c)return!1;for(c=c.toLowerCase();b.parentNode&&!a.hasClass(b.parentNode,c);)b=a.findParent(b);return b.parentNode&&a.hasClass(b.parentNode,c)?b.parentNode:null}};var t=null;window.resetFilter=c;window.setFilter=function(b,d){var e=b?b.target||b.srcElement:window.event.srcElement;g.addClass(a("main"),"filtered");var f=e.nodeName.toLowerCase();if("a"===f){var n=g.findParent(e);n&&"li"===n.nodeName.toLowerCase()&&(e=n,f=e.nodeName.toLowerCase())}var k="",n=g.getElementsByClassName("f-block",["div",
"dl"],a("main")),q=g.getElementsByClassName("columnar","div",a("main")),y=null,z=[];if("li"===f&&"ignore"!==e.className){var B=t&&t===e&&g.hasClass(t,"active");if("li"===f&&B)"undefined"!==typeof b.preventDefault&&b.preventDefault(),c();else if("li"===f){k=e.getElementsByTagName("a").length?e.getElementsByTagName("a")[0].innerHTML:e.innerHTML;k=d+k.substr(0,-1!==k.indexOf("(")?k.indexOf("("):999).toLowerCase().replace(/\s+/i,"-");f=k.substr(k.length-1);if("-"===f||" "===f)k=k.substr(0,k.length-1);
for(f=n.length;f--;)y=g.getParentByClassName(n[f],"columnar",a("main")),g.hasClass(n[f],k)?(n[f].style.display="block",y&&z.push(y)):n[f].style.display="none";for(f=q.length;f--;)q[f].style.display="none";for(f=z.length;f--;)z[f].style.display="block";a("search-results").innerHTML='<h3><span class="option"><a href="#" title="Restore full content" onclick="resetFilter();return false" style="text-decoration:none"> clear filter </a></span>Content filter: '+("f-"===d?"soundManager.":"s-"===d?"[SMSound object].":
"")+'<b style="font-weight:bold">'+e.innerHTML+"</b></h3>";a("search-results").style.display="block";a("filter-box").style.display="block";B?(a("filter-box").style.paddingBottom="0px",a("filter-box").style.display="none"):(a("filter-box").style.paddingBottom="0px",navigator.userAgent.match(/msie/i)||(a("filter-box").style.paddingBottom=Math.max(0,(document.documentElement.scrollTop||window.scrollY)-g.getOffY(a("filter-box"))-parseInt(a("filter-box").offsetHeight,10)-20)+"px"),a("filter-box").style.display=
"block");t?t===e?g.toggleClass(t,"active"):(g.removeClass(t,"active"),g.addClass(e,"active")):g.addClass(e,"active");t=e;"undefined"!==typeof b.preventDefault&&b.preventDefault()}}};window.is_home&&(soundManager.useHTML5Audio=!0,document.location.href.match(/sm2-usehtml5audio=1/i)?soundManager.useHTML5Audio=!0:document.location.href.match(/sm2-usehtml5audio=0/i)&&(soundManager.useHTML5Audio=!1),soundManager.setup({preferFlash:!1,useFlashBlock:!0,useHighPerformance:!0,bgColor:"#ffffff",debugMode:!1,
url:"swf/",wmode:"transparent"}),window.PP_CONFIG={autoStart:!1,playNext:!0,useThrottling:!1,usePeakData:!0,useWaveformData:!1,useEQData:!1,useFavIcon:!1},window.threeSixtyPlayer.config={playNext:!1,autoPlay:!1,allowMultiple:!0,loadRingColor:"#ccc",playRingColor:"#000",backgroundRingColor:"#eee",circleDiameter:256,circleRadius:128,scaleArcWidth:1,animDuration:500,animTransition:window.Animator.tx.bouncy,showHMSTime:!0,useWaveformData:!0,waveformDataColor:"#0099ff",waveformDataDownsample:2,waveformDataOutside:!1,
waveformDataConstrain:!1,waveformDataLineRatio:.73,useEQData:!0,eqDataColor:"#339933",eqDataDownsample:2,eqDataOutside:!0,eqDataLineRatio:.69,usePeakData:!0,peakDataColor:"#ff33ff",peakDataOutside:!0,peakDataLineRatio:.5,useAmplifier:!0},navigator.platform.match(/win32/i)&&navigator.userAgent.match(/firefox/i)&&(soundManager.useHighPerformance=!1),soundManager.onready(function(){a("sm2-support").style.display="none";a("sm2-support-warning").style.display="none";soundManager.didFlashBlock&&soundManager.createSound({id:"success",
url:"demo/_mp3/mouseover.mp3"}).play();q();var b,c;b=!1;c=navigator;var d=c.plugins,e,f=window.ActiveXObject;if(d&&d.length)(c=c.mimeTypes)&&c["application/x-shockwave-flash"]&&c["application/x-shockwave-flash"].enabledPlugin&&c["application/x-shockwave-flash"].enabledPlugin.description&&(b=!0);else if("undefined"!==typeof f){try{e=new f("ShockwaveFlash.ShockwaveFlash")}catch(n){}b=!!e}c=b;d=soundManager;if(d.useHTML5Audio&&d.hasHTML5){(b=document.getElementById("html5-support-li"))&&b.parentNode.removeChild(b);
e=document.createElement("div");e.id="html5-support-li";e.className="html5support";var k;b=[];f=!1;for(k in d.audioFormats)d.audioFormats.hasOwnProperty(k)&&(f=soundManager.filePattern.test("."+k),b.push('<span class="'+(d.html5[k]?"true":"false")+(!d.html5[k]&&f?" partial":"")+'" title="'+(d.html5[k]?"Native HTML5 support found":"No HTML5 support found"+(f?", using Flash fallback if present":", no Flash support either"))+'">'+(d.html5[k]?"&lt;":"")+k+(d.html5[k]?"&gt;":"")+"</span>"));e.innerHTML=
['<b>This browser\'s <em class="true">&lt;HTML5&gt;</em> vs. <em class="partial">Flash</em> support:<p style="margin:0.5em 0px 0.5em 0px"></b>',b.join(""),'<br /><b class="note">',soundManager.html5.mp3||soundManager.html5.mp4?c&&soundManager.preferFlash?'Preferring flash for MP3/MP4; try <a href="?sm2-preferFlash=0" title="Try using soundManager.preferFlash=false to have HTML5 actually play MP3/MP4 formats and depending on support, run SM2 entirely without flash." class="cta">preferFlash=false</a> for HTML5-only mode.':
soundManager.html5Only?"HTML5-only mode."+(soundManager.canPlayMIME("audio/aac")?"":' Try <a href="?sm2-preferFlash=1,flash9" title="Try using soundManager.preferFlash=true to have Flash play MP3/MP4 formats." class="cta">preferFlash=true</a> for MP4 support as needed.'):"&nbsp; Some flash required; allowing HTML5 to play MP3/MP4, as supported.</p>":"Flash is required for this browser to play MP3/MP4.","</b>"].join("");a("html5-audio-notes").appendChild(e);a("without-html5").style.display="inline"}else a("without-html5").style.display=
"none";k=navigator.userAgent;document.location.href.match(/sm2-usehtml5audio/i)||window.location.toString().match(/sm2-ignorebadua/i)||!k.match(/safari/i)||k.match(/chrome/i)||!k.match(/OS X 10_6_([3-7])/i)||(k=document.createElement("li"),k.innerHTML='<b>Note</b>: Partial HTML5 in effect. Using Flash for MP3/MP4 formats (if available) for this browser/OS due to HTML5 audio load/play failures in Safari 4 + 5 on Snow Leopard 10.6.3 - 10.6.7 (purportedly fixed in OS X 10.6.8 and 10.7 "Lion.") Issue caused by bugs in QuickTime X and/or underlying frameworks. See <a href="https://bugs.webkit.org/show_bug.cgi?id=32159#c9">bugs.webkit.org #32519</a>. (Safari on iOS, Leopard and Windows OK, however.) <p style="margin:0.5em 0px 0.5em 0px">Try <a href="?sm2-ignorebadua&sm2-usehtml5audio=1">HTML5 anyway?</a> (some MP3 playback may intermittently fail.)',
a("html5-audio-notes").appendChild(k));b=g.getElementsByClassName("button-exclude","a",a("inline-playlist")).concat(g.getElementsByClassName("exclude","a",a("graphic-playlist")));k=0;for(c=b.length;k<c;k++)soundManager.canPlayLink(b[k])||(b[k].className+=" not-supported",b[k].title+=". \n\nNOTE: "+(soundManager.useHTML5Audio?"Format apparently not supported under this configuration or browser.":"SoundManager 2's HTML5 feature is not currently enabled. (Try turning it on, see +html5 link.)"))}),soundManager.ontimeout(function(){if(!navigator.userAgent.match(/msie 6/i)){var b=
a("sm2-support"),c=a("sm2-support-warning"),d='<div style="margin:0.5em;margin-top:-0.25em"><h3>Oh snap!</h3><p>'+(soundManager.hasHTML5?"The flash portion of ":"")+"SoundManager 2 was unable to start. "+(soundManager.useHTML5Audio?soundManager.hasHTML5?"</p><p>Some HTML5 audio support is present, but flash is needed for MP3/MP4 support on this page.":"</p><p>No HTML5 support was found, so flash is required.":"")+'</p><p>All links to audio will degrade gracefully.</p><p id="flashblocker">If you have a flash blocker, try allowing the SWF to run - it may be visible below.</p><p id="flash-offline">'+
(soundManager.useAltURL?"<b>Viewing offline</b>? You may need to change a Flash security setting.":"Other possible causes: Missing .SWF, or no Flash?")+' Not to worry, as guided help is provided.</p><p><a href="doc/getstarted/index.html#troubleshooting" class="feature-hot" style="display:inline-block;margin-left:0px">Troubleshooting</a></p></div>',e=navigator.userAgent.match(/(ipad|iphone|ipod)/i);if(soundManager.html5.mp3&&soundManager.html5.mp4)soundManager._wD("Special homepage case: Flash appears to blocked, HTML5 support for MP3/MP4 exists; trying HTML5-only mode..."),
soundManager.useHTML5Audio=!0,soundManager.preferFlash=!1,setTimeout(function(){soundManager.reboot();soundManager.onready(function(){b.innerHTML='<div style="margin:0.5em;margin-top:-0.25em"><h3>Support note</h3><p>SoundManager 2 tried to start using HTML5 + Flash, but rebooted in HTML5-only mode as flash was blocked. Visualization demo features will not be shown in this mode. To enable flash, whitelist the blocked movie and reload this page.</p>'+(soundManager.useAltURL?'<p><b>Running offline?</b> Flash may be blocked due to security restrictions; see <a href="doc/getstarted/index.html#troubleshooting">troubleshooting</a> for more.':
"")+"</div>";b.style.marginBottom="1.5em";b.style.display="block"})},1);else{b.innerHTML=d;c.innerHTML='<p style="margin:0px">SoundManager 2 could not start. <a href="#sm2-support">See below</a> for details.</p>';if(e||soundManager.getMoviePercent())a("flashblocker").style.display="none",e&&(a("flash-offline").style.display="none");b.style.marginBottom="1.5em";b.style.display="block";c.style.display="inline-block"}}}));document.addEventListener?document.addEventListener("DOMContentLoaded",d,!1):window.onload=
d})();
