(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.PydioSoundManager = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
/** @license
 *
 * SoundManager 2: JavaScript Sound for the Web
 * ----------------------------------------------
 * http://schillmania.com/projects/soundmanager2/
 *
 * Copyright (c) 2007, Scott Schiller. All rights reserved.
 * Code provided under the BSD License:
 * http://schillmania.com/projects/soundmanager2/license.txt
 *
 * V2.97a.20170601
 */

/**
 * About this file
 * -------------------------------------------------------------------------------------
 * This is the fully-commented source version of the SoundManager 2 API,
 * recommended for use during development and testing.
 *
 * See soundmanager2-nodebug-jsmin.js for an optimized build (~11KB with gzip.)
 * http://schillmania.com/projects/soundmanager2/doc/getstarted/#basic-inclusion
 * Alternately, serve this file with gzip for 75% compression savings (~30KB over HTTP.)
 *
 * You may notice <d> and </d> comments in this source; these are delimiters for
 * debug blocks which are removed in the -nodebug builds, further optimizing code size.
 *
 * Also, as you may note: Whoa, reliable cross-platform/device audio support is hard! ;)
 */

(function SM2(window, _undefined) {

/* global Audio, document, window, navigator, define, module, SM2_DEFER, opera, setTimeout, setInterval, clearTimeout, sm2Debugger */

'use strict';

if (!window || !window.document) {

  // Don't cross the [environment] streams. SM2 expects to be running in a browser, not under node.js etc.
  // Additionally, if a browser somehow manages to fail this test, as Egon said: "It would be bad."

  throw new Error('SoundManager requires a browser with window and document objects.');

}

var soundManager = null;

/**
 * The SoundManager constructor.
 *
 * @constructor
 * @param {string} smURL Optional: Path to SWF files
 * @param {string} smID Optional: The ID to use for the SWF container element
 * @this {SoundManager}
 * @return {SoundManager} The new SoundManager instance
 */

function SoundManager(smURL, smID) {

  /**
   * soundManager configuration options list
   * defines top-level configuration properties to be applied to the soundManager instance (eg. soundManager.flashVersion)
   * to set these properties, use the setup() method - eg., soundManager.setup({url: '/swf/', flashVersion: 9})
   */

  this.setupOptions = {

    url: (smURL || null),             // path (directory) where SoundManager 2 SWFs exist, eg., /path/to/swfs/
    flashVersion: 8,                  // flash build to use (8 or 9.) Some API features require 9.
    debugMode: true,                  // enable debugging output (console.log() with HTML fallback)
    debugFlash: false,                // enable debugging output inside SWF, troubleshoot Flash/browser issues
    useConsole: true,                 // use console.log() if available (otherwise, writes to #soundmanager-debug element)
    consoleOnly: true,                // if console is being used, do not create/write to #soundmanager-debug
    waitForWindowLoad: false,         // force SM2 to wait for window.onload() before trying to call soundManager.onload()
    bgColor: '#ffffff',               // SWF background color. N/A when wmode = 'transparent'
    useHighPerformance: false,        // position:fixed flash movie can help increase js/flash speed, minimize lag
    flashPollingInterval: null,       // msec affecting whileplaying/loading callback frequency. If null, default of 50 msec is used.
    html5PollingInterval: null,       // msec affecting whileplaying() for HTML5 audio, excluding mobile devices. If null, native HTML5 update events are used.
    flashLoadTimeout: 1000,           // msec to wait for flash movie to load before failing (0 = infinity)
    wmode: null,                      // flash rendering mode - null, 'transparent', or 'opaque' (last two allow z-index to work)
    allowScriptAccess: 'always',      // for scripting the SWF (object/embed property), 'always' or 'sameDomain'
    useFlashBlock: false,             // *requires flashblock.css, see demos* - allow recovery from flash blockers. Wait indefinitely and apply timeout CSS to SWF, if applicable.
    useHTML5Audio: true,              // use HTML5 Audio() where API is supported (most Safari, Chrome versions), Firefox (MP3/MP4 support varies.) Ideally, transparent vs. Flash API where possible.
    forceUseGlobalHTML5Audio: false,  // if true, a single Audio() object is used for all sounds - and only one can play at a time.
    ignoreMobileRestrictions: false,  // if true, SM2 will not apply global HTML5 audio rules to mobile UAs. iOS > 7 and WebViews may allow multiple Audio() instances.
    html5Test: /^(probably|maybe)$/i, // HTML5 Audio() format support test. Use /^probably$/i; if you want to be more conservative.
    preferFlash: false,               // overrides useHTML5audio, will use Flash for MP3/MP4/AAC if present. Potential option if HTML5 playback with these formats is quirky.
    noSWFCache: false,                // if true, appends ?ts={date} to break aggressive SWF caching.
    idPrefix: 'sound'                 // if an id is not provided to createSound(), this prefix is used for generated IDs - 'sound0', 'sound1' etc.

  };

  this.defaultOptions = {

    /**
     * the default configuration for sound objects made with createSound() and related methods
     * eg., volume, auto-load behaviour and so forth
     */

    autoLoad: false,        // enable automatic loading (otherwise .load() will be called on demand with .play(), the latter being nicer on bandwidth - if you want to .load yourself, you also can)
    autoPlay: false,        // enable playing of file as soon as possible (much faster if "stream" is true)
    from: null,             // position to start playback within a sound (msec), default = beginning
    loops: 1,               // how many times to repeat the sound (position will wrap around to 0, setPosition() will break out of loop when >0)
    onid3: null,            // callback function for "ID3 data is added/available"
    onerror: null,          // callback function for "load failed" (or, playback/network/decode error under HTML5.)
    onload: null,           // callback function for "load finished"
    whileloading: null,     // callback function for "download progress update" (X of Y bytes received)
    onplay: null,           // callback for "play" start
    onpause: null,          // callback for "pause"
    onresume: null,         // callback for "resume" (pause toggle)
    whileplaying: null,     // callback during play (position update)
    onposition: null,       // object containing times and function callbacks for positions of interest
    onstop: null,           // callback for "user stop"
    onfinish: null,         // callback function for "sound finished playing"
    multiShot: true,        // let sounds "restart" or layer on top of each other when played multiple times, rather than one-shot/one at a time
    multiShotEvents: false, // fire multiple sound events (currently onfinish() only) when multiShot is enabled
    position: null,         // offset (milliseconds) to seek to within loaded sound data.
    pan: 0,                 // "pan" settings, left-to-right, -100 to 100
    playbackRate: 1,        // rate at which to play the sound (HTML5-only)
    stream: true,           // allows playing before entire file has loaded (recommended)
    to: null,               // position to end playback within a sound (msec), default = end
    type: null,             // MIME-like hint for file pattern / canPlay() tests, eg. audio/mp3
    usePolicyFile: false,   // enable crossdomain.xml request for audio on remote domains (for ID3/waveform access)
    volume: 100             // self-explanatory. 0-100, the latter being the max.

  };

  this.flash9Options = {

    /**
     * flash 9-only options,
     * merged into defaultOptions if flash 9 is being used
     */

    onfailure: null,        // callback function for when playing fails (Flash 9, MovieStar + RTMP-only)
    isMovieStar: null,      // "MovieStar" MPEG4 audio mode. Null (default) = auto detect MP4, AAC etc. based on URL. true = force on, ignore URL
    usePeakData: false,     // enable left/right channel peak (level) data
    useWaveformData: false, // enable sound spectrum (raw waveform data) - NOTE: May increase CPU load.
    useEQData: false,       // enable sound EQ (frequency spectrum data) - NOTE: May increase CPU load.
    onbufferchange: null,   // callback for "isBuffering" property change
    ondataerror: null       // callback for waveform/eq data access error (flash playing audio in other tabs/domains)

  };

  this.movieStarOptions = {

    /**
     * flash 9.0r115+ MPEG4 audio options,
     * merged into defaultOptions if flash 9+movieStar mode is enabled
     */

    bufferTime: 3,          // seconds of data to buffer before playback begins (null = flash default of 0.1 seconds - if AAC playback is gappy, try increasing.)
    serverURL: null,        // rtmp: FMS or FMIS server to connect to, required when requesting media via RTMP or one of its variants
    onconnect: null,        // rtmp: callback for connection to flash media server
    duration: null          // rtmp: song duration (msec)

  };

  this.audioFormats = {

    /**
     * determines HTML5 support + flash requirements.
     * if no support (via flash and/or HTML5) for a "required" format, SM2 will fail to start.
     * flash fallback is used for MP3 or MP4 if HTML5 can't play it (or if preferFlash = true)
     */

    mp3: {
      type: ['audio/mpeg; codecs="mp3"', 'audio/mpeg', 'audio/mp3', 'audio/MPA', 'audio/mpa-robust'],
      required: true
    },

    mp4: {
      related: ['aac', 'm4a', 'm4b'], // additional formats under the MP4 container
      type: ['audio/mp4; codecs="mp4a.40.2"', 'audio/aac', 'audio/x-m4a', 'audio/MP4A-LATM', 'audio/mpeg4-generic'],
      required: false
    },

    ogg: {
      type: ['audio/ogg; codecs=vorbis'],
      required: false
    },

    opus: {
      type: ['audio/ogg; codecs=opus', 'audio/opus'],
      required: false
    },

    wav: {
      type: ['audio/wav; codecs="1"', 'audio/wav', 'audio/wave', 'audio/x-wav'],
      required: false
    },

    flac: {
      type: ['audio/flac'],
      required: false
    }

  };

  // HTML attributes (id + class names) for the SWF container

  this.movieID = 'sm2-container';
  this.id = (smID || 'sm2movie');

  this.debugID = 'soundmanager-debug';
  this.debugURLParam = /([#?&])debug=1/i;

  // dynamic attributes

  this.versionNumber = 'V2.97a.20170601';
  this.version = null;
  this.movieURL = null;
  this.altURL = null;
  this.swfLoaded = false;
  this.enabled = false;
  this.oMC = null;
  this.sounds = {};
  this.soundIDs = [];
  this.muted = false;
  this.didFlashBlock = false;
  this.filePattern = null;

  this.filePatterns = {
    flash8: /\.mp3(\?.*)?$/i,
    flash9: /\.mp3(\?.*)?$/i
  };

  // support indicators, set at init

  this.features = {
    buffering: false,
    peakData: false,
    waveformData: false,
    eqData: false,
    movieStar: false
  };

  // flash sandbox info, used primarily in troubleshooting

  this.sandbox = {
    // <d>
    type: null,
    types: {
      remote: 'remote (domain-based) rules',
      localWithFile: 'local with file access (no internet access)',
      localWithNetwork: 'local with network (internet access only, no local access)',
      localTrusted: 'local, trusted (local+internet access)'
    },
    description: null,
    noRemote: null,
    noLocal: null
    // </d>
  };

  /**
   * format support (html5/flash)
   * stores canPlayType() results based on audioFormats.
   * eg. { mp3: boolean, mp4: boolean }
   * treat as read-only.
   */

  this.html5 = {
    usingFlash: null // set if/when flash fallback is needed
  };

  // file type support hash
  this.flash = {};

  // determined at init time
  this.html5Only = false;

  // used for special cases (eg. iPad/iPhone/palm OS?)
  this.ignoreFlash = false;

  /**
   * a few private internals (OK, a lot. :D)
   */

  var SMSound,
  sm2 = this, globalHTML5Audio = null, flash = null, sm = 'soundManager', smc = sm + ': ', h5 = 'HTML5::', id, ua = navigator.userAgent, wl = window.location.href.toString(), doc = document, doNothing, setProperties, init, fV, on_queue = [], debugOpen = true, debugTS, didAppend = false, appendSuccess = false, didInit = false, disabled = false, windowLoaded = false, _wDS, wdCount = 0, initComplete, mixin, assign, extraOptions, addOnEvent, processOnEvents, initUserOnload, delayWaitForEI, waitForEI, rebootIntoHTML5, setVersionInfo, handleFocus, strings, initMovie, domContentLoaded, winOnLoad, didDCLoaded, getDocument, createMovie, catchError, setPolling, initDebug, debugLevels = ['log', 'info', 'warn', 'error'], defaultFlashVersion = 8, disableObject, failSafely, normalizeMovieURL, oRemoved = null, oRemovedHTML = null, str, flashBlockHandler, getSWFCSS, swfCSS, toggleDebug, loopFix, policyFix, complain, idCheck, waitingForEI = false, initPending = false, startTimer, stopTimer, timerExecute, h5TimerCount = 0, h5IntervalTimer = null, parseURL, messages = [],
  canIgnoreFlash, needsFlash = null, featureCheck, html5OK, html5CanPlay, html5ErrorCodes, html5Ext, html5Unload, domContentLoadedIE, testHTML5, event, slice = Array.prototype.slice, useGlobalHTML5Audio = false, lastGlobalHTML5URL, hasFlash, detectFlash, badSafariFix, html5_events, showSupport, flushMessages, wrapCallback, idCounter = 0, didSetup, msecScale = 1000,
  is_iDevice = ua.match(/(ipad|iphone|ipod)/i), isAndroid = ua.match(/android/i), isIE = ua.match(/msie|trident/i),
  isWebkit = ua.match(/webkit/i),
  isSafari = (ua.match(/safari/i) && !ua.match(/chrome/i)),
  isOpera = (ua.match(/opera/i)),
  mobileHTML5 = (ua.match(/(mobile|pre\/|xoom)/i) || is_iDevice || isAndroid),
  isBadSafari = (!wl.match(/usehtml5audio/i) && !wl.match(/sm2-ignorebadua/i) && isSafari && !ua.match(/silk/i) && ua.match(/OS\sX\s10_6_([3-7])/i)), // Safari 4 and 5 (excluding Kindle Fire, "Silk") occasionally fail to load/play HTML5 audio on Snow Leopard 10.6.3 through 10.6.7 due to bug(s) in QuickTime X and/or other underlying frameworks. :/ Confirmed bug. https://bugs.webkit.org/show_bug.cgi?id=32159
  hasConsole = (window.console !== _undefined && console.log !== _undefined),
  isFocused = (doc.hasFocus !== _undefined ? doc.hasFocus() : null),
  tryInitOnFocus = (isSafari && (doc.hasFocus === _undefined || !doc.hasFocus())),
  okToDisable = !tryInitOnFocus,
  flashMIME = /(mp3|mp4|mpa|m4a|m4b)/i,
  emptyURL = 'about:blank', // safe URL to unload, or load nothing from (flash 8 + most HTML5 UAs)
  emptyWAV = 'data:audio/wave;base64,/UklGRiYAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQIAAAD//w==', // tiny WAV for HTML5 unloading
  overHTTP = (doc.location ? doc.location.protocol.match(/http/i) : null),
  http = (!overHTTP ? '//' : ''),
  // mp3, mp4, aac etc.
  netStreamMimeTypes = /^\s*audio\/(?:x-)?(?:mpeg4|aac|flv|mov|mp4|m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,
  // Flash v9.0r115+ "moviestar" formats
  netStreamTypes = ['mpeg4', 'aac', 'flv', 'mov', 'mp4', 'm4v', 'f4v', 'm4a', 'm4b', 'mp4v', '3gp', '3g2'],
  netStreamPattern = new RegExp('\\.(' + netStreamTypes.join('|') + ')(\\?.*)?$', 'i');

  this.mimePattern = /^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i; // default mp3 set

  // use altURL if not "online"
  this.useAltURL = !overHTTP;

  swfCSS = {
    swfBox: 'sm2-object-box',
    swfDefault: 'movieContainer',
    swfError: 'swf_error', // SWF loaded, but SM2 couldn't start (other error)
    swfTimedout: 'swf_timedout',
    swfLoaded: 'swf_loaded',
    swfUnblocked: 'swf_unblocked', // or loaded OK
    sm2Debug: 'sm2_debug',
    highPerf: 'high_performance',
    flashDebug: 'flash_debug'
  };

  /**
   * HTML5 error codes, per W3C
   * Error code 1, MEDIA_ERR_ABORTED: Client aborted download at user's request.
   * Error code 2, MEDIA_ERR_NETWORK: A network error of some description caused the user agent to stop fetching the media resource, after the resource was established to be usable.
   * Error code 3, MEDIA_ERR_DECODE: An error of some description occurred while decoding the media resource, after the resource was established to be usable.
   * Error code 4, MEDIA_ERR_SRC_NOT_SUPPORTED: Media (audio file) not supported ("not usable.")
   * Reference: https://html.spec.whatwg.org/multipage/embedded-content.html#error-codes
   */
  html5ErrorCodes = [
    null,
    'MEDIA_ERR_ABORTED',
    'MEDIA_ERR_NETWORK',
    'MEDIA_ERR_DECODE',
    'MEDIA_ERR_SRC_NOT_SUPPORTED'
  ];

  /**
   * basic HTML5 Audio() support test
   * try...catch because of IE 9 "not implemented" nonsense
   * https://github.com/Modernizr/Modernizr/issues/224
   */

  this.hasHTML5 = (function() {
    try {
      // new Audio(null) for stupid Opera 9.64 case, which throws not_enough_arguments exception otherwise.
      return (Audio !== _undefined && (isOpera && opera !== _undefined && opera.version() < 10 ? new Audio(null) : new Audio()).canPlayType !== _undefined);
    } catch(e) {
      return false;
    }
  }());

  /**
   * Public SoundManager API
   * -----------------------
   */

  /**
   * Configures top-level soundManager properties.
   *
   * @param {object} options Option parameters, eg. { flashVersion: 9, url: '/path/to/swfs/' }
   * onready and ontimeout are also accepted parameters. call soundManager.setup() to see the full list.
   */

  this.setup = function(options) {

    var noURL = (!sm2.url);

    // warn if flash options have already been applied

    if (options !== _undefined && didInit && needsFlash && sm2.ok() && (options.flashVersion !== _undefined || options.url !== _undefined || options.html5Test !== _undefined)) {
      complain(str('setupLate'));
    }

    // TODO: defer: true?

    assign(options);

    if (!useGlobalHTML5Audio) {

      if (mobileHTML5) {

        // force the singleton HTML5 pattern on mobile, by default.
        if (!sm2.setupOptions.ignoreMobileRestrictions || sm2.setupOptions.forceUseGlobalHTML5Audio) {
          messages.push(strings.globalHTML5);
          useGlobalHTML5Audio = true;
        }

      } else if (sm2.setupOptions.forceUseGlobalHTML5Audio) {

        // only apply singleton HTML5 on desktop if forced.
        messages.push(strings.globalHTML5);
        useGlobalHTML5Audio = true;

      }

    }

    if (!didSetup && mobileHTML5) {

      if (sm2.setupOptions.ignoreMobileRestrictions) {

        messages.push(strings.ignoreMobile);

      } else {

        // prefer HTML5 for mobile + tablet-like devices, probably more reliable vs. flash at this point.

        // <d>
        if (!sm2.setupOptions.useHTML5Audio || sm2.setupOptions.preferFlash) {
          // notify that defaults are being changed.
          sm2._wD(strings.mobileUA);
        }
        // </d>

        sm2.setupOptions.useHTML5Audio = true;
        sm2.setupOptions.preferFlash = false;

        if (is_iDevice) {

          // no flash here.
          sm2.ignoreFlash = true;

        } else if ((isAndroid && !ua.match(/android\s2\.3/i)) || !isAndroid) {

          /**
           * Android devices tend to work better with a single audio instance, specifically for chained playback of sounds in sequence.
           * Common use case: exiting sound onfinish() -> createSound() -> play()
           * Presuming similar restrictions for other mobile, non-Android, non-iOS devices.
           */

          // <d>
          sm2._wD(strings.globalHTML5);
          // </d>

          useGlobalHTML5Audio = true;

        }

      }

    }

    // special case 1: "Late setup". SM2 loaded normally, but user didn't assign flash URL eg., setup({url:...}) before SM2 init. Treat as delayed init.

    if (options) {

      if (noURL && didDCLoaded && options.url !== _undefined) {
        sm2.beginDelayedInit();
      }

      // special case 2: If lazy-loading SM2 (DOMContentLoaded has already happened) and user calls setup() with url: parameter, try to init ASAP.

      if (!didDCLoaded && options.url !== _undefined && doc.readyState === 'complete') {
        setTimeout(domContentLoaded, 1);
      }

    }

    didSetup = true;

    return sm2;

  };

  this.ok = function() {

    return (needsFlash ? (didInit && !disabled) : (sm2.useHTML5Audio && sm2.hasHTML5));

  };

  this.supported = this.ok; // legacy

  this.getMovie = function(movie_id) {

    // safety net: some old browsers differ on SWF references, possibly related to ExternalInterface / flash version
    return id(movie_id) || doc[movie_id] || window[movie_id];

  };

  /**
   * Creates a SMSound sound object instance. Can also be overloaded, e.g., createSound('mySound', '/some.mp3');
   *
   * @param {object} oOptions Sound options (at minimum, url parameter is required.)
   * @return {object} SMSound The new SMSound object.
   */

  this.createSound = function(oOptions, _url) {

    var cs, cs_string, options, oSound = null;

    // <d>
    cs = sm + '.createSound(): ';
    cs_string = cs + str(!didInit ? 'notReady' : 'notOK');
    // </d>

    if (!didInit || !sm2.ok()) {
      complain(cs_string);
      return false;
    }

    if (_url !== _undefined) {
      // function overloading in JS! :) ... assume simple createSound(id, url) use case.
      oOptions = {
        id: oOptions,
        url: _url
      };
    }

    // inherit from defaultOptions
    options = mixin(oOptions);

    options.url = parseURL(options.url);

    // generate an id, if needed.
    if (options.id === _undefined) {
      options.id = sm2.setupOptions.idPrefix + (idCounter++);
    }

    // <d>
    if (options.id.toString().charAt(0).match(/^[0-9]$/)) {
      sm2._wD(cs + str('badID', options.id), 2);
    }

    sm2._wD(cs + options.id + (options.url ? ' (' + options.url + ')' : ''), 1);
    // </d>

    if (idCheck(options.id, true)) {
      sm2._wD(cs + options.id + ' exists', 1);
      return sm2.sounds[options.id];
    }

    function make() {

      options = loopFix(options);
      sm2.sounds[options.id] = new SMSound(options);
      sm2.soundIDs.push(options.id);
      return sm2.sounds[options.id];

    }

    if (html5OK(options)) {

      oSound = make();
      // <d>
      if (!sm2.html5Only) {
        sm2._wD(options.id + ': Using HTML5');
      }
      // </d>
      oSound._setup_html5(options);

    } else {

      if (sm2.html5Only) {
        sm2._wD(options.id + ': No HTML5 support for this sound, and no Flash. Exiting.');
        return make();
      }

      // TODO: Move HTML5/flash checks into generic URL parsing/handling function.

      if (sm2.html5.usingFlash && options.url && options.url.match(/data:/i)) {
        // data: URIs not supported by Flash, either.
        sm2._wD(options.id + ': data: URIs not supported via Flash. Exiting.');
        return make();
      }

      if (fV > 8) {
        if (options.isMovieStar === null) {
          // attempt to detect MPEG-4 formats
          options.isMovieStar = !!(options.serverURL || (options.type ? options.type.match(netStreamMimeTypes) : false) || (options.url && options.url.match(netStreamPattern)));
        }
        // <d>
        if (options.isMovieStar) {
          sm2._wD(cs + 'using MovieStar handling');
          if (options.loops > 1) {
            _wDS('noNSLoop');
          }
        }
        // </d>
      }

      options = policyFix(options, cs);
      oSound = make();

      if (fV === 8) {
        flash._createSound(options.id, options.loops || 1, options.usePolicyFile);
      } else {
        flash._createSound(options.id, options.url, options.usePeakData, options.useWaveformData, options.useEQData, options.isMovieStar, (options.isMovieStar ? options.bufferTime : false), options.loops || 1, options.serverURL, options.duration || null, options.autoPlay, true, options.autoLoad, options.usePolicyFile);
        if (!options.serverURL) {
          // We are connected immediately
          oSound.connected = true;
          if (options.onconnect) {
            options.onconnect.apply(oSound);
          }
        }
      }

      if (!options.serverURL && (options.autoLoad || options.autoPlay)) {
        // call load for non-rtmp streams
        oSound.load(options);
      }

    }

    // rtmp will play in onconnect
    if (!options.serverURL && options.autoPlay) {
      oSound.play();
    }

    return oSound;

  };

  /**
   * Destroys a SMSound sound object instance.
   *
   * @param {string} sID The ID of the sound to destroy
   */

  this.destroySound = function(sID, _bFromSound) {

    // explicitly destroy a sound before normal page unload, etc.

    if (!idCheck(sID)) return false;

    var oS = sm2.sounds[sID], i;

    oS.stop();

    // Disable all callbacks after stop(), when the sound is being destroyed
    oS._iO = {};

    oS.unload();

    for (i = 0; i < sm2.soundIDs.length; i++) {
      if (sm2.soundIDs[i] === sID) {
        sm2.soundIDs.splice(i, 1);
        break;
      }
    }

    if (!_bFromSound) {
      // ignore if being called from SMSound instance
      oS.destruct(true);
    }

    oS = null;
    delete sm2.sounds[sID];

    return true;

  };

  /**
   * Calls the load() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {object} oOptions Optional: Sound options
   */

  this.load = function(sID, oOptions) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].load(oOptions);

  };

  /**
   * Calls the unload() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   */

  this.unload = function(sID) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].unload();

  };

  /**
   * Calls the onPosition() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {number} nPosition The position to watch for
   * @param {function} oMethod The relevant callback to fire
   * @param {object} oScope Optional: The scope to apply the callback to
   * @return {SMSound} The SMSound object
   */

  this.onPosition = function(sID, nPosition, oMethod, oScope) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].onposition(nPosition, oMethod, oScope);

  };

  // legacy/backwards-compability: lower-case method name
  this.onposition = this.onPosition;

  /**
   * Calls the clearOnPosition() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {number} nPosition The position to watch for
   * @param {function} oMethod Optional: The relevant callback to fire
   * @return {SMSound} The SMSound object
   */

  this.clearOnPosition = function(sID, nPosition, oMethod) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].clearOnPosition(nPosition, oMethod);

  };

  /**
   * Calls the play() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {object} oOptions Optional: Sound options
   * @return {SMSound} The SMSound object
   */

  this.play = function(sID, oOptions) {

    var result = null,
        // legacy function-overloading use case: play('mySound', '/path/to/some.mp3');
        overloaded = (oOptions && !(oOptions instanceof Object));

    if (!didInit || !sm2.ok()) {
      complain(sm + '.play(): ' + str(!didInit ? 'notReady' : 'notOK'));
      return false;
    }

    if (!idCheck(sID, overloaded)) {

      // no sound found for the given ID. Bail.
      if (!overloaded) return false;

      if (overloaded) {
        oOptions = {
          url: oOptions
        };
      }

      if (oOptions && oOptions.url) {
        // overloading use case, create+play: .play('someID', {url:'/path/to.mp3'});
        sm2._wD(sm + '.play(): Attempting to create "' + sID + '"', 1);
        oOptions.id = sID;
        result = sm2.createSound(oOptions).play();
      }

    } else if (overloaded) {

      // existing sound object case
      oOptions = {
        url: oOptions
      };

    }

    if (result === null) {
      // default case
      result = sm2.sounds[sID].play(oOptions);
    }

    return result;

  };

  // just for convenience
  this.start = this.play;

  /**
   * Calls the setPlaybackRate() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.setPlaybackRate = function(sID, rate, allowOverride) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].setPlaybackRate(rate, allowOverride);

  };

  /**
   * Calls the setPosition() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {number} nMsecOffset Position (milliseconds)
   * @return {SMSound} The SMSound object
   */

  this.setPosition = function(sID, nMsecOffset) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].setPosition(nMsecOffset);

  };

  /**
   * Calls the stop() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.stop = function(sID) {

    if (!idCheck(sID)) return false;

    sm2._wD(sm + '.stop(' + sID + ')', 1);

    return sm2.sounds[sID].stop();

  };

  /**
   * Stops all currently-playing sounds.
   */

  this.stopAll = function() {

    var oSound;
    sm2._wD(sm + '.stopAll()', 1);

    for (oSound in sm2.sounds) {
      if (sm2.sounds.hasOwnProperty(oSound)) {
        // apply only to sound objects
        sm2.sounds[oSound].stop();
      }
    }

  };

  /**
   * Calls the pause() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.pause = function(sID) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].pause();

  };

  /**
   * Pauses all currently-playing sounds.
   */

  this.pauseAll = function() {

    var i;
    for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
      sm2.sounds[sm2.soundIDs[i]].pause();
    }

  };

  /**
   * Calls the resume() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.resume = function(sID) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].resume();

  };

  /**
   * Resumes all currently-paused sounds.
   */

  this.resumeAll = function() {

    var i;
    for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
      sm2.sounds[sm2.soundIDs[i]].resume();
    }

  };

  /**
   * Calls the togglePause() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.togglePause = function(sID) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].togglePause();

  };

  /**
   * Calls the setPan() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @param {number} nPan The pan value (-100 to 100)
   * @return {SMSound} The SMSound object
   */

  this.setPan = function(sID, nPan) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].setPan(nPan);

  };

  /**
   * Calls the setVolume() method of a SMSound object by ID
   * Overloaded case: pass only volume argument eg., setVolume(50) to apply to all sounds.
   *
   * @param {string} sID The ID of the sound
   * @param {number} nVol The volume value (0 to 100)
   * @return {SMSound} The SMSound object
   */

  this.setVolume = function(sID, nVol) {

    // setVolume(50) function overloading case - apply to all sounds

    var i, j;

    if (sID !== _undefined && !isNaN(sID) && nVol === _undefined) {
      for (i = 0, j = sm2.soundIDs.length; i < j; i++) {
        sm2.sounds[sm2.soundIDs[i]].setVolume(sID);
      }
      return false;
    }

    // setVolume('mySound', 50) case

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].setVolume(nVol);

  };

  /**
   * Calls the mute() method of either a single SMSound object by ID, or all sound objects.
   *
   * @param {string} sID Optional: The ID of the sound (if omitted, all sounds will be used.)
   */

  this.mute = function(sID) {

    var i = 0;

    if (sID instanceof String) {
      sID = null;
    }

    if (!sID) {

      sm2._wD(sm + '.mute(): Muting all sounds');
      for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
        sm2.sounds[sm2.soundIDs[i]].mute();
      }
      sm2.muted = true;

    } else {

      if (!idCheck(sID)) return false;

      sm2._wD(sm + '.mute(): Muting "' + sID + '"');
      return sm2.sounds[sID].mute();

    }

    return true;

  };

  /**
   * Mutes all sounds.
   */

  this.muteAll = function() {

    sm2.mute();

  };

  /**
   * Calls the unmute() method of either a single SMSound object by ID, or all sound objects.
   *
   * @param {string} sID Optional: The ID of the sound (if omitted, all sounds will be used.)
   */

  this.unmute = function(sID) {

    var i;

    if (sID instanceof String) {
      sID = null;
    }

    if (!sID) {

      sm2._wD(sm + '.unmute(): Unmuting all sounds');
      for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
        sm2.sounds[sm2.soundIDs[i]].unmute();
      }
      sm2.muted = false;

    } else {

      if (!idCheck(sID)) return false;

      sm2._wD(sm + '.unmute(): Unmuting "' + sID + '"');

      return sm2.sounds[sID].unmute();

    }

    return true;

  };

  /**
   * Unmutes all sounds.
   */

  this.unmuteAll = function() {

    sm2.unmute();

  };

  /**
   * Calls the toggleMute() method of a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.toggleMute = function(sID) {

    if (!idCheck(sID)) return false;

    return sm2.sounds[sID].toggleMute();

  };

  /**
   * Retrieves the memory used by the flash plugin.
   *
   * @return {number} The amount of memory in use
   */

  this.getMemoryUse = function() {

    // flash-only
    var ram = 0;

    if (flash && fV !== 8) {
      ram = parseInt(flash._getMemoryUse(), 10);
    }

    return ram;

  };

  /**
   * Undocumented: NOPs soundManager and all SMSound objects.
   */

  this.disable = function(bNoDisable) {

    // destroy all functions
    var i;

    if (bNoDisable === _undefined) {
      bNoDisable = false;
    }

    // already disabled?
    if (disabled) return false;

    disabled = true;

    _wDS('shutdown', 1);

    for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
      disableObject(sm2.sounds[sm2.soundIDs[i]]);
    }

    disableObject(sm2);

    // fire "complete", despite fail
    initComplete(bNoDisable);

    event.remove(window, 'load', initUserOnload);

    return true;

  };

  /**
   * Determines playability of a MIME type, eg. 'audio/mp3'.
   */

  this.canPlayMIME = function(sMIME) {

    var result;

    if (sm2.hasHTML5) {
      result = html5CanPlay({
        type: sMIME
      });
    }

    if (!result && needsFlash) {
      // if flash 9, test netStream (movieStar) types as well.
      result = (sMIME && sm2.ok() ? !!((fV > 8 ? sMIME.match(netStreamMimeTypes) : null) || sMIME.match(sm2.mimePattern)) : null); // TODO: make less "weird" (per JSLint)
    }

    return result;

  };

  /**
   * Determines playability of a URL based on audio support.
   *
   * @param {string} sURL The URL to test
   * @return {boolean} URL playability
   */

  this.canPlayURL = function(sURL) {

    var result;

    if (sm2.hasHTML5) {
      result = html5CanPlay({
        url: sURL
      });
    }

    if (!result && needsFlash) {
      result = (sURL && sm2.ok() ? !!(sURL.match(sm2.filePattern)) : null);
    }

    return result;

  };

  /**
   * Determines playability of an HTML DOM &lt;a&gt; object (or similar object literal) based on audio support.
   *
   * @param {object} oLink an HTML DOM &lt;a&gt; object or object literal including href and/or type attributes
   * @return {boolean} URL playability
   */

  this.canPlayLink = function(oLink) {

    if (oLink.type !== _undefined && oLink.type && sm2.canPlayMIME(oLink.type)) return true;

    return sm2.canPlayURL(oLink.href);

  };

  /**
   * Retrieves a SMSound object by ID.
   *
   * @param {string} sID The ID of the sound
   * @return {SMSound} The SMSound object
   */

  this.getSoundById = function(sID, _suppressDebug) {

    if (!sID) return null;

    var result = sm2.sounds[sID];

    // <d>
    if (!result && !_suppressDebug) {
      sm2._wD(sm + '.getSoundById(): Sound "' + sID + '" not found.', 2);
    }
    // </d>

    return result;

  };

  /**
   * Queues a callback for execution when SoundManager has successfully initialized.
   *
   * @param {function} oMethod The callback method to fire
   * @param {object} oScope Optional: The scope to apply to the callback
   */

  this.onready = function(oMethod, oScope) {

    var sType = 'onready',
        result = false;

    if (typeof oMethod === 'function') {

      // <d>
      if (didInit) {
        sm2._wD(str('queue', sType));
      }
      // </d>

      if (!oScope) {
        oScope = window;
      }

      addOnEvent(sType, oMethod, oScope);
      processOnEvents();

      result = true;

    } else {

      throw str('needFunction', sType);

    }

    return result;

  };

  /**
   * Queues a callback for execution when SoundManager has failed to initialize.
   *
   * @param {function} oMethod The callback method to fire
   * @param {object} oScope Optional: The scope to apply to the callback
   */

  this.ontimeout = function(oMethod, oScope) {

    var sType = 'ontimeout',
        result = false;

    if (typeof oMethod === 'function') {

      // <d>
      if (didInit) {
        sm2._wD(str('queue', sType));
      }
      // </d>

      if (!oScope) {
        oScope = window;
      }

      addOnEvent(sType, oMethod, oScope);
      processOnEvents({ type: sType });

      result = true;

    } else {

      throw str('needFunction', sType);

    }

    return result;

  };

  /**
   * Writes console.log()-style debug output to a console or in-browser element.
   * Applies when debugMode = true
   *
   * @param {string} sText The console message
   * @param {object} nType Optional log level (number), or object. Number case: Log type/style where 0 = 'info', 1 = 'warn', 2 = 'error'. Object case: Object to be dumped.
   */

  this._writeDebug = function(sText, sTypeOrObject) {

    // pseudo-private console.log()-style output
    // <d>

    var sDID = 'soundmanager-debug', o, oItem;

    if (!sm2.setupOptions.debugMode) return false;

    if (hasConsole && sm2.useConsole) {
      if (sTypeOrObject && typeof sTypeOrObject === 'object') {
        // object passed; dump to console.
        console.log(sText, sTypeOrObject);
      } else if (debugLevels[sTypeOrObject] !== _undefined) {
        console[debugLevels[sTypeOrObject]](sText);
      } else {
        console.log(sText);
      }
      if (sm2.consoleOnly) return true;
    }

    o = id(sDID);

    if (!o) return false;

    oItem = doc.createElement('div');

    if (++wdCount % 2 === 0) {
      oItem.className = 'sm2-alt';
    }

    if (sTypeOrObject === _undefined) {
      sTypeOrObject = 0;
    } else {
      sTypeOrObject = parseInt(sTypeOrObject, 10);
    }

    oItem.appendChild(doc.createTextNode(sText));

    if (sTypeOrObject) {
      if (sTypeOrObject >= 2) {
        oItem.style.fontWeight = 'bold';
      }
      if (sTypeOrObject === 3) {
        oItem.style.color = '#ff3333';
      }
    }

    // top-to-bottom
    // o.appendChild(oItem);

    // bottom-to-top
    o.insertBefore(oItem, o.firstChild);

    o = null;
    // </d>

    return true;

  };

  // <d>
  // last-resort debugging option
  if (wl.indexOf('sm2-debug=alert') !== -1) {
    this._writeDebug = function(sText) {
      window.alert(sText);
    };
  }
  // </d>

  // alias
  this._wD = this._writeDebug;

  /**
   * Provides debug / state information on all SMSound objects.
   */

  this._debug = function() {

    // <d>
    var i, j;
    _wDS('currentObj', 1);

    for (i = 0, j = sm2.soundIDs.length; i < j; i++) {
      sm2.sounds[sm2.soundIDs[i]]._debug();
    }
    // </d>

  };

  /**
   * Restarts and re-initializes the SoundManager instance.
   *
   * @param {boolean} resetEvents Optional: When true, removes all registered onready and ontimeout event callbacks.
   * @param {boolean} excludeInit Options: When true, does not call beginDelayedInit() (which would restart SM2).
   * @return {object} soundManager The soundManager instance.
   */

  this.reboot = function(resetEvents, excludeInit) {

    // reset some (or all) state, and re-init unless otherwise specified.

    // <d>
    if (sm2.soundIDs.length) {
      sm2._wD('Destroying ' + sm2.soundIDs.length + ' SMSound object' + (sm2.soundIDs.length !== 1 ? 's' : '') + '...');
    }
    // </d>

    var i, j, k;

    for (i = sm2.soundIDs.length - 1; i >= 0; i--) {
      sm2.sounds[sm2.soundIDs[i]].destruct();
    }

    // trash ze flash (remove from the DOM)

    if (flash) {

      try {

        if (isIE) {
          oRemovedHTML = flash.innerHTML;
        }

        oRemoved = flash.parentNode.removeChild(flash);

      } catch(e) {

        // Remove failed? May be due to flash blockers silently removing the SWF object/embed node from the DOM. Warn and continue.

        _wDS('badRemove', 2);

      }

    }

    // actually, force recreate of movie.

    oRemovedHTML = oRemoved = needsFlash = flash = null;

    sm2.enabled = didDCLoaded = didInit = waitingForEI = initPending = didAppend = appendSuccess = disabled = useGlobalHTML5Audio = sm2.swfLoaded = false;

    sm2.soundIDs = [];
    sm2.sounds = {};

    idCounter = 0;
    didSetup = false;

    if (!resetEvents) {
      // reset callbacks for onready, ontimeout etc. so that they will fire again on re-init
      for (i in on_queue) {
        if (on_queue.hasOwnProperty(i)) {
          for (j = 0, k = on_queue[i].length; j < k; j++) {
            on_queue[i][j].fired = false;
          }
        }
      }
    } else {
      // remove all callbacks entirely
      on_queue = [];
    }

    // <d>
    if (!excludeInit) {
      sm2._wD(sm + ': Rebooting...');
    }
    // </d>

    // reset HTML5 and flash canPlay test results

    sm2.html5 = {
      usingFlash: null
    };

    sm2.flash = {};

    // reset device-specific HTML/flash mode switches

    sm2.html5Only = false;
    sm2.ignoreFlash = false;

    window.setTimeout(function() {

      // by default, re-init

      if (!excludeInit) {
        sm2.beginDelayedInit();
      }

    }, 20);

    return sm2;

  };

  this.reset = function() {

    /**
     * Shuts down and restores the SoundManager instance to its original loaded state, without an explicit reboot. All onready/ontimeout handlers are removed.
     * After this call, SM2 may be re-initialized via soundManager.beginDelayedInit().
     * @return {object} soundManager The soundManager instance.
     */

    _wDS('reset');

    return sm2.reboot(true, true);

  };

  /**
   * Undocumented: Determines the SM2 flash movie's load progress.
   *
   * @return {number or null} Percent loaded, or if invalid/unsupported, null.
   */

  this.getMoviePercent = function() {

    /**
     * Interesting syntax notes...
     * Flash/ExternalInterface (ActiveX/NPAPI) bridge methods are not typeof "function" nor instanceof Function, but are still valid.
     * Furthermore, using (flash && flash.PercentLoaded) causes IE to throw "object doesn't support this property or method".
     * Thus, 'in' syntax must be used.
     */

    return (flash && 'PercentLoaded' in flash ? flash.PercentLoaded() : null);

  };

  /**
   * Additional helper for manually invoking SM2's init process after DOM Ready / window.onload().
   */

  this.beginDelayedInit = function() {

    windowLoaded = true;
    domContentLoaded();

    setTimeout(function() {

      if (initPending) return false;

      createMovie();
      initMovie();
      initPending = true;

      return true;

    }, 20);

    delayWaitForEI();

  };

  /**
   * Destroys the SoundManager instance and all SMSound instances.
   */

  this.destruct = function() {

    sm2._wD(sm + '.destruct()');
    sm2.disable(true);

  };

  /**
   * SMSound() (sound object) constructor
   * ------------------------------------
   *
   * @param {object} oOptions Sound options (id and url are required attributes)
   * @return {SMSound} The new SMSound object
   */

  SMSound = function(oOptions) {

    var s = this, resetProperties, add_html5_events, remove_html5_events, stop_html5_timer, start_html5_timer, attachOnPosition, onplay_called = false, onPositionItems = [], onPositionFired = 0, detachOnPosition, applyFromTo, lastURL = null, lastHTML5State, urlOmitted;

    lastHTML5State = {
      // tracks duration + position (time)
      duration: null,
      time: null
    };

    this.id = oOptions.id;

    // legacy
    this.sID = this.id;

    this.url = oOptions.url;
    this.options = mixin(oOptions);

    // per-play-instance-specific options
    this.instanceOptions = this.options;

    // short alias
    this._iO = this.instanceOptions;

    // assign property defaults
    this.pan = this.options.pan;
    this.volume = this.options.volume;

    // whether or not this object is using HTML5
    this.isHTML5 = false;

    // internal HTML5 Audio() object reference
    this._a = null;

    // for flash 8 special-case createSound() without url, followed by load/play with url case
    urlOmitted = (!this.url);

    /**
     * SMSound() public methods
     * ------------------------
     */

    this.id3 = {};

    /**
     * Writes SMSound object parameters to debug console
     */

    this._debug = function() {

      // <d>
      sm2._wD(s.id + ': Merged options:', s.options);
      // </d>

    };

    /**
     * Begins loading a sound per its *url*.
     *
     * @param {object} options Optional: Sound options
     * @return {SMSound} The SMSound object
     */

    this.load = function(options) {

      var oSound = null, instanceOptions;

      if (options !== _undefined) {
        s._iO = mixin(options, s.options);
      } else {
        options = s.options;
        s._iO = options;
        if (lastURL && lastURL !== s.url) {
          _wDS('manURL');
          s._iO.url = s.url;
          s.url = null;
        }
      }

      if (!s._iO.url) {
        s._iO.url = s.url;
      }

      s._iO.url = parseURL(s._iO.url);

      // ensure we're in sync
      s.instanceOptions = s._iO;

      // local shortcut
      instanceOptions = s._iO;

      sm2._wD(s.id + ': load (' + instanceOptions.url + ')');

      if (!instanceOptions.url && !s.url) {
        sm2._wD(s.id + ': load(): url is unassigned. Exiting.', 2);
        return s;
      }

      // <d>
      if (!s.isHTML5 && fV === 8 && !s.url && !instanceOptions.autoPlay) {
        // flash 8 load() -> play() won't work before onload has fired.
        sm2._wD(s.id + ': Flash 8 load() limitation: Wait for onload() before calling play().', 1);
      }
      // </d>

      if (instanceOptions.url === s.url && s.readyState !== 0 && s.readyState !== 2) {
        _wDS('onURL', 1);
        // if loaded and an onload() exists, fire immediately.
        if (s.readyState === 3 && instanceOptions.onload) {
          // assume success based on truthy duration.
          wrapCallback(s, function() {
            instanceOptions.onload.apply(s, [(!!s.duration)]);
          });
        }
        return s;
      }

      // reset a few state properties

      s.loaded = false;
      s.readyState = 1;
      s.playState = 0;
      s.id3 = {};

      // TODO: If switching from HTML5 -> flash (or vice versa), stop currently-playing audio.

      if (html5OK(instanceOptions)) {

        oSound = s._setup_html5(instanceOptions);

        if (!oSound._called_load) {

          s._html5_canplay = false;

          // TODO: review called_load / html5_canplay logic

          // if url provided directly to load(), assign it here.

          if (s.url !== instanceOptions.url) {

            sm2._wD(_wDS('manURL') + ': ' + instanceOptions.url);

            s._a.src = instanceOptions.url;

            // TODO: review / re-apply all relevant options (volume, loop, onposition etc.)

            // reset position for new URL
            s.setPosition(0);

          }

          // given explicit load call, try to preload.

          // early HTML5 implementation (non-standard)
          s._a.autobuffer = 'auto';

          // standard property, values: none / metadata / auto
          // reference: http://msdn.microsoft.com/en-us/library/ie/ff974759%28v=vs.85%29.aspx
          s._a.preload = 'auto';

          s._a._called_load = true;

        } else {

          sm2._wD(s.id + ': Ignoring request to load again');

        }

      } else {

        if (sm2.html5Only) {
          sm2._wD(s.id + ': No flash support. Exiting.');
          return s;
        }

        if (s._iO.url && s._iO.url.match(/data:/i)) {
          // data: URIs not supported by Flash, either.
          sm2._wD(s.id + ': data: URIs not supported via Flash. Exiting.');
          return s;
        }

        try {
          s.isHTML5 = false;
          s._iO = policyFix(loopFix(instanceOptions));
          // if we have "position", disable auto-play as we'll be seeking to that position at onload().
          if (s._iO.autoPlay && (s._iO.position || s._iO.from)) {
            sm2._wD(s.id + ': Disabling autoPlay because of non-zero offset case');
            s._iO.autoPlay = false;
          }
          // re-assign local shortcut
          instanceOptions = s._iO;
          if (fV === 8) {
            flash._load(s.id, instanceOptions.url, instanceOptions.stream, instanceOptions.autoPlay, instanceOptions.usePolicyFile);
          } else {
            flash._load(s.id, instanceOptions.url, !!(instanceOptions.stream), !!(instanceOptions.autoPlay), instanceOptions.loops || 1, !!(instanceOptions.autoLoad), instanceOptions.usePolicyFile);
          }
        } catch(e) {
          _wDS('smError', 2);
          debugTS('onload', false);
          catchError({
            type: 'SMSOUND_LOAD_JS_EXCEPTION',
            fatal: true
          });
        }

      }

      // after all of this, ensure sound url is up to date.
      s.url = instanceOptions.url;

      return s;

    };

    /**
     * Unloads a sound, canceling any open HTTP requests.
     *
     * @return {SMSound} The SMSound object
     */

    this.unload = function() {

      // Flash 8/AS2 can't "close" a stream - fake it by loading an empty URL
      // Flash 9/AS3: Close stream, preventing further load
      // HTML5: Most UAs will use empty URL

      if (s.readyState !== 0) {

        sm2._wD(s.id + ': unload()');

        if (!s.isHTML5) {

          if (fV === 8) {
            flash._unload(s.id, emptyURL);
          } else {
            flash._unload(s.id);
          }

        } else {

          stop_html5_timer();

          if (s._a) {

            s._a.pause();

            // update empty URL, too
            lastURL = html5Unload(s._a);

          }

        }

        // reset load/status flags
        resetProperties();

      }

      return s;

    };

    /**
     * Unloads and destroys a sound.
     */

    this.destruct = function(_bFromSM) {

      sm2._wD(s.id + ': Destruct');

      if (!s.isHTML5) {

        // kill sound within Flash
        // Disable the onfailure handler
        s._iO.onfailure = null;
        flash._destroySound(s.id);

      } else {

        stop_html5_timer();

        if (s._a) {
          s._a.pause();
          html5Unload(s._a);
          if (!useGlobalHTML5Audio) {
            remove_html5_events();
          }
          // break obvious circular reference
          s._a._s = null;
          s._a = null;
        }

      }

      if (!_bFromSM) {
        // ensure deletion from controller
        sm2.destroySound(s.id, true);
      }

    };

    /**
     * Begins playing a sound.
     *
     * @param {object} options Optional: Sound options
     * @return {SMSound} The SMSound object
     */

    this.play = function(options, _updatePlayState) {

      var fN, allowMulti, a, onready,
          audioClone, onended, oncanplay,
          startOK = true;

      // <d>
      fN = s.id + ': play(): ';
      // </d>

      // default to true
      _updatePlayState = (_updatePlayState === _undefined ? true : _updatePlayState);

      if (!options) {
        options = {};
      }

      // first, use local URL (if specified)
      if (s.url) {
        s._iO.url = s.url;
      }

      // mix in any options defined at createSound()
      s._iO = mixin(s._iO, s.options);

      // mix in any options specific to this method
      s._iO = mixin(options, s._iO);

      s._iO.url = parseURL(s._iO.url);

      s.instanceOptions = s._iO;

      // RTMP-only
      if (!s.isHTML5 && s._iO.serverURL && !s.connected) {
        if (!s.getAutoPlay()) {
          sm2._wD(fN + ' Netstream not connected yet - setting autoPlay');
          s.setAutoPlay(true);
        }
        // play will be called in onconnect()
        return s;
      }

      if (html5OK(s._iO)) {
        s._setup_html5(s._iO);
        start_html5_timer();
      }

      if (s.playState === 1 && !s.paused) {

        allowMulti = s._iO.multiShot;

        if (!allowMulti) {

          sm2._wD(fN + 'Already playing (one-shot)', 1);

          if (s.isHTML5) {
            // go back to original position.
            s.setPosition(s._iO.position);
          }

          return s;

        }

        sm2._wD(fN + 'Already playing (multi-shot)', 1);

      }

      // edge case: play() with explicit URL parameter
      if (options.url && options.url !== s.url) {

        // special case for createSound() followed by load() / play() with url; avoid double-load case.
        if (!s.readyState && !s.isHTML5 && fV === 8 && urlOmitted) {

          urlOmitted = false;

        } else {

          // load using merged options
          s.load(s._iO);

        }

      }

      if (!s.loaded) {

        if (s.readyState === 0) {

          sm2._wD(fN + 'Attempting to load');

          // try to get this sound playing ASAP
          if (!s.isHTML5 && !sm2.html5Only) {

            // flash: assign directly because setAutoPlay() increments the instanceCount
            s._iO.autoPlay = true;
            s.load(s._iO);

          } else if (s.isHTML5) {

            // iOS needs this when recycling sounds, loading a new URL on an existing object.
            s.load(s._iO);

          } else {

            sm2._wD(fN + 'Unsupported type. Exiting.');

            return s;

          }

          // HTML5 hack - re-set instanceOptions?
          s.instanceOptions = s._iO;

        } else if (s.readyState === 2) {

          sm2._wD(fN + 'Could not load - exiting', 2);

          return s;

        } else {

          sm2._wD(fN + 'Loading - attempting to play...');

        }

      } else {

        // "play()"
        sm2._wD(fN.substr(0, fN.lastIndexOf(':')));

      }

      if (!s.isHTML5 && fV === 9 && s.position > 0 && s.position === s.duration) {
        // flash 9 needs a position reset if play() is called while at the end of a sound.
        sm2._wD(fN + 'Sound at end, resetting to position: 0');
        options.position = 0;
      }

      /**
       * Streams will pause when their buffer is full if they are being loaded.
       * In this case paused is true, but the song hasn't started playing yet.
       * If we just call resume() the onplay() callback will never be called.
       * So only call resume() if the position is > 0.
       * Another reason is because options like volume won't have been applied yet.
       * For normal sounds, just resume.
       */

      if (s.paused && s.position >= 0 && (!s._iO.serverURL || s.position > 0)) {

        // https://gist.github.com/37b17df75cc4d7a90bf6
        sm2._wD(fN + 'Resuming from paused state', 1);
        s.resume();

      } else {

        s._iO = mixin(options, s._iO);

        /**
         * Preload in the event of play() with position under Flash,
         * or from/to parameters and non-RTMP case
         */
        if (((!s.isHTML5 && s._iO.position !== null && s._iO.position > 0) || (s._iO.from !== null && s._iO.from > 0) || s._iO.to !== null) && s.instanceCount === 0 && s.playState === 0 && !s._iO.serverURL) {

          onready = function() {
            // sound "canplay" or onload()
            // re-apply position/from/to to instance options, and start playback
            s._iO = mixin(options, s._iO);
            s.play(s._iO);
          };

          // HTML5 needs to at least have "canplay" fired before seeking.
          if (s.isHTML5 && !s._html5_canplay) {

            // this hasn't been loaded yet. load it first, and then do this again.
            sm2._wD(fN + 'Beginning load for non-zero offset case');

            s.load({
              // note: custom HTML5-only event added for from/to implementation.
              _oncanplay: onready
            });

          } else if (!s.isHTML5 && !s.loaded && (!s.readyState || s.readyState !== 2)) {

            // to be safe, preload the whole thing in Flash.

            sm2._wD(fN + 'Preloading for non-zero offset case');

            s.load({
              onload: onready
            });

          }

          // otherwise, we're ready to go. re-apply local options, and continue

          s._iO = applyFromTo();

        }

        // sm2._wD(fN + 'Starting to play');

        // increment instance counter, where enabled + supported
        if (!s.instanceCount || s._iO.multiShotEvents || (s.isHTML5 && s._iO.multiShot && !useGlobalHTML5Audio) || (!s.isHTML5 && fV > 8 && !s.getAutoPlay())) {
          s.instanceCount++;
        }

        // if first play and onposition parameters exist, apply them now
        if (s._iO.onposition && s.playState === 0) {
          attachOnPosition(s);
        }

        s.playState = 1;
        s.paused = false;

        s.position = (s._iO.position !== _undefined && !isNaN(s._iO.position) ? s._iO.position : 0);

        if (!s.isHTML5) {
          s._iO = policyFix(loopFix(s._iO));
        }

        if (s._iO.onplay && _updatePlayState) {
          s._iO.onplay.apply(s);
          onplay_called = true;
        }

        s.setVolume(s._iO.volume, true);
        s.setPan(s._iO.pan, true);

        if (s._iO.playbackRate !== 1) {
          s.setPlaybackRate(s._iO.playbackRate);
        }

        if (!s.isHTML5) {

          startOK = flash._start(s.id, s._iO.loops || 1, (fV === 9 ? s.position : s.position / msecScale), s._iO.multiShot || false);

          if (fV === 9 && !startOK) {
            // edge case: no sound hardware, or 32-channel flash ceiling hit.
            // applies only to Flash 9, non-NetStream/MovieStar sounds.
            // http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/media/Sound.html#play%28%29
            sm2._wD(fN + 'No sound hardware, or 32-sound ceiling hit', 2);
            if (s._iO.onplayerror) {
              s._iO.onplayerror.apply(s);
            }

          }

        } else if (s.instanceCount < 2) {

            // HTML5 single-instance case

            start_html5_timer();

            a = s._setup_html5();

            s.setPosition(s._iO.position);

            a.play();

          } else {

            // HTML5 multi-shot case

            sm2._wD(s.id + ': Cloning Audio() for instance #' + s.instanceCount + '...');

            audioClone = new Audio(s._iO.url);

            onended = function() {
              event.remove(audioClone, 'ended', onended);
              s._onfinish(s);
              // cleanup
              html5Unload(audioClone);
              audioClone = null;
            };

            oncanplay = function() {
              event.remove(audioClone, 'canplay', oncanplay);
              try {
                audioClone.currentTime = s._iO.position / msecScale;
              } catch(err) {
                complain(s.id + ': multiShot play() failed to apply position of ' + (s._iO.position / msecScale));
              }
              audioClone.play();
            };

            event.add(audioClone, 'ended', onended);

            // apply volume to clones, too
            if (s._iO.volume !== _undefined) {
              audioClone.volume = Math.max(0, Math.min(1, s._iO.volume / 100));
            }

            // playing multiple muted sounds? if you do this, you're weird ;) - but let's cover it.
            if (s.muted) {
              audioClone.muted = true;
            }

            if (s._iO.position) {
              // HTML5 audio can't seek before onplay() event has fired.
              // wait for canplay, then seek to position and start playback.
              event.add(audioClone, 'canplay', oncanplay);
            } else {
              // begin playback at currentTime: 0
              audioClone.play();
            }

          }

      }

      return s;

    };

    // just for convenience
    this.start = this.play;

    /**
     * Stops playing a sound (and optionally, all sounds)
     *
     * @param {boolean} bAll Optional: Whether to stop all sounds
     * @return {SMSound} The SMSound object
     */

    this.stop = function(bAll) {

      var instanceOptions = s._iO,
          originalPosition;

      if (s.playState === 1) {

        sm2._wD(s.id + ': stop()');

        s._onbufferchange(0);
        s._resetOnPosition(0);
        s.paused = false;

        if (!s.isHTML5) {
          s.playState = 0;
        }

        // remove onPosition listeners, if any
        detachOnPosition();

        // and "to" position, if set
        if (instanceOptions.to) {
          s.clearOnPosition(instanceOptions.to);
        }

        if (!s.isHTML5) {

          flash._stop(s.id, bAll);

          // hack for netStream: just unload
          if (instanceOptions.serverURL) {
            s.unload();
          }

        } else if (s._a) {

            originalPosition = s.position;

            // act like Flash, though
            s.setPosition(0);

            // hack: reflect old position for onstop() (also like Flash)
            s.position = originalPosition;

            // html5 has no stop()
            // NOTE: pausing means iOS requires interaction to resume.
            s._a.pause();

            s.playState = 0;

            // and update UI
            s._onTimer();

            stop_html5_timer();

          }

        s.instanceCount = 0;
        s._iO = {};

        if (instanceOptions.onstop) {
          instanceOptions.onstop.apply(s);
        }

      }

      return s;

    };

    /**
     * Undocumented/internal: Sets autoPlay for RTMP.
     *
     * @param {boolean} autoPlay state
     */

    this.setAutoPlay = function(autoPlay) {

      sm2._wD(s.id + ': Autoplay turned ' + (autoPlay ? 'on' : 'off'));
      s._iO.autoPlay = autoPlay;

      if (!s.isHTML5) {
        flash._setAutoPlay(s.id, autoPlay);
        if (autoPlay) {
          // only increment the instanceCount if the sound isn't loaded (TODO: verify RTMP)
          if (!s.instanceCount && s.readyState === 1) {
            s.instanceCount++;
            sm2._wD(s.id + ': Incremented instance count to ' + s.instanceCount);
          }
        }
      }

    };

    /**
     * Undocumented/internal: Returns the autoPlay boolean.
     *
     * @return {boolean} The current autoPlay value
     */

    this.getAutoPlay = function() {

      return s._iO.autoPlay;

    };

    /**
     * Sets the playback rate of a sound (HTML5-only.)
     *
     * @param {number} playbackRate (+/-)
     * @return {SMSound} The SMSound object
     */

    this.setPlaybackRate = function(playbackRate) {

      // Per Mozilla, limit acceptable values to prevent playback from stopping (unless allowOverride is truthy.)
      // https://developer.mozilla.org/en-US/Apps/Build/Audio_and_video_delivery/WebAudio_playbackRate_explained
      var normalizedRate = Math.max(0.5, Math.min(4, playbackRate));

      // <d>
      if (normalizedRate !== playbackRate) {
        sm2._wD(s.id + ': setPlaybackRate(' + playbackRate + '): limiting rate to ' + normalizedRate, 2);
      }
      // </d>

      if (s.isHTML5) {
        try {
          s._iO.playbackRate = normalizedRate;
          s._a.playbackRate = normalizedRate;
        } catch(e) {
          sm2._wD(s.id + ': setPlaybackRate(' + normalizedRate + ') failed: ' + e.message, 2);
        }
      }

      return s;

    };

    /**
     * Sets the position of a sound.
     *
     * @param {number} nMsecOffset Position (milliseconds)
     * @return {SMSound} The SMSound object
     */

    this.setPosition = function(nMsecOffset) {

      if (nMsecOffset === _undefined) {
        nMsecOffset = 0;
      }

      var position, position1K,
          // Use the duration from the instance options, if we don't have a track duration yet.
          // position >= 0 and <= current available (loaded) duration
          offset = (s.isHTML5 ? Math.max(nMsecOffset, 0) : Math.min(s.duration || s._iO.duration, Math.max(nMsecOffset, 0)));

      s.position = offset;
      position1K = s.position / msecScale;
      s._resetOnPosition(s.position);
      s._iO.position = offset;

      if (!s.isHTML5) {

        position = (fV === 9 ? s.position : position1K);

        if (s.readyState && s.readyState !== 2) {
          // if paused or not playing, will not resume (by playing)
          flash._setPosition(s.id, position, (s.paused || !s.playState), s._iO.multiShot);
        }

      } else if (s._a) {

        // Set the position in the canplay handler if the sound is not ready yet
        if (s._html5_canplay) {

          if (s._a.currentTime.toFixed(3) !== position1K.toFixed(3)) {

            /**
             * DOM/JS errors/exceptions to watch out for:
             * if seek is beyond (loaded?) position, "DOM exception 11"
             * "INDEX_SIZE_ERR": DOM exception 1
             */
            sm2._wD(s.id + ': setPosition(' + position1K + ')');

            try {
              s._a.currentTime = position1K;
              if (s.playState === 0 || s.paused) {
                // allow seek without auto-play/resume
                s._a.pause();
              }
            } catch(e) {
              sm2._wD(s.id + ': setPosition(' + position1K + ') failed: ' + e.message, 2);
            }

          }

        } else if (position1K) {

          // warn on non-zero seek attempts
          sm2._wD(s.id + ': setPosition(' + position1K + '): Cannot seek yet, sound not ready', 2);
          return s;

        }

        if (s.paused) {

          // if paused, refresh UI right away by forcing update
          s._onTimer(true);

        }

      }

      return s;

    };

    /**
     * Pauses sound playback.
     *
     * @return {SMSound} The SMSound object
     */

    this.pause = function(_bCallFlash) {

      if (s.paused || (s.playState === 0 && s.readyState !== 1)) return s;

      sm2._wD(s.id + ': pause()');
      s.paused = true;

      if (!s.isHTML5) {
        if (_bCallFlash || _bCallFlash === _undefined) {
          flash._pause(s.id, s._iO.multiShot);
        }
      } else {
        s._setup_html5().pause();
        stop_html5_timer();
      }

      if (s._iO.onpause) {
        s._iO.onpause.apply(s);
      }

      return s;

    };

    /**
     * Resumes sound playback.
     *
     * @return {SMSound} The SMSound object
     */

    /**
     * When auto-loaded streams pause on buffer full they have a playState of 0.
     * We need to make sure that the playState is set to 1 when these streams "resume".
     * When a paused stream is resumed, we need to trigger the onplay() callback if it
     * hasn't been called already. In this case since the sound is being played for the
     * first time, I think it's more appropriate to call onplay() rather than onresume().
     */

    this.resume = function() {

      var instanceOptions = s._iO;

      if (!s.paused) return s;

      sm2._wD(s.id + ': resume()');
      s.paused = false;
      s.playState = 1;

      if (!s.isHTML5) {

        if (instanceOptions.isMovieStar && !instanceOptions.serverURL) {
          // Bizarre Webkit bug (Chrome reported via 8tracks.com dudes): AAC content paused for 30+ seconds(?) will not resume without a reposition.
          s.setPosition(s.position);
        }

        // flash method is toggle-based (pause/resume)
        flash._pause(s.id, instanceOptions.multiShot);

      } else {

        s._setup_html5().play();
        start_html5_timer();

      }

      if (!onplay_called && instanceOptions.onplay) {

        instanceOptions.onplay.apply(s);
        onplay_called = true;

      } else if (instanceOptions.onresume) {

        instanceOptions.onresume.apply(s);

      }

      return s;

    };

    /**
     * Toggles sound playback.
     *
     * @return {SMSound} The SMSound object
     */

    this.togglePause = function() {

      sm2._wD(s.id + ': togglePause()');

      if (s.playState === 0) {
        s.play({
          position: (fV === 9 && !s.isHTML5 ? s.position : s.position / msecScale)
        });
        return s;
      }

      if (s.paused) {
        s.resume();
      } else {
        s.pause();
      }

      return s;

    };

    /**
     * Sets the panning (L-R) effect.
     *
     * @param {number} nPan The pan value (-100 to 100)
     * @return {SMSound} The SMSound object
     */

    this.setPan = function(nPan, bInstanceOnly) {

      if (nPan === _undefined) {
        nPan = 0;
      }

      if (bInstanceOnly === _undefined) {
        bInstanceOnly = false;
      }

      if (!s.isHTML5) {
        flash._setPan(s.id, nPan);
      } // else { no HTML5 pan? }

      s._iO.pan = nPan;

      if (!bInstanceOnly) {
        s.pan = nPan;
        s.options.pan = nPan;
      }

      return s;

    };

    /**
     * Sets the volume.
     *
     * @param {number} nVol The volume value (0 to 100)
     * @return {SMSound} The SMSound object
     */

    this.setVolume = function(nVol, _bInstanceOnly) {

      /**
       * Note: Setting volume has no effect on iOS "special snowflake" devices.
       * Hardware volume control overrides software, and volume
       * will always return 1 per Apple docs. (iOS 4 + 5.)
       * http://developer.apple.com/library/safari/documentation/AudioVideo/Conceptual/HTML-canvas-guide/AddingSoundtoCanvasAnimations/AddingSoundtoCanvasAnimations.html
       */

      if (nVol === _undefined) {
        nVol = 100;
      }

      if (_bInstanceOnly === _undefined) {
        _bInstanceOnly = false;
      }

      if (!s.isHTML5) {

        flash._setVolume(s.id, (sm2.muted && !s.muted) || s.muted ? 0 : nVol);

      } else if (s._a) {

        if (sm2.muted && !s.muted) {
          s.muted = true;
          s._a.muted = true;
        }

        // valid range for native HTML5 Audio(): 0-1
        s._a.volume = Math.max(0, Math.min(1, nVol / 100));

      }

      s._iO.volume = nVol;

      if (!_bInstanceOnly) {
        s.volume = nVol;
        s.options.volume = nVol;
      }

      return s;

    };

    /**
     * Mutes the sound.
     *
     * @return {SMSound} The SMSound object
     */

    this.mute = function() {

      s.muted = true;

      if (!s.isHTML5) {
        flash._setVolume(s.id, 0);
      } else if (s._a) {
        s._a.muted = true;
      }

      return s;

    };

    /**
     * Unmutes the sound.
     *
     * @return {SMSound} The SMSound object
     */

    this.unmute = function() {

      s.muted = false;
      var hasIO = (s._iO.volume !== _undefined);

      if (!s.isHTML5) {
        flash._setVolume(s.id, hasIO ? s._iO.volume : s.options.volume);
      } else if (s._a) {
        s._a.muted = false;
      }

      return s;

    };

    /**
     * Toggles the muted state of a sound.
     *
     * @return {SMSound} The SMSound object
     */

    this.toggleMute = function() {

      return (s.muted ? s.unmute() : s.mute());

    };

    /**
     * Registers a callback to be fired when a sound reaches a given position during playback.
     *
     * @param {number} nPosition The position to watch for
     * @param {function} oMethod The relevant callback to fire
     * @param {object} oScope Optional: The scope to apply the callback to
     * @return {SMSound} The SMSound object
     */

    this.onPosition = function(nPosition, oMethod, oScope) {

      // TODO: basic dupe checking?

      onPositionItems.push({
        position: parseInt(nPosition, 10),
        method: oMethod,
        scope: (oScope !== _undefined ? oScope : s),
        fired: false
      });

      return s;

    };

    // legacy/backwards-compability: lower-case method name
    this.onposition = this.onPosition;

    /**
     * Removes registered callback(s) from a sound, by position and/or callback.
     *
     * @param {number} nPosition The position to clear callback(s) for
     * @param {function} oMethod Optional: Identify one callback to be removed when multiple listeners exist for one position
     * @return {SMSound} The SMSound object
     */

    this.clearOnPosition = function(nPosition, oMethod) {

      var i;

      nPosition = parseInt(nPosition, 10);

      if (isNaN(nPosition)) {
        // safety check
        return;
      }

      for (i = 0; i < onPositionItems.length; i++) {

        if (nPosition === onPositionItems[i].position) {
          // remove this item if no method was specified, or, if the method matches

          if (!oMethod || (oMethod === onPositionItems[i].method)) {

            if (onPositionItems[i].fired) {
              // decrement "fired" counter, too
              onPositionFired--;
            }

            onPositionItems.splice(i, 1);

          }

        }

      }

    };

    this._processOnPosition = function() {

      var i, item, j = onPositionItems.length;

      if (!j || !s.playState || onPositionFired >= j) return false;

      for (i = j - 1; i >= 0; i--) {

        item = onPositionItems[i];

        if (!item.fired && s.position >= item.position) {

          item.fired = true;
          onPositionFired++;
          item.method.apply(item.scope, [item.position]);

          //  reset j -- onPositionItems.length can be changed in the item callback above... occasionally breaking the loop.
          j = onPositionItems.length;

        }

      }

      return true;

    };

    this._resetOnPosition = function(nPosition) {

      // reset "fired" for items interested in this position
      var i, item, j = onPositionItems.length;

      if (!j) return false;

      for (i = j - 1; i >= 0; i--) {

        item = onPositionItems[i];

        if (item.fired && nPosition <= item.position) {
          item.fired = false;
          onPositionFired--;
        }

      }

      return true;

    };

    /**
     * SMSound() private internals
     * --------------------------------
     */

    applyFromTo = function() {

      var instanceOptions = s._iO,
          f = instanceOptions.from,
          t = instanceOptions.to,
          start, end;

      end = function() {

        // end has been reached.
        sm2._wD(s.id + ': "To" time of ' + t + ' reached.');

        // detach listener
        s.clearOnPosition(t, end);

        // stop should clear this, too
        s.stop();

      };

      start = function() {

        sm2._wD(s.id + ': Playing "from" ' + f);

        // add listener for end
        if (t !== null && !isNaN(t)) {
          s.onPosition(t, end);
        }

      };

      if (f !== null && !isNaN(f)) {

        // apply to instance options, guaranteeing correct start position.
        instanceOptions.position = f;

        // multiShot timing can't be tracked, so prevent that.
        instanceOptions.multiShot = false;

        start();

      }

      // return updated instanceOptions including starting position
      return instanceOptions;

    };

    attachOnPosition = function() {

      var item,
          op = s._iO.onposition;

      // attach onposition things, if any, now.

      if (op) {

        for (item in op) {
          if (op.hasOwnProperty(item)) {
            s.onPosition(parseInt(item, 10), op[item]);
          }
        }

      }

    };

    detachOnPosition = function() {

      var item,
          op = s._iO.onposition;

      // detach any onposition()-style listeners.

      if (op) {

        for (item in op) {
          if (op.hasOwnProperty(item)) {
            s.clearOnPosition(parseInt(item, 10));
          }
        }

      }

    };

    start_html5_timer = function() {

      if (s.isHTML5) {
        startTimer(s);
      }

    };

    stop_html5_timer = function() {

      if (s.isHTML5) {
        stopTimer(s);
      }

    };

    resetProperties = function(retainPosition) {

      if (!retainPosition) {
        onPositionItems = [];
        onPositionFired = 0;
      }

      onplay_called = false;

      s._hasTimer = null;
      s._a = null;
      s._html5_canplay = false;
      s.bytesLoaded = null;
      s.bytesTotal = null;
      s.duration = (s._iO && s._iO.duration ? s._iO.duration : null);
      s.durationEstimate = null;
      s.buffered = [];

      // legacy: 1D array
      s.eqData = [];

      s.eqData.left = [];
      s.eqData.right = [];

      s.failures = 0;
      s.isBuffering = false;
      s.instanceOptions = {};
      s.instanceCount = 0;
      s.loaded = false;
      s.metadata = {};

      // 0 = uninitialised, 1 = loading, 2 = failed/error, 3 = loaded/success
      s.readyState = 0;

      s.muted = false;
      s.paused = false;

      s.peakData = {
        left: 0,
        right: 0
      };

      s.waveformData = {
        left: [],
        right: []
      };

      s.playState = 0;
      s.position = null;

      s.id3 = {};

    };

    resetProperties();

    /**
     * Pseudo-private SMSound internals
     * --------------------------------
     */

    this._onTimer = function(bForce) {

      /**
       * HTML5-only _whileplaying() etc.
       * called from both HTML5 native events, and polling/interval-based timers
       * mimics flash and fires only when time/duration change, so as to be polling-friendly
       */

      var duration, isNew = false, time, x = {};

      if (s._hasTimer || bForce) {

        // TODO: May not need to track readyState (1 = loading)

        if (s._a && (bForce || ((s.playState > 0 || s.readyState === 1) && !s.paused))) {

          duration = s._get_html5_duration();

          if (duration !== lastHTML5State.duration) {

            lastHTML5State.duration = duration;
            s.duration = duration;
            isNew = true;

          }

          // TODO: investigate why this goes wack if not set/re-set each time.
          s.durationEstimate = s.duration;

          time = (s._a.currentTime * msecScale || 0);

          if (time !== lastHTML5State.time) {

            lastHTML5State.time = time;
            isNew = true;

          }

          if (isNew || bForce) {

            s._whileplaying(time, x, x, x, x);

          }

        }/* else {

          // sm2._wD('_onTimer: Warn for "'+s.id+'": '+(!s._a?'Could not find element. ':'')+(s.playState === 0?'playState bad, 0?':'playState = '+s.playState+', OK'));

          return false;

        }*/

      }

      return isNew;

    };

    this._get_html5_duration = function() {

      var instanceOptions = s._iO,
          // if audio object exists, use its duration - else, instance option duration (if provided - it's a hack, really, and should be retired) OR null
          d = (s._a && s._a.duration ? s._a.duration * msecScale : (instanceOptions && instanceOptions.duration ? instanceOptions.duration : null)),
          result = (d && !isNaN(d) && d !== Infinity ? d : null);

      return result;

    };

    this._apply_loop = function(a, nLoops) {

      /**
       * boolean instead of "loop", for webkit? - spec says string. http://www.w3.org/TR/html-markup/audio.html#audio.attrs.loop
       * note that loop is either off or infinite under HTML5, unlike Flash which allows arbitrary loop counts to be specified.
       */

      // <d>
      if (!a.loop && nLoops > 1) {
        sm2._wD('Note: Native HTML5 looping is infinite.', 1);
      }
      // </d>

      a.loop = (nLoops > 1 ? 'loop' : '');

    };

    this._setup_html5 = function(options) {

      var instanceOptions = mixin(s._iO, options),
          a = useGlobalHTML5Audio ? globalHTML5Audio : s._a,
          dURL = decodeURI(instanceOptions.url),
          sameURL;

      /**
       * "First things first, I, Poppa..." (reset the previous state of the old sound, if playing)
       * Fixes case with devices that can only play one sound at a time
       * Otherwise, other sounds in mid-play will be terminated without warning and in a stuck state
       */

      if (useGlobalHTML5Audio) {

        if (dURL === decodeURI(lastGlobalHTML5URL)) {
          // global HTML5 audio: re-use of URL
          sameURL = true;
        }

      } else if (dURL === decodeURI(lastURL)) {

        // options URL is the same as the "last" URL, and we used (loaded) it
        sameURL = true;

      }

      if (a) {

        if (a._s) {

          if (useGlobalHTML5Audio) {

            if (a._s && a._s.playState && !sameURL) {

              // global HTML5 audio case, and loading a new URL. stop the currently-playing one.
              a._s.stop();

            }

          } else if (!useGlobalHTML5Audio && dURL === decodeURI(lastURL)) {

            // non-global HTML5 reuse case: same url, ignore request
            s._apply_loop(a, instanceOptions.loops);

            return a;

          }

        }

        if (!sameURL) {

          // don't retain onPosition() stuff with new URLs.

          if (lastURL) {
            resetProperties(false);
          }

          // assign new HTML5 URL

          a.src = instanceOptions.url;

          s.url = instanceOptions.url;

          lastURL = instanceOptions.url;

          lastGlobalHTML5URL = instanceOptions.url;

          a._called_load = false;

        }

      } else {

        if (instanceOptions.autoLoad || instanceOptions.autoPlay) {

          s._a = new Audio(instanceOptions.url);
          s._a.load();

        } else {

          // null for stupid Opera 9.64 case
          s._a = (isOpera && opera.version() < 10 ? new Audio(null) : new Audio());

        }

        // assign local reference
        a = s._a;

        a._called_load = false;

        if (useGlobalHTML5Audio) {

          globalHTML5Audio = a;

        }

      }

      s.isHTML5 = true;

      // store a ref on the track
      s._a = a;

      // store a ref on the audio
      a._s = s;

      add_html5_events();

      s._apply_loop(a, instanceOptions.loops);

      if (instanceOptions.autoLoad || instanceOptions.autoPlay) {

        s.load();

      } else {

        // early HTML5 implementation (non-standard)
        a.autobuffer = false;

        // standard ('none' is also an option.)
        a.preload = 'auto';

      }

      return a;

    };

    add_html5_events = function() {

      if (s._a._added_events) return false;

      var f;

      function add(oEvt, oFn, bCapture) {
        return s._a ? s._a.addEventListener(oEvt, oFn, bCapture || false) : null;
      }

      s._a._added_events = true;

      for (f in html5_events) {
        if (html5_events.hasOwnProperty(f)) {
          add(f, html5_events[f]);
        }
      }

      return true;

    };

    remove_html5_events = function() {

      // Remove event listeners

      var f;

      function remove(oEvt, oFn, bCapture) {
        return (s._a ? s._a.removeEventListener(oEvt, oFn, bCapture || false) : null);
      }

      sm2._wD(s.id + ': Removing event listeners');
      s._a._added_events = false;

      for (f in html5_events) {
        if (html5_events.hasOwnProperty(f)) {
          remove(f, html5_events[f]);
        }
      }

    };

    /**
     * Pseudo-private event internals
     * ------------------------------
     */

    this._onload = function(nSuccess) {

      var fN,
          // check for duration to prevent false positives from flash 8 when loading from cache.
          loadOK = !!nSuccess || (!s.isHTML5 && fV === 8 && s.duration);

      // <d>
      fN = s.id + ': ';
      sm2._wD(fN + (loadOK ? 'onload()' : 'Failed to load / invalid sound?' + (!s.duration ? ' Zero-length duration reported.' : ' -') + ' (' + s.url + ')'), (loadOK ? 1 : 2));

      if (!loadOK && !s.isHTML5) {
        if (sm2.sandbox.noRemote === true) {
          sm2._wD(fN + str('noNet'), 1);
        }
        if (sm2.sandbox.noLocal === true) {
          sm2._wD(fN + str('noLocal'), 1);
        }
      }
      // </d>

      s.loaded = loadOK;
      s.readyState = (loadOK ? 3 : 2);
      s._onbufferchange(0);

      if (!loadOK && !s.isHTML5) {
        // note: no error code from Flash.
        s._onerror();
      }

      if (s._iO.onload) {
        wrapCallback(s, function() {
          s._iO.onload.apply(s, [loadOK]);
        });
      }

      return true;

    };

    this._onerror = function(errorCode, description) {

      // https://html.spec.whatwg.org/multipage/embedded-content.html#error-codes
      if (s._iO.onerror) {
        wrapCallback(s, function() {
          s._iO.onerror.apply(s, [errorCode, description]);
        });
      }

    };

    this._onbufferchange = function(nIsBuffering) {

      // ignore if not playing
      if (s.playState === 0) return false;

      if ((nIsBuffering && s.isBuffering) || (!nIsBuffering && !s.isBuffering)) return false;

      s.isBuffering = (nIsBuffering === 1);

      if (s._iO.onbufferchange) {
        sm2._wD(s.id + ': Buffer state change: ' + nIsBuffering);
        s._iO.onbufferchange.apply(s, [nIsBuffering]);
      }

      return true;

    };

    /**
     * Playback may have stopped due to buffering, or related reason.
     * This state can be encountered on iOS < 6 when auto-play is blocked.
     */

    this._onsuspend = function() {

      if (s._iO.onsuspend) {
        sm2._wD(s.id + ': Playback suspended');
        s._iO.onsuspend.apply(s);
      }

      return true;

    };

    /**
     * flash 9/movieStar + RTMP-only method, should fire only once at most
     * at this point we just recreate failed sounds rather than trying to reconnect
     */

    this._onfailure = function(msg, level, code) {

      s.failures++;
      sm2._wD(s.id + ': Failure (' + s.failures + '): ' + msg);

      if (s._iO.onfailure && s.failures === 1) {
        s._iO.onfailure(msg, level, code);
      } else {
        sm2._wD(s.id + ': Ignoring failure');
      }

    };

    /**
     * flash 9/movieStar + RTMP-only method for unhandled warnings/exceptions from Flash
     * e.g., RTMP "method missing" warning (non-fatal) for getStreamLength on server
     */

    this._onwarning = function(msg, level, code) {

      if (s._iO.onwarning) {
        s._iO.onwarning(msg, level, code);
      }

    };

    this._onfinish = function() {

      // store local copy before it gets trashed...
      var io_onfinish = s._iO.onfinish;

      s._onbufferchange(0);
      s._resetOnPosition(0);

      // reset some state items
      if (s.instanceCount) {

        s.instanceCount--;

        if (!s.instanceCount) {

          // remove onPosition listeners, if any
          detachOnPosition();

          // reset instance options
          s.playState = 0;
          s.paused = false;
          s.instanceCount = 0;
          s.instanceOptions = {};
          s._iO = {};
          stop_html5_timer();

          // reset position, too
          if (s.isHTML5) {
            s.position = 0;
          }

        }

        if (!s.instanceCount || s._iO.multiShotEvents) {
          // fire onfinish for last, or every instance
          if (io_onfinish) {
            sm2._wD(s.id + ': onfinish()');
            wrapCallback(s, function() {
              io_onfinish.apply(s);
            });
          }
        }

      }

    };

    this._whileloading = function(nBytesLoaded, nBytesTotal, nDuration, nBufferLength) {

      var instanceOptions = s._iO;

      s.bytesLoaded = nBytesLoaded;
      s.bytesTotal = nBytesTotal;
      s.duration = Math.floor(nDuration);
      s.bufferLength = nBufferLength;

      if (!s.isHTML5 && !instanceOptions.isMovieStar) {

        if (instanceOptions.duration) {
          // use duration from options, if specified and larger. nobody should be specifying duration in options, actually, and it should be retired.
          s.durationEstimate = (s.duration > instanceOptions.duration) ? s.duration : instanceOptions.duration;
        } else {
          s.durationEstimate = parseInt((s.bytesTotal / s.bytesLoaded) * s.duration, 10);
        }

      } else {

        s.durationEstimate = s.duration;

      }

      // for flash, reflect sequential-load-style buffering
      if (!s.isHTML5) {
        s.buffered = [{
          start: 0,
          end: s.duration
        }];
      }

      // allow whileloading to fire even if "load" fired under HTML5, due to HTTP range/partials
      if ((s.readyState !== 3 || s.isHTML5) && instanceOptions.whileloading) {
        instanceOptions.whileloading.apply(s);
      }

    };

    this._whileplaying = function(nPosition, oPeakData, oWaveformDataLeft, oWaveformDataRight, oEQData) {

      var instanceOptions = s._iO,
          eqLeft;

      // flash safety net
      if (isNaN(nPosition) || nPosition === null) return false;

      // Safari HTML5 play() may return small -ve values when starting from position: 0, eg. -50.120396875. Unexpected/invalid per W3, I think. Normalize to 0.
      s.position = Math.max(0, nPosition);

      s._processOnPosition();

      if (!s.isHTML5 && fV > 8) {

        if (instanceOptions.usePeakData && oPeakData !== _undefined && oPeakData) {
          s.peakData = {
            left: oPeakData.leftPeak,
            right: oPeakData.rightPeak
          };
        }

        if (instanceOptions.useWaveformData && oWaveformDataLeft !== _undefined && oWaveformDataLeft) {
          s.waveformData = {
            left: oWaveformDataLeft.split(','),
            right: oWaveformDataRight.split(',')
          };
        }

        if (instanceOptions.useEQData) {
          if (oEQData !== _undefined && oEQData && oEQData.leftEQ) {
            eqLeft = oEQData.leftEQ.split(',');
            s.eqData = eqLeft;
            s.eqData.left = eqLeft;
            if (oEQData.rightEQ !== _undefined && oEQData.rightEQ) {
              s.eqData.right = oEQData.rightEQ.split(',');
            }
          }
        }

      }

      if (s.playState === 1) {

        // special case/hack: ensure buffering is false if loading from cache (and not yet started)
        if (!s.isHTML5 && fV === 8 && !s.position && s.isBuffering) {
          s._onbufferchange(0);
        }

        if (instanceOptions.whileplaying) {
          // flash may call after actual finish
          instanceOptions.whileplaying.apply(s);
        }

      }

      return true;

    };

    this._oncaptiondata = function(oData) {

      /**
       * internal: flash 9 + NetStream (MovieStar/RTMP-only) feature
       *
       * @param {object} oData
       */

      sm2._wD(s.id + ': Caption data received.');

      s.captiondata = oData;

      if (s._iO.oncaptiondata) {
        s._iO.oncaptiondata.apply(s, [oData]);
      }

    };

    this._onmetadata = function(oMDProps, oMDData) {

      /**
       * internal: flash 9 + NetStream (MovieStar/RTMP-only) feature
       * RTMP may include song title, MovieStar content may include encoding info
       *
       * @param {array} oMDProps (names)
       * @param {array} oMDData (values)
       */

      sm2._wD(s.id + ': Metadata received.');

      var oData = {}, i, j;

      for (i = 0, j = oMDProps.length; i < j; i++) {
        oData[oMDProps[i]] = oMDData[i];
      }

      s.metadata = oData;

      if (s._iO.onmetadata) {
        s._iO.onmetadata.call(s, s.metadata);
      }

    };

    this._onid3 = function(oID3Props, oID3Data) {

      /**
       * internal: flash 8 + flash 9 ID3 feature
       * may include artist, song title etc.
       *
       * @param {array} oID3Props (names)
       * @param {array} oID3Data (values)
       */

      sm2._wD(s.id + ': ID3 data received.');

      var oData = [], i, j;

      for (i = 0, j = oID3Props.length; i < j; i++) {
        oData[oID3Props[i]] = oID3Data[i];
      }

      s.id3 = mixin(s.id3, oData);

      if (s._iO.onid3) {
        s._iO.onid3.apply(s);
      }

    };

    // flash/RTMP-only

    this._onconnect = function(bSuccess) {

      bSuccess = (bSuccess === 1);
      sm2._wD(s.id + ': ' + (bSuccess ? 'Connected.' : 'Failed to connect? - ' + s.url), (bSuccess ? 1 : 2));
      s.connected = bSuccess;

      if (bSuccess) {

        s.failures = 0;

        if (idCheck(s.id)) {
          if (s.getAutoPlay()) {
            // only update the play state if auto playing
            s.play(_undefined, s.getAutoPlay());
          } else if (s._iO.autoLoad) {
            s.load();
          }
        }

        if (s._iO.onconnect) {
          s._iO.onconnect.apply(s, [bSuccess]);
        }

      }

    };

    this._ondataerror = function(sError) {

      // flash 9 wave/eq data handler
      // hack: called at start, and end from flash at/after onfinish()
      if (s.playState > 0) {
        sm2._wD(s.id + ': Data error: ' + sError);
        if (s._iO.ondataerror) {
          s._iO.ondataerror.apply(s);
        }
      }

    };

    // <d>
    this._debug();
    // </d>

  }; // SMSound()

  /**
   * Private SoundManager internals
   * ------------------------------
   */

  getDocument = function() {

    return (doc.body || doc.getElementsByTagName('div')[0]);

  };

  id = function(sID) {

    return doc.getElementById(sID);

  };

  mixin = function(oMain, oAdd) {

    // non-destructive merge
    var o1 = (oMain || {}), o2, o;

    // if unspecified, o2 is the default options object
    o2 = (oAdd === _undefined ? sm2.defaultOptions : oAdd);

    for (o in o2) {

      if (o2.hasOwnProperty(o) && o1[o] === _undefined) {

        if (typeof o2[o] !== 'object' || o2[o] === null) {

          // assign directly
          o1[o] = o2[o];

        } else {

          // recurse through o2
          o1[o] = mixin(o1[o], o2[o]);

        }

      }

    }

    return o1;

  };

  wrapCallback = function(oSound, callback) {

    /**
     * 03/03/2013: Fix for Flash Player 11.6.602.171 + Flash 8 (flashVersion = 8) SWF issue
     * setTimeout() fix for certain SMSound callbacks like onload() and onfinish(), where subsequent calls like play() and load() fail when Flash Player 11.6.602.171 is installed, and using soundManager with flashVersion = 8 (which is the default).
     * Not sure of exact cause. Suspect race condition and/or invalid (NaN-style) position argument trickling down to the next JS -> Flash _start() call, in the play() case.
     * Fix: setTimeout() to yield, plus safer null / NaN checking on position argument provided to Flash.
     * https://getsatisfaction.com/schillmania/topics/recent_chrome_update_seems_to_have_broken_my_sm2_audio_player
     */
    if (!oSound.isHTML5 && fV === 8) {
      window.setTimeout(callback, 0);
    } else {
      callback();
    }

  };

  // additional soundManager properties that soundManager.setup() will accept

  extraOptions = {
    onready: 1,
    ontimeout: 1,
    defaultOptions: 1,
    flash9Options: 1,
    movieStarOptions: 1
  };

  assign = function(o, oParent) {

    /**
     * recursive assignment of properties, soundManager.setup() helper
     * allows property assignment based on whitelist
     */

    var i,
        result = true,
        hasParent = (oParent !== _undefined),
        setupOptions = sm2.setupOptions,
        bonusOptions = extraOptions;

    // <d>

    // if soundManager.setup() called, show accepted parameters.

    if (o === _undefined) {

      result = [];

      for (i in setupOptions) {

        if (setupOptions.hasOwnProperty(i)) {
          result.push(i);
        }

      }

      for (i in bonusOptions) {

        if (bonusOptions.hasOwnProperty(i)) {

          if (typeof sm2[i] === 'object') {
            result.push(i + ': {...}');
          } else if (sm2[i] instanceof Function) {
            result.push(i + ': function() {...}');
          } else {
            result.push(i);
          }

        }

      }

      sm2._wD(str('setup', result.join(', ')));

      return false;

    }

    // </d>

    for (i in o) {

      if (o.hasOwnProperty(i)) {

        // if not an {object} we want to recurse through...

        if (typeof o[i] !== 'object' || o[i] === null || o[i] instanceof Array || o[i] instanceof RegExp) {

          // check "allowed" options

          if (hasParent && bonusOptions[oParent] !== _undefined) {

            // valid recursive / nested object option, eg., { defaultOptions: { volume: 50 } }
            sm2[oParent][i] = o[i];

          } else if (setupOptions[i] !== _undefined) {

            // special case: assign to setupOptions object, which soundManager property references
            sm2.setupOptions[i] = o[i];

            // assign directly to soundManager, too
            sm2[i] = o[i];

          } else if (bonusOptions[i] === _undefined) {

            // invalid or disallowed parameter. complain.
            complain(str((sm2[i] === _undefined ? 'setupUndef' : 'setupError'), i), 2);

            result = false;

          } else if (sm2[i] instanceof Function) {

            /**
             * valid extraOptions (bonusOptions) parameter.
             * is it a method, like onready/ontimeout? call it.
             * multiple parameters should be in an array, eg. soundManager.setup({onready: [myHandler, myScope]});
             */
            sm2[i].apply(sm2, (o[i] instanceof Array ? o[i] : [o[i]]));

          } else {

            // good old-fashioned direct assignment
            sm2[i] = o[i];

          }

        } else if (bonusOptions[i] === _undefined) {

          // recursion case, eg., { defaultOptions: { ... } }

          // invalid or disallowed parameter. complain.
          complain(str((sm2[i] === _undefined ? 'setupUndef' : 'setupError'), i), 2);

          result = false;

        } else {

          // recurse through object
          return assign(o[i], i);

        }

      }

    }

    return result;

  };

  function preferFlashCheck(kind) {

    // whether flash should play a given type
    return (sm2.preferFlash && hasFlash && !sm2.ignoreFlash && (sm2.flash[kind] !== _undefined && sm2.flash[kind]));

  }

  /**
   * Internal DOM2-level event helpers
   * ---------------------------------
   */

  event = (function() {

    // normalize event methods
    var old = (window.attachEvent),
    evt = {
      add: (old ? 'attachEvent' : 'addEventListener'),
      remove: (old ? 'detachEvent' : 'removeEventListener')
    };

    // normalize "on" event prefix, optional capture argument
    function getArgs(oArgs) {

      var args = slice.call(oArgs),
          len = args.length;

      if (old) {
        // prefix
        args[1] = 'on' + args[1];
        if (len > 3) {
          // no capture
          args.pop();
        }
      } else if (len === 3) {
        args.push(false);
      }

      return args;

    }

    function apply(args, sType) {

      // normalize and call the event method, with the proper arguments
      var element = args.shift(),
          method = [evt[sType]];

      if (old) {
        // old IE can't do apply().
        element[method](args[0], args[1]);
      } else {
        element[method].apply(element, args);
      }

    }

    function add() {
      apply(getArgs(arguments), 'add');
    }

    function remove() {
      apply(getArgs(arguments), 'remove');
    }

    return {
      add: add,
      remove: remove
    };

  }());

  /**
   * Internal HTML5 event handling
   * -----------------------------
   */

  function html5_event(oFn) {

    // wrap html5 event handlers so we don't call them on destroyed and/or unloaded sounds

    return function(e) {

      var s = this._s,
          result;

      if (!s || !s._a) {
        // <d>
        if (s && s.id) {
          sm2._wD(s.id + ': Ignoring ' + e.type);
        } else {
          sm2._wD(h5 + 'Ignoring ' + e.type);
        }
        // </d>
        result = null;
      } else {
        result = oFn.call(this, e);
      }

      return result;

    };

  }

  html5_events = {

    // HTML5 event-name-to-handler map

    abort: html5_event(function() {

      sm2._wD(this._s.id + ': abort');

    }),

    // enough has loaded to play

    canplay: html5_event(function() {

      var s = this._s,
          position1K;

      if (s._html5_canplay) {
        // this event has already fired. ignore.
        return;
      }

      s._html5_canplay = true;
      sm2._wD(s.id + ': canplay');
      s._onbufferchange(0);

      // position according to instance options
      position1K = (s._iO.position !== _undefined && !isNaN(s._iO.position) ? s._iO.position / msecScale : null);

      // set the position if position was provided before the sound loaded
      if (this.currentTime !== position1K) {
        sm2._wD(s.id + ': canplay: Setting position to ' + position1K);
        try {
          this.currentTime = position1K;
        } catch(ee) {
          sm2._wD(s.id + ': canplay: Setting position of ' + position1K + ' failed: ' + ee.message, 2);
        }
      }

      // hack for HTML5 from/to case
      if (s._iO._oncanplay) {
        s._iO._oncanplay();
      }

    }),

    canplaythrough: html5_event(function() {

      var s = this._s;

      if (!s.loaded) {
        s._onbufferchange(0);
        s._whileloading(s.bytesLoaded, s.bytesTotal, s._get_html5_duration());
        s._onload(true);
      }

    }),

    durationchange: html5_event(function() {

      // durationchange may fire at various times, probably the safest way to capture accurate/final duration.

      var s = this._s,
          duration;

      duration = s._get_html5_duration();

      if (!isNaN(duration) && duration !== s.duration) {

        sm2._wD(this._s.id + ': durationchange (' + duration + ')' + (s.duration ? ', previously ' + s.duration : ''));

        s.durationEstimate = s.duration = duration;

      }

    }),

    // TODO: Reserved for potential use
    /*
    emptied: html5_event(function() {

      sm2._wD(this._s.id + ': emptied');

    }),
    */

    ended: html5_event(function() {

      var s = this._s;

      sm2._wD(s.id + ': ended');

      s._onfinish();

    }),

    error: html5_event(function() {

      var description = (html5ErrorCodes[this.error.code] || null);
      sm2._wD(this._s.id + ': HTML5 error, code ' + this.error.code + (description ? ' (' + description + ')' : ''));
      this._s._onload(false);
      this._s._onerror(this.error.code, description);

    }),

    loadeddata: html5_event(function() {

      var s = this._s;

      sm2._wD(s.id + ': loadeddata');

      // safari seems to nicely report progress events, eventually totalling 100%
      if (!s._loaded && !isSafari) {
        s.duration = s._get_html5_duration();
      }

    }),

    loadedmetadata: html5_event(function() {

      sm2._wD(this._s.id + ': loadedmetadata');

    }),

    loadstart: html5_event(function() {

      sm2._wD(this._s.id + ': loadstart');
      // assume buffering at first
      this._s._onbufferchange(1);

    }),

    play: html5_event(function() {

      // sm2._wD(this._s.id + ': play()');
      // once play starts, no buffering
      this._s._onbufferchange(0);

    }),

    playing: html5_event(function() {

      sm2._wD(this._s.id + ': playing ' + String.fromCharCode(9835));
      // once play starts, no buffering
      this._s._onbufferchange(0);

    }),

    progress: html5_event(function(e) {

      // note: can fire repeatedly after "loaded" event, due to use of HTTP range/partials

      var s = this._s,
          i, j, progStr, buffered = 0,
          isProgress = (e.type === 'progress'),
          ranges = e.target.buffered,
          // firefox 3.6 implements e.loaded/total (bytes)
          loaded = (e.loaded || 0),
          total = (e.total || 1);

      // reset the "buffered" (loaded byte ranges) array
      s.buffered = [];

      if (ranges && ranges.length) {

        // if loaded is 0, try TimeRanges implementation as % of load
        // https://developer.mozilla.org/en/DOM/TimeRanges

        // re-build "buffered" array
        // HTML5 returns seconds. SM2 API uses msec for setPosition() etc., whether Flash or HTML5.
        for (i = 0, j = ranges.length; i < j; i++) {
          s.buffered.push({
            start: ranges.start(i) * msecScale,
            end: ranges.end(i) * msecScale
          });
        }

        // use the last value locally
        buffered = (ranges.end(0) - ranges.start(0)) * msecScale;

        // linear case, buffer sum; does not account for seeking and HTTP partials / byte ranges
        loaded = Math.min(1, buffered / (e.target.duration * msecScale));

        // <d>
        if (isProgress && ranges.length > 1) {
          progStr = [];
          j = ranges.length;
          for (i = 0; i < j; i++) {
            progStr.push((e.target.buffered.start(i) * msecScale) + '-' + (e.target.buffered.end(i) * msecScale));
          }
          sm2._wD(this._s.id + ': progress, timeRanges: ' + progStr.join(', '));
        }

        if (isProgress && !isNaN(loaded)) {
          sm2._wD(this._s.id + ': progress, ' + Math.floor(loaded * 100) + '% loaded');
        }
        // </d>

      }

      if (!isNaN(loaded)) {

        // TODO: prevent calls with duplicate values.
        s._whileloading(loaded, total, s._get_html5_duration());
        if (loaded && total && loaded === total) {
          // in case "onload" doesn't fire (eg. gecko 1.9.2)
          html5_events.canplaythrough.call(this, e);
        }

      }

    }),

    ratechange: html5_event(function() {

      sm2._wD(this._s.id + ': ratechange');

    }),

    suspend: html5_event(function(e) {

      // download paused/stopped, may have finished (eg. onload)
      var s = this._s;

      sm2._wD(this._s.id + ': suspend');
      html5_events.progress.call(this, e);
      s._onsuspend();

    }),

    stalled: html5_event(function() {

      sm2._wD(this._s.id + ': stalled');

    }),

    timeupdate: html5_event(function() {

      this._s._onTimer();

    }),

    waiting: html5_event(function() {

      var s = this._s;

      // see also: seeking
      sm2._wD(this._s.id + ': waiting');

      // playback faster than download rate, etc.
      s._onbufferchange(1);

    })

  };

  html5OK = function(iO) {

    // playability test based on URL or MIME type

    var result;

    if (!iO || (!iO.type && !iO.url && !iO.serverURL)) {

      // nothing to check
      result = false;

    } else if (iO.serverURL || (iO.type && preferFlashCheck(iO.type))) {

      // RTMP, or preferring flash
      result = false;

    } else {

      // Use type, if specified. Pass data: URIs to HTML5. If HTML5-only mode, no other options, so just give 'er
      result = ((iO.type ? html5CanPlay({ type: iO.type }) : html5CanPlay({ url: iO.url }) || sm2.html5Only || iO.url.match(/data:/i)));

    }

    return result;

  };

  html5Unload = function(oAudio) {

    /**
     * Internal method: Unload media, and cancel any current/pending network requests.
     * Firefox can load an empty URL, which allegedly destroys the decoder and stops the download.
     * https://developer.mozilla.org/En/Using_audio_and_video_in_Firefox#Stopping_the_download_of_media
     * However, Firefox has been seen loading a relative URL from '' and thus requesting the hosting page on unload.
     * Other UA behaviour is unclear, so everyone else gets an about:blank-style URL.
     */

    var url;

    if (oAudio) {

      // Firefox and Chrome accept short WAVe data: URIs. Chome dislikes audio/wav, but accepts audio/wav for data: MIME.
      // Desktop Safari complains / fails on data: URI, so it gets about:blank.
      url = (isSafari ? emptyURL : (sm2.html5.canPlayType('audio/wav') ? emptyWAV : emptyURL));

      oAudio.src = url;

      // reset some state, too
      if (oAudio._called_unload !== _undefined) {
        oAudio._called_load = false;
      }

    }

    if (useGlobalHTML5Audio) {

      // ensure URL state is trashed, also
      lastGlobalHTML5URL = null;

    }

    return url;

  };

  html5CanPlay = function(o) {

    /**
     * Try to find MIME, test and return truthiness
     * o = {
     *  url: '/path/to/an.mp3',
     *  type: 'audio/mp3'
     * }
     */

    if (!sm2.useHTML5Audio || !sm2.hasHTML5) return false;

    var url = (o.url || null),
        mime = (o.type || null),
        aF = sm2.audioFormats,
        result,
        offset,
        fileExt,
        item;

    // account for known cases like audio/mp3

    if (mime && sm2.html5[mime] !== _undefined) return (sm2.html5[mime] && !preferFlashCheck(mime));

    if (!html5Ext) {

      html5Ext = [];

      for (item in aF) {

        if (aF.hasOwnProperty(item)) {

          html5Ext.push(item);

          if (aF[item].related) {
            html5Ext = html5Ext.concat(aF[item].related);
          }

        }

      }

      html5Ext = new RegExp('\\.(' + html5Ext.join('|') + ')(\\?.*)?$', 'i');

    }

    // TODO: Strip URL queries, etc.
    fileExt = (url ? url.toLowerCase().match(html5Ext) : null);

    if (!fileExt || !fileExt.length) {

      if (!mime) {

        result = false;

      } else {

        // audio/mp3 -> mp3, result should be known
        offset = mime.indexOf(';');

        // strip "audio/X; codecs..."
        fileExt = (offset !== -1 ? mime.substr(0, offset) : mime).substr(6);

      }

    } else {

      // match the raw extension name - "mp3", for example
      fileExt = fileExt[1];

    }

    if (fileExt && sm2.html5[fileExt] !== _undefined) {

      // result known
      result = (sm2.html5[fileExt] && !preferFlashCheck(fileExt));

    } else {

      mime = 'audio/' + fileExt;
      result = sm2.html5.canPlayType({ type: mime });

      sm2.html5[fileExt] = result;

      // sm2._wD('canPlayType, found result: ' + result);
      result = (result && sm2.html5[mime] && !preferFlashCheck(mime));
    }

    return result;

  };

  testHTML5 = function() {

    /**
     * Internal: Iterates over audioFormats, determining support eg. audio/mp3, audio/mpeg and so on
     * assigns results to html5[] and flash[].
     */

    if (!sm2.useHTML5Audio || !sm2.hasHTML5) {

      // without HTML5, we need Flash.
      sm2.html5.usingFlash = true;
      needsFlash = true;

      return false;

    }

    // double-whammy: Opera 9.64 throws WRONG_ARGUMENTS_ERR if no parameter passed to Audio(), and Webkit + iOS happily tries to load "null" as a URL. :/
    var a = (Audio !== _undefined ? (isOpera && opera.version() < 10 ? new Audio(null) : new Audio()) : null),
        item, lookup, support = {}, aF, i;

    function cp(m) {

      var canPlay, j,
          result = false,
          isOK = false;

      if (!a || typeof a.canPlayType !== 'function') return result;

      if (m instanceof Array) {

        // iterate through all mime types, return any successes

        for (i = 0, j = m.length; i < j; i++) {

          if (sm2.html5[m[i]] || a.canPlayType(m[i]).match(sm2.html5Test)) {

            isOK = true;
            sm2.html5[m[i]] = true;

            // note flash support, too
            sm2.flash[m[i]] = !!(m[i].match(flashMIME));

          }

        }

        result = isOK;

      } else {

        canPlay = (a && typeof a.canPlayType === 'function' ? a.canPlayType(m) : false);
        result = !!(canPlay && (canPlay.match(sm2.html5Test)));

      }

      return result;

    }

    // test all registered formats + codecs

    aF = sm2.audioFormats;

    for (item in aF) {

      if (aF.hasOwnProperty(item)) {

        lookup = 'audio/' + item;

        support[item] = cp(aF[item].type);

        // write back generic type too, eg. audio/mp3
        support[lookup] = support[item];

        // assign flash
        if (item.match(flashMIME)) {

          sm2.flash[item] = true;
          sm2.flash[lookup] = true;

        } else {

          sm2.flash[item] = false;
          sm2.flash[lookup] = false;

        }

        // assign result to related formats, too

        if (aF[item] && aF[item].related) {

          for (i = aF[item].related.length - 1; i >= 0; i--) {

            // eg. audio/m4a
            support['audio/' + aF[item].related[i]] = support[item];
            sm2.html5[aF[item].related[i]] = support[item];
            sm2.flash[aF[item].related[i]] = support[item];

          }

        }

      }

    }

    support.canPlayType = (a ? cp : null);
    sm2.html5 = mixin(sm2.html5, support);

    sm2.html5.usingFlash = featureCheck();
    needsFlash = sm2.html5.usingFlash;

    return true;

  };

  strings = {

    // <d>
    notReady: 'Unavailable - wait until onready() has fired.',
    notOK: 'Audio support is not available.',
    domError: sm + 'exception caught while appending SWF to DOM.',
    spcWmode: 'Removing wmode, preventing known SWF loading issue(s)',
    swf404: smc + 'Verify that %s is a valid path.',
    tryDebug: 'Try ' + sm + '.debugFlash = true for more security details (output goes to SWF.)',
    checkSWF: 'See SWF output for more debug info.',
    localFail: smc + 'Non-HTTP page (' + doc.location.protocol + ' URL?) Review Flash player security settings for this special case:\nhttp://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html\nMay need to add/allow path, eg. c:/sm2/ or /users/me/sm2/',
    waitFocus: smc + 'Special case: Waiting for SWF to load with window focus...',
    waitForever: smc + 'Waiting indefinitely for Flash (will recover if unblocked)...',
    waitSWF: smc + 'Waiting for 100% SWF load...',
    needFunction: smc + 'Function object expected for %s',
    badID: 'Sound ID "%s" should be a string, starting with a non-numeric character',
    currentObj: smc + '_debug(): Current sound objects',
    waitOnload: smc + 'Waiting for window.onload()',
    docLoaded: smc + 'Document already loaded',
    onload: smc + 'initComplete(): calling soundManager.onload()',
    onloadOK: sm + '.onload() complete',
    didInit: smc + 'init(): Already called?',
    secNote: 'Flash security note: Network/internet URLs will not load due to security restrictions. Access can be configured via Flash Player Global Security Settings Page: http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html',
    badRemove: smc + 'Failed to remove Flash node.',
    shutdown: sm + '.disable(): Shutting down',
    queue: smc + 'Queueing %s handler',
    smError: 'SMSound.load(): Exception: JS-Flash communication failed, or JS error.',
    fbTimeout: 'No flash response, applying .' + swfCSS.swfTimedout + ' CSS...',
    fbLoaded: 'Flash loaded',
    fbHandler: smc + 'flashBlockHandler()',
    manURL: 'SMSound.load(): Using manually-assigned URL',
    onURL: sm + '.load(): current URL already assigned.',
    badFV: sm + '.flashVersion must be 8 or 9. "%s" is invalid. Reverting to %s.',
    as2loop: 'Note: Setting stream:false so looping can work (flash 8 limitation)',
    noNSLoop: 'Note: Looping not implemented for MovieStar formats',
    needfl9: 'Note: Switching to flash 9, required for MP4 formats.',
    mfTimeout: 'Setting flashLoadTimeout = 0 (infinite) for off-screen, mobile flash case',
    needFlash: smc + 'Fatal error: Flash is needed to play some required formats, but is not available.',
    gotFocus: smc + 'Got window focus.',
    policy: 'Enabling usePolicyFile for data access',
    setup: sm + '.setup(): allowed parameters: %s',
    setupError: sm + '.setup(): "%s" cannot be assigned with this method.',
    setupUndef: sm + '.setup(): Could not find option "%s"',
    setupLate: sm + '.setup(): url, flashVersion and html5Test property changes will not take effect until reboot().',
    noURL: smc + 'Flash URL required. Call soundManager.setup({url:...}) to get started.',
    sm2Loaded: 'SoundManager 2: Ready. ' + String.fromCharCode(10003),
    reset: sm + '.reset(): Removing event callbacks',
    mobileUA: 'Mobile UA detected, preferring HTML5 by default.',
    globalHTML5: 'Using singleton HTML5 Audio() pattern for this device.',
    ignoreMobile: 'Ignoring mobile restrictions for this device.'
    // </d>

  };

  str = function() {

    // internal string replace helper.
    // arguments: o [,items to replace]
    // <d>

    var args,
        i, j, o,
        sstr;

    // real array, please
    args = slice.call(arguments);

    // first argument
    o = args.shift();

    sstr = (strings && strings[o] ? strings[o] : '');

    if (sstr && args && args.length) {
      for (i = 0, j = args.length; i < j; i++) {
        sstr = sstr.replace('%s', args[i]);
      }
    }

    return sstr;
    // </d>

  };

  loopFix = function(sOpt) {

    // flash 8 requires stream = false for looping to work
    if (fV === 8 && sOpt.loops > 1 && sOpt.stream) {
      _wDS('as2loop');
      sOpt.stream = false;
    }

    return sOpt;

  };

  policyFix = function(sOpt, sPre) {

    if (sOpt && !sOpt.usePolicyFile && (sOpt.onid3 || sOpt.usePeakData || sOpt.useWaveformData || sOpt.useEQData)) {
      sm2._wD((sPre || '') + str('policy'));
      sOpt.usePolicyFile = true;
    }

    return sOpt;

  };

  complain = function(sMsg) {

    // <d>
    if (hasConsole && console.warn !== _undefined) {
      console.warn(sMsg);
    } else {
      sm2._wD(sMsg);
    }
    // </d>

  };

  doNothing = function() {

    return false;

  };

  disableObject = function(o) {

    var oProp;

    for (oProp in o) {
      if (o.hasOwnProperty(oProp) && typeof o[oProp] === 'function') {
        o[oProp] = doNothing;
      }
    }

    oProp = null;

  };

  failSafely = function(bNoDisable) {

    // general failure exception handler

    if (bNoDisable === _undefined) {
      bNoDisable = false;
    }

    if (disabled || bNoDisable) {
      sm2.disable(bNoDisable);
    }

  };

  normalizeMovieURL = function(movieURL) {

    var urlParams = null, url;

    if (movieURL) {

      if (movieURL.match(/\.swf(\?.*)?$/i)) {

        urlParams = movieURL.substr(movieURL.toLowerCase().lastIndexOf('.swf?') + 4);

        // assume user knows what they're doing
        if (urlParams) return movieURL;

      } else if (movieURL.lastIndexOf('/') !== movieURL.length - 1) {

        // append trailing slash, if needed
        movieURL += '/';

      }

    }

    url = (movieURL && movieURL.lastIndexOf('/') !== -1 ? movieURL.substr(0, movieURL.lastIndexOf('/') + 1) : './') + sm2.movieURL;

    if (sm2.noSWFCache) {
      url += ('?ts=' + new Date().getTime());
    }

    return url;

  };

  setVersionInfo = function() {

    // short-hand for internal use

    fV = parseInt(sm2.flashVersion, 10);

    if (fV !== 8 && fV !== 9) {
      sm2._wD(str('badFV', fV, defaultFlashVersion));
      sm2.flashVersion = fV = defaultFlashVersion;
    }

    // debug flash movie, if applicable

    var isDebug = (sm2.debugMode || sm2.debugFlash ? '_debug.swf' : '.swf');

    if (sm2.useHTML5Audio && !sm2.html5Only && sm2.audioFormats.mp4.required && fV < 9) {
      sm2._wD(str('needfl9'));
      sm2.flashVersion = fV = 9;
    }

    sm2.version = sm2.versionNumber + (sm2.html5Only ? ' (HTML5-only mode)' : (fV === 9 ? ' (AS3/Flash 9)' : ' (AS2/Flash 8)'));

    // set up default options
    if (fV > 8) {

      // +flash 9 base options
      sm2.defaultOptions = mixin(sm2.defaultOptions, sm2.flash9Options);
      sm2.features.buffering = true;

      // +moviestar support
      sm2.defaultOptions = mixin(sm2.defaultOptions, sm2.movieStarOptions);
      sm2.filePatterns.flash9 = new RegExp('\\.(mp3|' + netStreamTypes.join('|') + ')(\\?.*)?$', 'i');
      sm2.features.movieStar = true;

    } else {

      sm2.features.movieStar = false;

    }

    // regExp for flash canPlay(), etc.
    sm2.filePattern = sm2.filePatterns[(fV !== 8 ? 'flash9' : 'flash8')];

    // if applicable, use _debug versions of SWFs
    sm2.movieURL = (fV === 8 ? 'soundmanager2.swf' : 'soundmanager2_flash9.swf').replace('.swf', isDebug);

    sm2.features.peakData = sm2.features.waveformData = sm2.features.eqData = (fV > 8);

  };

  setPolling = function(bPolling, bHighPerformance) {

    if (!flash) {
      return;
    }

    flash._setPolling(bPolling, bHighPerformance);

  };

  initDebug = function() {

    // starts debug mode, creating output <div> for UAs without console object

    // allow force of debug mode via URL
    // <d>
    if (sm2.debugURLParam.test(wl)) {
      sm2.setupOptions.debugMode = sm2.debugMode = true;
    }

    if (id(sm2.debugID)) {
      return;
    }

    var oD, oDebug, oTarget, oToggle, tmp;

    if (sm2.debugMode && !id(sm2.debugID) && (!hasConsole || !sm2.useConsole || !sm2.consoleOnly)) {

      oD = doc.createElement('div');
      oD.id = sm2.debugID + '-toggle';

      oToggle = {
        position: 'fixed',
        bottom: '0px',
        right: '0px',
        width: '1.2em',
        height: '1.2em',
        lineHeight: '1.2em',
        margin: '2px',
        textAlign: 'center',
        border: '1px solid #999',
        cursor: 'pointer',
        background: '#fff',
        color: '#333',
        zIndex: 10001
      };

      oD.appendChild(doc.createTextNode('-'));
      oD.onclick = toggleDebug;
      oD.title = 'Toggle SM2 debug console';

      if (ua.match(/msie 6/i)) {
        oD.style.position = 'absolute';
        oD.style.cursor = 'hand';
      }

      for (tmp in oToggle) {
        if (oToggle.hasOwnProperty(tmp)) {
          oD.style[tmp] = oToggle[tmp];
        }
      }

      oDebug = doc.createElement('div');
      oDebug.id = sm2.debugID;
      oDebug.style.display = (sm2.debugMode ? 'block' : 'none');

      if (sm2.debugMode && !id(oD.id)) {
        try {
          oTarget = getDocument();
          oTarget.appendChild(oD);
        } catch(e2) {
          throw new Error(str('domError') + ' \n' + e2.toString());
        }
        oTarget.appendChild(oDebug);
      }

    }

    oTarget = null;
    // </d>

  };

  idCheck = this.getSoundById;

  // <d>
  _wDS = function(o, errorLevel) {

    return (!o ? '' : sm2._wD(str(o), errorLevel));

  };

  toggleDebug = function() {

    var o = id(sm2.debugID),
    oT = id(sm2.debugID + '-toggle');

    if (!o) {
      return;
    }

    if (debugOpen) {
      // minimize
      oT.innerHTML = '+';
      o.style.display = 'none';
    } else {
      oT.innerHTML = '-';
      o.style.display = 'block';
    }

    debugOpen = !debugOpen;

  };

  debugTS = function(sEventType, bSuccess, sMessage) {

    // troubleshooter debug hooks

    if (window.sm2Debugger !== _undefined) {
      try {
        sm2Debugger.handleEvent(sEventType, bSuccess, sMessage);
      } catch(e) {
        // oh well
        return false;
      }
    }

    return true;

  };
  // </d>

  getSWFCSS = function() {

    var css = [];

    if (sm2.debugMode) {
      css.push(swfCSS.sm2Debug);
    }

    if (sm2.debugFlash) {
      css.push(swfCSS.flashDebug);
    }

    if (sm2.useHighPerformance) {
      css.push(swfCSS.highPerf);
    }

    return css.join(' ');

  };

  flashBlockHandler = function() {

    // *possible* flash block situation.

    var name = str('fbHandler'),
        p = sm2.getMoviePercent(),
        css = swfCSS,
        error = {
          type: 'FLASHBLOCK'
        };

    if (sm2.html5Only) {
      // no flash, or unused
      return;
    }

    if (!sm2.ok()) {

      if (needsFlash) {
        // make the movie more visible, so user can fix
        sm2.oMC.className = getSWFCSS() + ' ' + css.swfDefault + ' ' + (p === null ? css.swfTimedout : css.swfError);
        sm2._wD(name + ': ' + str('fbTimeout') + (p ? ' (' + str('fbLoaded') + ')' : ''));
      }

      sm2.didFlashBlock = true;

      // fire onready(), complain lightly
      processOnEvents({
        type: 'ontimeout',
        ignoreInit: true,
        error: error
      });

      catchError(error);

    } else {

      // SM2 loaded OK (or recovered)

      // <d>
      if (sm2.didFlashBlock) {
        sm2._wD(name + ': Unblocked');
      }
      // </d>

      if (sm2.oMC) {
        sm2.oMC.className = [getSWFCSS(), css.swfDefault, css.swfLoaded + (sm2.didFlashBlock ? ' ' + css.swfUnblocked : '')].join(' ');
      }

    }

  };

  addOnEvent = function(sType, oMethod, oScope) {

    if (on_queue[sType] === _undefined) {
      on_queue[sType] = [];
    }

    on_queue[sType].push({
      method: oMethod,
      scope: (oScope || null),
      fired: false
    });

  };

  processOnEvents = function(oOptions) {

    // if unspecified, assume OK/error

    if (!oOptions) {
      oOptions = {
        type: (sm2.ok() ? 'onready' : 'ontimeout')
      };
    }

    // not ready yet.
    if (!didInit && oOptions && !oOptions.ignoreInit) return false;

    // invalid case
    if (oOptions.type === 'ontimeout' && (sm2.ok() || (disabled && !oOptions.ignoreInit))) return false;

    var status = {
          success: (oOptions && oOptions.ignoreInit ? sm2.ok() : !disabled)
        },

        // queue specified by type, or none
        srcQueue = (oOptions && oOptions.type ? on_queue[oOptions.type] || [] : []),

        queue = [], i, j,
        args = [status],
        canRetry = (needsFlash && !sm2.ok());

    if (oOptions.error) {
      args[0].error = oOptions.error;
    }

    for (i = 0, j = srcQueue.length; i < j; i++) {
      if (srcQueue[i].fired !== true) {
        queue.push(srcQueue[i]);
      }
    }

    if (queue.length) {

      // sm2._wD(sm + ': Firing ' + queue.length + ' ' + oOptions.type + '() item' + (queue.length === 1 ? '' : 's'));
      for (i = 0, j = queue.length; i < j; i++) {

        if (queue[i].scope) {
          queue[i].method.apply(queue[i].scope, args);
        } else {
          queue[i].method.apply(this, args);
        }

        if (!canRetry) {
          // useFlashBlock and SWF timeout case doesn't count here.
          queue[i].fired = true;

        }

      }

    }

    return true;

  };

  initUserOnload = function() {

    window.setTimeout(function() {

      if (sm2.useFlashBlock) {
        flashBlockHandler();
      }

      processOnEvents();

      // call user-defined "onload", scoped to window

      if (typeof sm2.onload === 'function') {
        _wDS('onload', 1);
        sm2.onload.apply(window);
        _wDS('onloadOK', 1);
      }

      if (sm2.waitForWindowLoad) {
        event.add(window, 'load', initUserOnload);
      }

    }, 1);

  };

  detectFlash = function() {

    /**
     * Hat tip: Flash Detect library (BSD, (C) 2007) by Carl "DocYes" S. Yestrau
     * http://featureblend.com/javascript-flash-detection-library.html / http://featureblend.com/license.txt
     */

    // this work has already been done.
    if (hasFlash !== _undefined) return hasFlash;

    var hasPlugin = false, n = navigator, obj, type, types, AX = window.ActiveXObject;

    // MS Edge 14 throws an "Unspecified Error" because n.plugins is inaccessible due to permissions
    var nP;

    try {
      nP = n.plugins;
    } catch(e) {
      nP = undefined;
    }

    if (nP && nP.length) {

      type = 'application/x-shockwave-flash';
      types = n.mimeTypes;

      if (types && types[type] && types[type].enabledPlugin && types[type].enabledPlugin.description) {
        hasPlugin = true;
      }

    } else if (AX !== _undefined && !ua.match(/MSAppHost/i)) {

      // Windows 8 Store Apps (MSAppHost) are weird (compatibility?) and won't complain here, but will barf if Flash/ActiveX object is appended to the DOM.
      try {
        obj = new AX('ShockwaveFlash.ShockwaveFlash');
      } catch(e) {
        // oh well
        obj = null;
      }

      hasPlugin = (!!obj);

      // cleanup, because it is ActiveX after all
      obj = null;

    }

    hasFlash = hasPlugin;

    return hasPlugin;

  };

  featureCheck = function() {

    var flashNeeded,
        item,
        formats = sm2.audioFormats,
        // iPhone <= 3.1 has broken HTML5 audio(), but firmware 3.2 (original iPad) + iOS4 works.
        isSpecial = (is_iDevice && !!(ua.match(/os (1|2|3_0|3_1)\s/i)));

    if (isSpecial) {

      // has Audio(), but is broken; let it load links directly.
      sm2.hasHTML5 = false;

      // ignore flash case, however
      sm2.html5Only = true;

      // hide the SWF, if present
      if (sm2.oMC) {
        sm2.oMC.style.display = 'none';
      }

    } else if (sm2.useHTML5Audio) {

        if (!sm2.html5 || !sm2.html5.canPlayType) {
          sm2._wD('SoundManager: No HTML5 Audio() support detected.');
          sm2.hasHTML5 = false;
        }

        // <d>
        if (isBadSafari) {
          sm2._wD(smc + 'Note: Buggy HTML5 Audio in Safari on this OS X release, see https://bugs.webkit.org/show_bug.cgi?id=32159 - ' + (!hasFlash ? ' would use flash fallback for MP3/MP4, but none detected.' : 'will use flash fallback for MP3/MP4, if available'), 1);
        }
        // </d>

      }

    if (sm2.useHTML5Audio && sm2.hasHTML5) {

      // sort out whether flash is optional, required or can be ignored.

      // innocent until proven guilty.
      canIgnoreFlash = true;

      for (item in formats) {

        if (formats.hasOwnProperty(item)) {

          if (formats[item].required) {

            if (!sm2.html5.canPlayType(formats[item].type)) {

              // 100% HTML5 mode is not possible.
              canIgnoreFlash = false;
              flashNeeded = true;

            } else if (sm2.preferFlash && (sm2.flash[item] || sm2.flash[formats[item].type])) {

              // flash may be required, or preferred for this format.
              flashNeeded = true;

            }

          }

        }

      }

    }

    // sanity check...
    if (sm2.ignoreFlash) {
      flashNeeded = false;
      canIgnoreFlash = true;
    }

    sm2.html5Only = (sm2.hasHTML5 && sm2.useHTML5Audio && !flashNeeded);

    return (!sm2.html5Only);

  };

  parseURL = function(url) {

    /**
     * Internal: Finds and returns the first playable URL (or failing that, the first URL.)
     * @param {string or array} url A single URL string, OR, an array of URL strings or {url:'/path/to/resource', type:'audio/mp3'} objects.
     */

    var i, j, urlResult = 0, result;

    if (url instanceof Array) {

      // find the first good one
      for (i = 0, j = url.length; i < j; i++) {

        if (url[i] instanceof Object) {

          // MIME check
          if (sm2.canPlayMIME(url[i].type)) {
            urlResult = i;
            break;
          }

        } else if (sm2.canPlayURL(url[i])) {

          // URL string check
          urlResult = i;
          break;

        }

      }

      // normalize to string
      if (url[urlResult].url) {
        url[urlResult] = url[urlResult].url;
      }

      result = url[urlResult];

    } else {

      // single URL case
      result = url;

    }

    return result;

  };


  startTimer = function(oSound) {

    /**
     * attach a timer to this sound, and start an interval if needed
     */

    if (!oSound._hasTimer) {

      oSound._hasTimer = true;

      if (!mobileHTML5 && sm2.html5PollingInterval) {

        if (h5IntervalTimer === null && h5TimerCount === 0) {

          h5IntervalTimer = setInterval(timerExecute, sm2.html5PollingInterval);

        }

        h5TimerCount++;

      }

    }

  };

  stopTimer = function(oSound) {

    /**
     * detach a timer
     */

    if (oSound._hasTimer) {

      oSound._hasTimer = false;

      if (!mobileHTML5 && sm2.html5PollingInterval) {

        // interval will stop itself at next execution.

        h5TimerCount--;

      }

    }

  };

  timerExecute = function() {

    /**
     * manual polling for HTML5 progress events, ie., whileplaying()
     * (can achieve greater precision than conservative default HTML5 interval)
     */

    var i;

    if (h5IntervalTimer !== null && !h5TimerCount) {

      // no active timers, stop polling interval.

      clearInterval(h5IntervalTimer);

      h5IntervalTimer = null;

      return;

    }

    // check all HTML5 sounds with timers

    for (i = sm2.soundIDs.length - 1; i >= 0; i--) {

      if (sm2.sounds[sm2.soundIDs[i]].isHTML5 && sm2.sounds[sm2.soundIDs[i]]._hasTimer) {
        sm2.sounds[sm2.soundIDs[i]]._onTimer();
      }

    }

  };

  catchError = function(options) {

    options = (options !== _undefined ? options : {});

    if (typeof sm2.onerror === 'function') {
      sm2.onerror.apply(window, [{
        type: (options.type !== _undefined ? options.type : null)
      }]);
    }

    if (options.fatal !== _undefined && options.fatal) {
      sm2.disable();
    }

  };

  badSafariFix = function() {

    // special case: "bad" Safari (OS X 10.3 - 10.7) must fall back to flash for MP3/MP4
    if (!isBadSafari || !detectFlash()) {
      // doesn't apply
      return;
    }

    var aF = sm2.audioFormats, i, item;

    for (item in aF) {

      if (aF.hasOwnProperty(item)) {

        if (item === 'mp3' || item === 'mp4') {

          sm2._wD(sm + ': Using flash fallback for ' + item + ' format');
          sm2.html5[item] = false;

          // assign result to related formats, too
          if (aF[item] && aF[item].related) {
            for (i = aF[item].related.length - 1; i >= 0; i--) {
              sm2.html5[aF[item].related[i]] = false;
            }
          }

        }

      }

    }

  };

  /**
   * Pseudo-private flash/ExternalInterface methods
   * ----------------------------------------------
   */

  this._setSandboxType = function(sandboxType) {

    // <d>
    // Security sandbox according to Flash plugin
    var sb = sm2.sandbox;

    sb.type = sandboxType;
    sb.description = sb.types[(sb.types[sandboxType] !== _undefined ? sandboxType : 'unknown')];

    if (sb.type === 'localWithFile') {

      sb.noRemote = true;
      sb.noLocal = false;
      _wDS('secNote', 2);

    } else if (sb.type === 'localWithNetwork') {

      sb.noRemote = false;
      sb.noLocal = true;

    } else if (sb.type === 'localTrusted') {

      sb.noRemote = false;
      sb.noLocal = false;

    }
    // </d>

  };

  this._externalInterfaceOK = function(swfVersion) {

    // flash callback confirming flash loaded, EI working etc.
    // swfVersion: SWF build string

    if (sm2.swfLoaded) {
      return;
    }

    var e;

    debugTS('swf', true);
    debugTS('flashtojs', true);
    sm2.swfLoaded = true;
    tryInitOnFocus = false;

    if (isBadSafari) {
      badSafariFix();
    }

    // complain if JS + SWF build/version strings don't match, excluding +DEV builds
    // <d>
    if (!swfVersion || swfVersion.replace(/\+dev/i, '') !== sm2.versionNumber.replace(/\+dev/i, '')) {

      e = sm + ': Fatal: JavaScript file build "' + sm2.versionNumber + '" does not match Flash SWF build "' + swfVersion + '" at ' + sm2.url + '. Ensure both are up-to-date.';

      // escape flash -> JS stack so this error fires in window.
      setTimeout(function() {
        throw new Error(e);
      }, 0);

      // exit, init will fail with timeout
      return;

    }
    // </d>

    // IE needs a larger timeout
    setTimeout(init, isIE ? 100 : 1);

  };

  /**
   * Private initialization helpers
   * ------------------------------
   */

  createMovie = function(movieID, movieURL) {

    // ignore if already connected
    if (didAppend && appendSuccess) return false;

    function initMsg() {

      // <d>

      var options = [],
          title,
          msg = [],
          delimiter = ' + ';

      title = 'SoundManager ' + sm2.version + (!sm2.html5Only && sm2.useHTML5Audio ? (sm2.hasHTML5 ? ' + HTML5 audio' : ', no HTML5 audio support') : '');

      if (!sm2.html5Only) {

        if (sm2.preferFlash) {
          options.push('preferFlash');
        }

        if (sm2.useHighPerformance) {
          options.push('useHighPerformance');
        }

        if (sm2.flashPollingInterval) {
          options.push('flashPollingInterval (' + sm2.flashPollingInterval + 'ms)');
        }

        if (sm2.html5PollingInterval) {
          options.push('html5PollingInterval (' + sm2.html5PollingInterval + 'ms)');
        }

        if (sm2.wmode) {
          options.push('wmode (' + sm2.wmode + ')');
        }

        if (sm2.debugFlash) {
          options.push('debugFlash');
        }

        if (sm2.useFlashBlock) {
          options.push('flashBlock');
        }

      } else if (sm2.html5PollingInterval) {
          options.push('html5PollingInterval (' + sm2.html5PollingInterval + 'ms)');
        }

      if (options.length) {
        msg = msg.concat([options.join(delimiter)]);
      }

      sm2._wD(title + (msg.length ? delimiter + msg.join(', ') : ''), 1);

      showSupport();

      // </d>

    }

    if (sm2.html5Only) {

      // 100% HTML5 mode
      setVersionInfo();

      initMsg();
      sm2.oMC = id(sm2.movieID);
      init();

      // prevent multiple init attempts
      didAppend = true;

      appendSuccess = true;

      return false;

    }

    // flash path
    var remoteURL = (movieURL || sm2.url),
    localURL = (sm2.altURL || remoteURL),
    swfTitle = 'JS/Flash audio component (SoundManager 2)',
    oTarget = getDocument(),
    extraClass = getSWFCSS(),
    isRTL = null,
    html = doc.getElementsByTagName('html')[0],
    oEmbed, oMovie, tmp, movieHTML, oEl, s, x, sClass;

    isRTL = (html && html.dir && html.dir.match(/rtl/i));
    movieID = (movieID === _undefined ? sm2.id : movieID);

    function param(name, value) {
      return '<param name="' + name + '" value="' + value + '" />';
    }

    // safety check for legacy (change to Flash 9 URL)
    setVersionInfo();
    sm2.url = normalizeMovieURL(overHTTP ? remoteURL : localURL);
    movieURL = sm2.url;

    sm2.wmode = (!sm2.wmode && sm2.useHighPerformance ? 'transparent' : sm2.wmode);

    if (sm2.wmode !== null && (ua.match(/msie 8/i) || (!isIE && !sm2.useHighPerformance)) && navigator.platform.match(/win32|win64/i)) {
      /**
       * extra-special case: movie doesn't load until scrolled into view when using wmode = anything but 'window' here
       * does not apply when using high performance (position:fixed means on-screen), OR infinite flash load timeout
       * wmode breaks IE 8 on Vista + Win7 too in some cases, as of January 2011 (?)
       */
      messages.push(strings.spcWmode);
      sm2.wmode = null;
    }

    oEmbed = {
      name: movieID,
      id: movieID,
      src: movieURL,
      quality: 'high',
      allowScriptAccess: sm2.allowScriptAccess,
      bgcolor: sm2.bgColor,
      pluginspage: http + 'www.macromedia.com/go/getflashplayer',
      title: swfTitle,
      type: 'application/x-shockwave-flash',
      wmode: sm2.wmode,
      // http://help.adobe.com/en_US/as3/mobile/WS4bebcd66a74275c36cfb8137124318eebc6-7ffd.html
      hasPriority: 'true'
    };

    if (sm2.debugFlash) {
      oEmbed.FlashVars = 'debug=1';
    }

    if (!sm2.wmode) {
      // don't write empty attribute
      delete oEmbed.wmode;
    }

    if (isIE) {

      // IE is "special".
      oMovie = doc.createElement('div');
      movieHTML = [
        '<object id="' + movieID + '" data="' + movieURL + '" type="' + oEmbed.type + '" title="' + oEmbed.title + '" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">',
        param('movie', movieURL),
        param('AllowScriptAccess', sm2.allowScriptAccess),
        param('quality', oEmbed.quality),
        (sm2.wmode ? param('wmode', sm2.wmode) : ''),
        param('bgcolor', sm2.bgColor),
        param('hasPriority', 'true'),
        (sm2.debugFlash ? param('FlashVars', oEmbed.FlashVars) : ''),
        '</object>'
      ].join('');

    } else {

      oMovie = doc.createElement('embed');
      for (tmp in oEmbed) {
        if (oEmbed.hasOwnProperty(tmp)) {
          oMovie.setAttribute(tmp, oEmbed[tmp]);
        }
      }

    }

    initDebug();
    extraClass = getSWFCSS();
    oTarget = getDocument();

    if (oTarget) {

      sm2.oMC = (id(sm2.movieID) || doc.createElement('div'));

      if (!sm2.oMC.id) {

        sm2.oMC.id = sm2.movieID;
        sm2.oMC.className = swfCSS.swfDefault + ' ' + extraClass;
        s = null;
        oEl = null;

        if (!sm2.useFlashBlock) {
          if (sm2.useHighPerformance) {
            // on-screen at all times
            s = {
              position: 'fixed',
              width: '8px',
              height: '8px',
              // >= 6px for flash to run fast, >= 8px to start up under Firefox/win32 in some cases. odd? yes.
              bottom: '0px',
              left: '0px',
              overflow: 'hidden'
            };
          } else {
            // hide off-screen, lower priority
            s = {
              position: 'absolute',
              width: '6px',
              height: '6px',
              top: '-9999px',
              left: '-9999px'
            };
            if (isRTL) {
              s.left = Math.abs(parseInt(s.left, 10)) + 'px';
            }
          }
        }

        if (isWebkit) {
          // soundcloud-reported render/crash fix, safari 5
          sm2.oMC.style.zIndex = 10000;
        }

        if (!sm2.debugFlash) {
          for (x in s) {
            if (s.hasOwnProperty(x)) {
              sm2.oMC.style[x] = s[x];
            }
          }
        }

        try {

          if (!isIE) {
            sm2.oMC.appendChild(oMovie);
          }

          oTarget.appendChild(sm2.oMC);

          if (isIE) {
            oEl = sm2.oMC.appendChild(doc.createElement('div'));
            oEl.className = swfCSS.swfBox;
            oEl.innerHTML = movieHTML;
          }

          appendSuccess = true;

        } catch(e) {

          throw new Error(str('domError') + ' \n' + e.toString());

        }

      } else {

        // SM2 container is already in the document (eg. flashblock use case)
        sClass = sm2.oMC.className;
        sm2.oMC.className = (sClass ? sClass + ' ' : swfCSS.swfDefault) + (extraClass ? ' ' + extraClass : '');
        sm2.oMC.appendChild(oMovie);

        if (isIE) {
          oEl = sm2.oMC.appendChild(doc.createElement('div'));
          oEl.className = swfCSS.swfBox;
          oEl.innerHTML = movieHTML;
        }

        appendSuccess = true;

      }

    }

    didAppend = true;

    initMsg();

    // sm2._wD(sm + ': Trying to load ' + movieURL + (!overHTTP && sm2.altURL ? ' (alternate URL)' : ''), 1);

    return true;

  };

  initMovie = function() {

    if (sm2.html5Only) {
      createMovie();
      return false;
    }

    // attempt to get, or create, movie (may already exist)
    if (flash) return false;

    if (!sm2.url) {

      /**
       * Something isn't right - we've reached init, but the soundManager url property has not been set.
       * User has not called setup({url: ...}), or has not set soundManager.url (legacy use case) directly before init time.
       * Notify and exit. If user calls setup() with a url: property, init will be restarted as in the deferred loading case.
       */

       _wDS('noURL');
       return false;

    }

    // inline markup case
    flash = sm2.getMovie(sm2.id);

    if (!flash) {

      if (!oRemoved) {

        // try to create
        createMovie(sm2.id, sm2.url);

      } else {

        // try to re-append removed movie after reboot()
        if (!isIE) {
          sm2.oMC.appendChild(oRemoved);
        } else {
          sm2.oMC.innerHTML = oRemovedHTML;
        }

        oRemoved = null;
        didAppend = true;

      }

      flash = sm2.getMovie(sm2.id);

    }

    if (typeof sm2.oninitmovie === 'function') {
      setTimeout(sm2.oninitmovie, 1);
    }

    // <d>
    flushMessages();
    // </d>

    return true;

  };

  delayWaitForEI = function() {

    setTimeout(waitForEI, 1000);

  };

  rebootIntoHTML5 = function() {

    // special case: try for a reboot with preferFlash: false, if 100% HTML5 mode is possible and useFlashBlock is not enabled.

    window.setTimeout(function() {

      complain(smc + 'useFlashBlock is false, 100% HTML5 mode is possible. Rebooting with preferFlash: false...');

      sm2.setup({
        preferFlash: false
      }).reboot();

      // if for some reason you want to detect this case, use an ontimeout() callback and look for html5Only and didFlashBlock == true.
      sm2.didFlashBlock = true;

      sm2.beginDelayedInit();

    }, 1);

  };

  waitForEI = function() {

    var p,
        loadIncomplete = false;

    if (!sm2.url) {
      // No SWF url to load (noURL case) - exit for now. Will be retried when url is set.
      return;
    }

    if (waitingForEI) {
      return;
    }

    waitingForEI = true;
    event.remove(window, 'load', delayWaitForEI);

    if (hasFlash && tryInitOnFocus && !isFocused) {
      // Safari won't load flash in background tabs, only when focused.
      _wDS('waitFocus');
      return;
    }

    if (!didInit) {
      p = sm2.getMoviePercent();
      if (p > 0 && p < 100) {
        loadIncomplete = true;
      }
    }

    setTimeout(function() {

      p = sm2.getMoviePercent();

      if (loadIncomplete) {
        // special case: if movie *partially* loaded, retry until it's 100% before assuming failure.
        waitingForEI = false;
        sm2._wD(str('waitSWF'));
        window.setTimeout(delayWaitForEI, 1);
        return;
      }

      // <d>
      if (!didInit) {

        sm2._wD(sm + ': No Flash response within expected time. Likely causes: ' + (p === 0 ? 'SWF load failed, ' : '') + 'Flash blocked or JS-Flash security error.' + (sm2.debugFlash ? ' ' + str('checkSWF') : ''), 2);

        if (!overHTTP && p) {

          _wDS('localFail', 2);

          if (!sm2.debugFlash) {
            _wDS('tryDebug', 2);
          }

        }

        if (p === 0) {

          // if 0 (not null), probably a 404.
          sm2._wD(str('swf404', sm2.url), 1);

        }

        debugTS('flashtojs', false, ': Timed out' + (overHTTP ? ' (Check flash security or flash blockers)' : ' (No plugin/missing SWF?)'));

      }
      // </d>

      // give up / time-out, depending

      if (!didInit && okToDisable) {

        if (p === null) {

          // SWF failed to report load progress. Possibly blocked.

          if (sm2.useFlashBlock || sm2.flashLoadTimeout === 0) {

            if (sm2.useFlashBlock) {

              flashBlockHandler();

            }

            _wDS('waitForever');

          } else if (!sm2.useFlashBlock && canIgnoreFlash) {

            // no custom flash block handling, but SWF has timed out. Will recover if user unblocks / allows SWF load.
            rebootIntoHTML5();

          } else {

            _wDS('waitForever');

            // fire any regular registered ontimeout() listeners.
            processOnEvents({
              type: 'ontimeout',
              ignoreInit: true,
              error: {
                type: 'INIT_FLASHBLOCK'
              }
            });

          }

        } else if (sm2.flashLoadTimeout === 0) {

          // SWF loaded? Shouldn't be a blocking issue, then.

          _wDS('waitForever');

        } else if (!sm2.useFlashBlock && canIgnoreFlash) {

          rebootIntoHTML5();

        } else {

          failSafely(true);

        }

      }

    }, sm2.flashLoadTimeout);

  };

  handleFocus = function() {

    function cleanup() {
      event.remove(window, 'focus', handleFocus);
    }

    if (isFocused || !tryInitOnFocus) {
      // already focused, or not special Safari background tab case
      cleanup();
      return true;
    }

    okToDisable = true;
    isFocused = true;
    _wDS('gotFocus');

    // allow init to restart
    waitingForEI = false;

    // kick off ExternalInterface timeout, now that the SWF has started
    delayWaitForEI();

    cleanup();
    return true;

  };

  flushMessages = function() {

    // <d>

    // SM2 pre-init debug messages
    if (messages.length) {
      sm2._wD('SoundManager 2: ' + messages.join(' '), 1);
      messages = [];
    }

    // </d>

  };

  showSupport = function() {

    // <d>

    flushMessages();

    var item, tests = [];

    if (sm2.useHTML5Audio && sm2.hasHTML5) {
      for (item in sm2.audioFormats) {
        if (sm2.audioFormats.hasOwnProperty(item)) {
          tests.push(item + ' = ' + sm2.html5[item] + (!sm2.html5[item] && needsFlash && sm2.flash[item] ? ' (using flash)' : (sm2.preferFlash && sm2.flash[item] && needsFlash ? ' (preferring flash)' : (!sm2.html5[item] ? ' (' + (sm2.audioFormats[item].required ? 'required, ' : '') + 'and no flash support)' : ''))));
        }
      }
      sm2._wD('SoundManager 2 HTML5 support: ' + tests.join(', '), 1);
    }

    // </d>

  };

  initComplete = function(bNoDisable) {

    if (didInit) return false;

    if (sm2.html5Only) {
      // all good.
      _wDS('sm2Loaded', 1);
      didInit = true;
      initUserOnload();
      debugTS('onload', true);
      return true;
    }

    var wasTimeout = (sm2.useFlashBlock && sm2.flashLoadTimeout && !sm2.getMoviePercent()),
        result = true,
        error;

    if (!wasTimeout) {
      didInit = true;
    }

    error = {
      type: (!hasFlash && needsFlash ? 'NO_FLASH' : 'INIT_TIMEOUT')
    };

    sm2._wD('SoundManager 2 ' + (disabled ? 'failed to load' : 'loaded') + ' (' + (disabled ? 'Flash security/load error' : 'OK') + ') ' + String.fromCharCode(disabled ? 10006 : 10003), disabled ? 2 : 1);

    if (disabled || bNoDisable) {

      if (sm2.useFlashBlock && sm2.oMC) {
        sm2.oMC.className = getSWFCSS() + ' ' + (sm2.getMoviePercent() === null ? swfCSS.swfTimedout : swfCSS.swfError);
      }

      processOnEvents({
        type: 'ontimeout',
        error: error,
        ignoreInit: true
      });

      debugTS('onload', false);
      catchError(error);

      result = false;

    } else {

      debugTS('onload', true);

    }

    if (!disabled) {

      if (sm2.waitForWindowLoad && !windowLoaded) {

        _wDS('waitOnload');
        event.add(window, 'load', initUserOnload);

      } else {

        // <d>
        if (sm2.waitForWindowLoad && windowLoaded) {
          _wDS('docLoaded');
        }
        // </d>

        initUserOnload();

      }

    }

    return result;

  };

  /**
   * apply top-level setupOptions object as local properties, eg., this.setupOptions.flashVersion -> this.flashVersion (soundManager.flashVersion)
   * this maintains backward compatibility, and allows properties to be defined separately for use by soundManager.setup().
   */

  setProperties = function() {

    var i,
        o = sm2.setupOptions;

    for (i in o) {

      if (o.hasOwnProperty(i)) {

        // assign local property if not already defined

        if (sm2[i] === _undefined) {

          sm2[i] = o[i];

        } else if (sm2[i] !== o[i]) {

          // legacy support: write manually-assigned property (eg., soundManager.url) back to setupOptions to keep things in sync
          sm2.setupOptions[i] = sm2[i];

        }

      }

    }

  };


  init = function() {

    // called after onload()

    if (didInit) {
      _wDS('didInit');
      return false;
    }

    function cleanup() {
      event.remove(window, 'load', sm2.beginDelayedInit);
    }

    if (sm2.html5Only) {

      if (!didInit) {
        // we don't need no steenking flash!
        cleanup();
        sm2.enabled = true;
        initComplete();
      }

      return true;

    }

    // flash path
    initMovie();

    try {

      // attempt to talk to Flash
      flash._externalInterfaceTest(false);

      /**
       * Apply user-specified polling interval, OR, if "high performance" set, faster vs. default polling
       * (determines frequency of whileloading/whileplaying callbacks, effectively driving UI framerates)
       */
      setPolling(true, (sm2.flashPollingInterval || (sm2.useHighPerformance ? 10 : 50)));

      if (!sm2.debugMode) {
        // stop the SWF from making debug output calls to JS
        flash._disableDebug();
      }

      sm2.enabled = true;
      debugTS('jstoflash', true);

      if (!sm2.html5Only) {
        // prevent browser from showing cached page state (or rather, restoring "suspended" page state) via back button, because flash may be dead
        // http://www.webkit.org/blog/516/webkit-page-cache-ii-the-unload-event/
        event.add(window, 'unload', doNothing);
      }

    } catch(e) {

      sm2._wD('js/flash exception: ' + e.toString());

      debugTS('jstoflash', false);

      catchError({
        type: 'JS_TO_FLASH_EXCEPTION',
        fatal: true
      });

      // don't disable, for reboot()
      failSafely(true);

      initComplete();

      return false;

    }

    initComplete();

    // disconnect events
    cleanup();

    return true;

  };

  domContentLoaded = function() {

    if (didDCLoaded) return false;

    didDCLoaded = true;

    // assign top-level soundManager properties eg. soundManager.url
    setProperties();

    initDebug();

    if (!hasFlash && sm2.hasHTML5) {

      sm2._wD('SoundManager 2: No Flash detected' + (!sm2.useHTML5Audio ? ', enabling HTML5.' : '. Trying HTML5-only mode.'), 1);

      sm2.setup({
        useHTML5Audio: true,
        // make sure we aren't preferring flash, either
        // TODO: preferFlash should not matter if flash is not installed. Currently, stuff breaks without the below tweak.
        preferFlash: false
      });

    }

    testHTML5();

    if (!hasFlash && needsFlash) {

      messages.push(strings.needFlash);

      // TODO: Fatal here vs. timeout approach, etc.
      // hack: fail sooner.
      sm2.setup({
        flashLoadTimeout: 1
      });

    }

    if (doc.removeEventListener) {
      doc.removeEventListener('DOMContentLoaded', domContentLoaded, false);
    }

    initMovie();

    return true;

  };

  domContentLoadedIE = function() {

    if (doc.readyState === 'complete') {
      domContentLoaded();
      doc.detachEvent('onreadystatechange', domContentLoadedIE);
    }

    return true;

  };

  winOnLoad = function() {

    // catch edge case of initComplete() firing after window.load()
    windowLoaded = true;

    // catch case where DOMContentLoaded has been sent, but we're still in doc.readyState = 'interactive'
    domContentLoaded();

    event.remove(window, 'load', winOnLoad);

  };

  // sniff up-front
  detectFlash();

  // focus and window load, init (primarily flash-driven)
  event.add(window, 'focus', handleFocus);
  event.add(window, 'load', delayWaitForEI);
  event.add(window, 'load', winOnLoad);

  if (doc.addEventListener) {

    doc.addEventListener('DOMContentLoaded', domContentLoaded, false);

  } else if (doc.attachEvent) {

    doc.attachEvent('onreadystatechange', domContentLoadedIE);

  } else {

    // no add/attachevent support - safe to assume no JS -> Flash either
    debugTS('onload', false);
    catchError({
      type: 'NO_DOM2_EVENTS',
      fatal: true
    });

  }

} // SoundManager()

// SM2_DEFER details: http://www.schillmania.com/projects/soundmanager2/doc/getstarted/#lazy-loading

if (window.SM2_DEFER === _undefined || !SM2_DEFER) {
  soundManager = new SoundManager();
}

/**
 * SoundManager public interfaces
 * ------------------------------
 */

if (typeof module === 'object' && module && typeof module.exports === 'object') {

  /**
   * commonJS module
   */

  module.exports.SoundManager = SoundManager;
  module.exports.soundManager = soundManager;

} else if (typeof define === 'function' && define.amd) {

  /**
   * AMD - requireJS
   * basic usage:
   * require(["/path/to/soundmanager2.js"], function(SoundManager) {
   *   SoundManager.getInstance().setup({
   *     url: '/swf/',
   *     onready: function() { ... }
   *   })
   * });
   *
   * SM2_DEFER usage:
   * window.SM2_DEFER = true;
   * require(["/path/to/soundmanager2.js"], function(SoundManager) {
   *   SoundManager.getInstance(function() {
   *     var soundManager = new SoundManager.constructor();
   *     soundManager.setup({
   *       url: '/swf/',
   *       ...
   *     });
   *     ...
   *     soundManager.beginDelayedInit();
   *     return soundManager;
   *   })
   * });
   */

  define(function() {
    /**
     * Retrieve the global instance of SoundManager.
     * If a global instance does not exist it can be created using a callback.
     *
     * @param {Function} smBuilder Optional: Callback used to create a new SoundManager instance
     * @return {SoundManager} The global SoundManager instance
     */
    function getInstance(smBuilder) {
      if (!window.soundManager && smBuilder instanceof Function) {
        var instance = smBuilder(SoundManager);
        if (instance instanceof SoundManager) {
          window.soundManager = instance;
        }
      }
      return window.soundManager;
    }
    return {
      constructor: SoundManager,
      getInstance: getInstance
    };
  });

}

// standard browser case

// constructor
window.SoundManager = SoundManager;

/**
 * note: SM2 requires a window global due to Flash, which makes calls to window.soundManager.
 * Flash may not always be needed, but this is not known until async init and SM2 may even "reboot" into Flash mode.
 */

// public API, flash callbacks etc.
window.soundManager = soundManager;

}(window));

},{}],2:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _observer = require('./observer');

var _observer2 = _interopRequireDefault(_observer);

var _soundmanager2 = require('soundmanager2');

// import { threeSixtyPlayer } from '../../../sm/360-player/script/360player';

var self = undefined,
    pl = undefined,
    sm = _soundmanager2.soundManager,
    // soundManager instance
uA = navigator.userAgent,
    isIE = uA.match(/msie/i),
    isOpera = uA.match(/opera/i),
    isSafari = uA.match(/safari/i),
    isChrome = uA.match(/chrome/i),
    isFirefox = uA.match(/firefox/i),
    isTouchDevice = uA.match(/ipad|iphone/i),
    hasRealCanvas = typeof window.G_vmlCanvasManager === 'undefined' && typeof document.createElement('canvas').getContext('2d') !== 'undefined',

// I dunno what Opera doesn't like about this. I'm probably doing it wrong.
fullCircle = isOpera || isChrome ? 359.9 : 360;

var STATUS_DEFAULT = "STATUS_DEFAULT";
var STATUS_BUFFERING = "STATUS_BUFFERING";
var STATUS_PLAYING = "STATUS_PLAYING";
var STATUS_PAUSED = "STATUS_PAUSED";

var css = {
    STATUS_DEFAULT: 'sm2_link',
    STATUS_BUFFERING: 'sm2_buffering',
    STATUS_PLAYING: 'sm2_playing',
    STATUS_PAUSED: 'sm2_paused'
};

var soundObserver = new _observer2['default']();

_soundmanager2.soundManager.setup({
    // path to directory containing SM2 SWF
    url: 'plugins/editor.soundmanager/sm/swf/'
});

var Player = (function (_React$Component) {
    _inherits(Player, _React$Component);

    function Player(props) {
        _classCallCheck(this, Player);

        _get(Object.getPrototypeOf(Player.prototype), 'constructor', this).call(this, props);

        this.state = {
            status: STATUS_DEFAULT
        };
    }

    _createClass(Player, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _this = this;

            var _props = this.props;
            var id = _props.id;
            var url = _props.url;
            var style = _props.style;
            var rich = _props.rich;
            var autoPlay = _props.autoPlay;
            var onFinish = _props.onFinish;

            _soundmanager2.soundManager.onready(function () {
                var sound = _soundmanager2.soundManager.getSoundById(id);

                // First we check if it already exists
                if (sound) {
                    return;
                }

                _soundmanager2.soundManager.createSound({
                    id: id,
                    url: url,
                    multiShot: false,
                    onplay: function onplay() {
                        return soundObserver.play(id);
                    },
                    onstop: function onstop() {
                        return soundObserver.stop(id);
                    },
                    onpause: function onpause() {
                        return soundObserver.pause(id);
                    },
                    onresume: function onresume() {
                        return soundObserver.resume(id);
                    },
                    onfinish: function onfinish() {
                        return soundObserver.finish(id);
                    },
                    onbufferchange: function onbufferchange() {
                        return soundObserver.bufferchange(id);
                    },
                    whileloading: function whileloading() {
                        return soundObserver.whileloading(id);
                    },
                    whileplaying: function whileplaying() {
                        return soundObserver.whileplaying(id);
                    }
                });

                if (!_this.props.disableAutoPlay) {
                    // Adding autoplay, listening to previous sound finish events
                    var previousSoundID = _soundmanager2.soundManager.soundIDs.indexOf(id) - 1;
                    if (previousSoundID > -1) {
                        soundObserver.observe("soundfinish" + _soundmanager2.soundManager.soundIDs[previousSoundID], function () {
                            _soundmanager2.soundManager.getSoundById(id).play();
                        });
                    }
                }
            });

            var oCanvasCTX = this.canvas.getContext('2d');

            oCanvasCTX.translate(parseInt(style.width / 2), parseInt(style.height / 2));
            oCanvasCTX.rotate(deg2rad(-90));

            soundObserver.observe("soundplay" + id, function () {
                _this.setState({ status: STATUS_PLAYING });
                if (_this.props.onPlay) _this.props.onPlay();
            });
            soundObserver.observe("soundpause" + id, function () {
                _this.setState({ status: STATUS_PAUSED });
                if (_this.props.onPause) _this.props.onPause();
            });
            soundObserver.observe("soundbuffering" + id, function () {
                _this.setState({ status: STATUS_BUFFERING });
            });
            soundObserver.observe("soundresume" + id, function () {
                _this.setState({ status: STATUS_PLAYING });
                if (_this.props.onPlay) _this.props.onPlay();
            });
            soundObserver.observe("soundstop" + id, function () {
                clearCanvas(_this.canvas);
                _this.setState({ status: STATUS_DEFAULT });
            });
            soundObserver.observe("soundfinish" + id, function () {
                clearCanvas(_this.canvas);
                _this.setState({ status: STATUS_DEFAULT });

                if (typeof onFinish === "function") {
                    onFinish();
                }
            });

            soundObserver.observe("soundwhileplaying" + id, function () {
                var sound = _soundmanager2.soundManager.getSoundById(id);
                var radius = rich ? 60 : 20;
                var width = rich ? 20 : 5;

                var durationEstimate = sound.durationEstimate > 0 ? sound.durationEstimate : sound.buffered[0].end;

                if (_this.canvas) {
                    // Background
                    drawSolidArc(_this.canvas, '#dddddd', radius, width, deg2rad(fullCircle), 0, false);
                    // Loading ring
                    drawSolidArc(_this.canvas, '#cccccc', radius, width, deg2rad(fullCircle * (sound.bytesLoaded / sound.bytesTotal)), 0, true);
                    // Playing ring
                    drawSolidArc(_this.canvas, '#000000', radius, width, deg2rad(fullCircle * (sound.position / durationEstimate)), 0, true);
                }

                _this.setState({
                    time: getTime(sound.position, true)
                });
            });

            // Making sure the status is correct if sound is already playing
            var sound = _soundmanager2.soundManager.getSoundById(id);
            if (sound && sound.playState === 1) {
                if (sound.paused) {
                    this.setState({
                        status: STATUS_PAUSED
                    });
                } else {
                    this.setState({
                        status: STATUS_PLAYING
                    });
                }
            }
        }
    }, {
        key: '_handleEvent',
        value: function _handleEvent(e) {
            var _props2 = this.props;
            var id = _props2.id;
            var rich = _props2.rich;

            var offset = rich ? 20 : 5;
            var sound = _soundmanager2.soundManager.getSoundById(id);
            var coords = getMouseXY(e);
            var x = coords[0];
            var y = coords[1];

            var rect = this.canvas.getBoundingClientRect();

            var canvasMidX = rect.left + parseInt(this.canvas.width / 2);
            var canvasMidY = rect.top + parseInt(this.canvas.height / 2);

            var deltaX = x - canvasMidX;
            var deltaY = y - canvasMidY;

            if (Math.abs(deltaX) < offset && Math.abs(deltaY) < offset) {
                if (e.type == "mouseup") {
                    _soundmanager2.soundManager.soundIDs.map(function (soundID) {
                        try {
                            soundID !== id && _soundmanager2.soundManager.sounds[soundID].stop();
                        } catch (e) {}
                    });
                    sound.togglePause();
                }
                return;
            }

            var angle = Math.floor(fullCircle - (rad2deg(Math.atan2(deltaX, deltaY)) + 180));

            var durationEstimate = sound.durationEstimate > 0 ? sound.durationEstimate : sound.buffered[0].end;
            var position = Math.floor(durationEstimate * (angle / fullCircle) / 1000);

            sound.setPosition(position * 1000);
            sound.resume();
        }
    }, {
        key: 'handleMouseUp',
        value: function handleMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();

            this.dragging = false;

            this._handleEvent(e);

            return false;
        }
    }, {
        key: 'handleMouseMove',
        value: function handleMouseMove(e) {
            e.preventDefault();
            e.stopPropagation();

            if (this.dragging) {
                this._handleEvent(e);
            }

            return false;
        }
    }, {
        key: 'handleMouseDown',
        value: function handleMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();

            this.dragging = true;

            this._handleEvent(e);

            return false;
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _state = this.state;
            var status = _state.status;
            var time = _state.time;

            var className = "ui360";
            if (this.props.rich) {
                className += " ui360-vis";
            }

            var style = _extends({}, this.props.style, {
                "backgroundImage": "none"
            });

            var canvasStyle = {
                "width": this.props.style.width,
                "height": this.props.style.height,
                "backgroundColor": "transparent",
                "borderRadius": 0,
                "boxShadow": "none"
            };

            var childStyle = {
                "width": this.props.style.width,
                "height": this.props.style.height,
                "backgroundColor": "transparent",
                "border": 0,
                "borderRadius": 0,
                "boxShadow": "none"
            };

            var btnStyle = {
                "width": this.props.style.width,
                "height": this.props.style.height,
                "lineHeight": this.props.style.width + "px",
                "margin": 0,
                "top": 0,
                "left": 0,
                "bottom": 0,
                "right": 0
            };

            var timingStyle = {
                "width": this.props.style.width,
                "height": this.props.style.height,
                "lineHeight": this.props.style.height + "px"
            };

            var coverStyle = {
                "width": this.props.style.width,
                "height": this.props.style.height,
                "lineHeight": this.props.style.height + "px"
            };

            //

            return _react2['default'].createElement(
                'div',
                { className: 'sm2-inline-list', style: style },
                _react2['default'].createElement(
                    'div',
                    { className: className, style: style, onMouseMove: function (e) {
                            return _this2.handleMouseMove(e);
                        }, onMouseUp: function (e) {
                            return _this2.handleMouseUp(e);
                        }, onMouseDown: function (e) {
                            return _this2.handleMouseDown(e);
                        } },
                    _react2['default'].createElement(
                        'div',
                        { className: "sm2-360ui " + css[status], style: childStyle },
                        _react2['default'].createElement('canvas', { ref: function (el) {
                                return _this2.canvas = el;
                            }, className: 'sm2-canvas', style: canvasStyle, width: this.props.style.width, height: this.props.style.height }),
                        _react2['default'].createElement('span', { className: 'sm2-360btn sm2-360btn-default', style: btnStyle }),
                        _react2['default'].createElement(
                            'div',
                            { className: 'sm2-timing', style: timingStyle },
                            time
                        ),
                        _react2['default'].createElement('div', { className: 'sm2-cover', style: coverStyle })
                    )
                )
            );
        }
    }]);

    return Player;
})(_react2['default'].Component);

Player.propTypes = {
    // threeSixtyPlayer: React.PropTypes.object,
    autoPlay: _react2['default'].PropTypes.bool,
    rich: _react2['default'].PropTypes.bool.isRequired,
    onReady: _react2['default'].PropTypes.func
};

Player.defaultProps = {
    autoPlay: false,
    rich: true
};

var deg2rad = function deg2rad(nDeg) {
    return nDeg * Math.PI / 180;
};

var rad2deg = function rad2deg(nRad) {
    return nRad * 180 / Math.PI;
};

var getTime = function getTime(nMSec, bAsString) {

    // convert milliseconds to mm:ss, return as object literal or string
    var nSec = Math.floor(nMSec / 1000),
        min = Math.floor(nSec / 60),
        sec = nSec - min * 60;
    // if (min === 0 && sec === 0) return null; // return 0:00 as null
    return bAsString ? min + ':' + (sec < 10 ? '0' + sec : sec) : { 'min': min, 'sec': sec };
};

var getArcEndpointCoords = function getArcEndpointCoords(radius, radians) {

    return {
        x: radius * Math.cos(radians),
        y: radius * Math.sin(radians)
    };
};

var clearCanvas = function clearCanvas(oCanvas) {

    var canvas = oCanvas,
        ctx = null,
        width,
        height;
    if (canvas && canvas.getContext) {
        // use getContext to use the canvas for drawing
        ctx = canvas.getContext('2d');
    }
    width = canvas.offsetWidth;
    height = canvas.offsetHeight;
    ctx.clearRect(-(width / 2), -(height / 2), width, height);
};

var drawSolidArc = function drawSolidArc(oCanvas, color, radius, width, radians, startAngle, noClear) {

    var x = radius,
        y = radius,
        canvas = oCanvas,
        ctx,
        innerRadius,
        doesntLikeZero,
        endPoint;

    if (canvas && canvas.getContext) {
        // use getContext to use the canvas for drawing
        ctx = canvas.getContext('2d');
    }

    // re-assign canvas as the actual context
    oCanvas = ctx;

    if (!noClear) {
        clearCanvas(canvas);
    }
    // ctx.restore();

    if (color) {
        ctx.fillStyle = color;
    }

    oCanvas.beginPath();

    if (isNaN(radians)) {
        radians = 0;
    }

    innerRadius = radius - width;
    doesntLikeZero = isOpera || isSafari; // safari 4 doesn't actually seem to mind.

    if (!doesntLikeZero || doesntLikeZero && radius > 0) {
        oCanvas.arc(0, 0, radius, startAngle, radians, false);
        endPoint = getArcEndpointCoords(innerRadius, radians);
        oCanvas.lineTo(endPoint.x, endPoint.y);
        oCanvas.arc(0, 0, innerRadius, radians, startAngle, true);
        oCanvas.closePath();
        oCanvas.fill();
    }
};

var getMouseXY = function getMouseXY(e) {

    // http://www.quirksmode.org/js/events_properties.html
    e = e ? e : window.event;
    if (isTouchDevice && e.touches) {
        e = e.touches[0];
    }
    if (e.pageX || e.pageY) {
        return [e.pageX, e.pageY];
    } else if (e.clientX || e.clientY) {
        return [e.clientX + getScrollLeft(), e.clientY + getScrollTop()];
    }
};

var getScrollLeft = function getScrollLeft() {
    return document.body.scrollLeft + document.documentElement.scrollLeft;
};

var getScrollTop = function getScrollTop() {
    return document.body.scrollTop + document.documentElement.scrollTop;
};

exports['default'] = Player;
module.exports = exports['default'];

},{"./observer":7,"react":"react","soundmanager2":1}],3:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Player = require('./Player');

var _Player2 = _interopRequireDefault(_Player);

var Badge = (function (_Component) {
    _inherits(Badge, _Component);

    function Badge() {
        _classCallCheck(this, Badge);

        _get(Object.getPrototypeOf(Badge.prototype), 'constructor', this).apply(this, arguments);
    }

    _createClass(Badge, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.loadNode(this.props);

            // threeSixtyPlayer.init()
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.node !== this.props.node) {
                this.loadNode(nextProps);
            }
        }
    }, {
        key: 'loadNode',
        value: function loadNode(props) {
            var pydio = props.pydio;
            var node = props.node;

            this.setState({
                path: node.getPath(),
                url: pydio.Parameters.get('ajxpServerAccess') + '&get_action=audio_proxy&file=' + encodeURIComponent(HasherUtils.base64_encode(node.getPath())),
                mimeType: "audio/" + node.getAjxpMime()
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _ref = this.state || {};

            var mimeType = _ref.mimeType;
            var path = _ref.path;
            var url = _ref.url;

            if (!url) return null;

            return _react2['default'].createElement(_Player2['default'], { id: path, autoPlay: true, url: url, rich: false, style: { width: 40, height: 40 }, onReady: function () {} });
        }
    }]);

    return Badge;
})(_react.Component);

exports['default'] = Badge;

function guid() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}
module.exports = exports['default'];

},{"./Player":2,"react":"react"}],4:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _PydioHOCs = PydioHOCs;
var SelectionControls = _PydioHOCs.SelectionControls;
exports.SelectionControls = SelectionControls;

},{}],5:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _redux = require('redux');

var _materialUi = require('material-ui');

var _Player = require('./Player');

var _Player2 = _interopRequireDefault(_Player);

var _pydioUtilHasher = require('pydio/util/hasher');

var _pydioUtilHasher2 = _interopRequireDefault(_pydioUtilHasher);

var Editor = (function (_Component) {
    _inherits(Editor, _Component);

    function Editor(props) {
        _classCallCheck(this, Editor);

        _get(Object.getPrototypeOf(Editor.prototype), 'constructor', this).call(this, props);
        this.state = { showPlayer: true };
    }

    _createClass(Editor, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var _this = this;

            var sound = soundManager.getSoundById(nextProps.node.getPath());

            if (sound && this.props.node.getPath() !== nextProps.node.getPath()) {
                soundManager.soundIDs.map(function (soundID) {
                    try {
                        soundManager.sounds[soundID].stop();
                    } catch (e) {}
                });
                this.setState({ showPlayer: false }, function () {
                    _this.setState({ showPlayer: true });
                });
            }

            if (sound) {
                if (nextProps.selectionPlaying) {
                    sound.play();
                } else {
                    sound.pause();
                }
            }
        }
    }, {
        key: 'onRowsSelected',
        value: function onRowsSelected(rows) {
            if (!rows || !rows.length) return;
            var index = rows[0];
            var onRequestSelectionPlay = this.props.onRequestSelectionPlay;

            onRequestSelectionPlay(null, index, true);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var node = _props.node;
            var selectionPlaying = _props.selectionPlaying;
            var selection = _props.selection;
            var onRequestSelectionPlay = _props.onRequestSelectionPlay;
            var showPlayer = this.state.showPlayer;

            console.log(selection, showPlayer);
            var url = undefined,
                crtIndex = 0;
            if (selection && showPlayer && node) {
                url = pydio.Parameters.get('ajxpServerAccess') + '&get_action=audio_proxy&file=' + encodeURIComponent(_pydioUtilHasher2['default'].base64_encode(node.getPath()));
                selection.selection.forEach(function (n, i) {
                    if (n.getPath() === node.getPath()) {
                        crtIndex = i;
                    }
                });
            }

            return _react2['default'].createElement(
                'div',
                { style: Editor.styles.container },
                url && _react2['default'].createElement(_Player2['default'], {
                    id: node.getPath(),
                    url: url,
                    rich: true,
                    style: { width: 250, height: 200, margin: "auto" },
                    onReady: function () {},
                    onPlay: function () {
                        onRequestSelectionPlay(null, crtIndex, true);
                    },
                    onPause: function () {
                        onRequestSelectionPlay(null, crtIndex, false);
                    },
                    disableAutoPlay: true,
                    onFinish: function () {
                        // Handle autoPlay here
                        if (selection && selection.selection && selection.selection[crtIndex + 1]) {
                            onRequestSelectionPlay(null, crtIndex + 1, true);
                        }
                    }
                }),
                _react2['default'].createElement(
                    _materialUi.Paper,
                    { zDepth: 1, style: Editor.styles.paper },
                    _react2['default'].createElement(
                        _materialUi.Table,
                        {
                            style: Editor.styles.table,
                            selectable: true,
                            multiSelectable: false,
                            onRowSelection: this.onRowsSelected.bind(this)
                        },
                        _react2['default'].createElement(
                            _materialUi.TableBody,
                            {
                                displayRowCheckbox: false,
                                stripedRows: false,
                                deselectOnClickaway: false
                            },
                            selection && selection.selection.map(function (n, index) {
                                var leftCol = index + 1;
                                var rowStyle = Editor.styles.row;
                                if (node && n.getPath() === node.getPath()) {
                                    if (selectionPlaying) {
                                        leftCol = _react2['default'].createElement('span', { className: "mdi mdi-pause", style: Editor.styles.leftColIcon, onClick: function () {
                                                onRequestSelectionPlay(null, index, false);
                                            } });
                                    } else {
                                        leftCol = _react2['default'].createElement('span', { className: "mdi mdi-play", style: Editor.styles.leftColIcon, onClick: function () {
                                                onRequestSelectionPlay(null, index, true);
                                            } });
                                    }
                                    rowStyle = Editor.styles.rowSelected;
                                }
                                return _react2['default'].createElement(
                                    _materialUi.TableRow,
                                    { key: index },
                                    _react2['default'].createElement(
                                        _materialUi.TableRowColumn,
                                        { style: _extends({}, Editor.styles.leftCol, rowStyle) },
                                        leftCol
                                    ),
                                    _react2['default'].createElement(
                                        _materialUi.TableRowColumn,
                                        { style: rowStyle },
                                        n.getLabel()
                                    )
                                );
                            })
                        )
                    )
                )
            );
        }
    }], [{
        key: 'styles',
        get: function get() {
            return {
                container: {
                    margin: "auto",
                    display: "flex",
                    flexDirection: "column",
                    justifyContent: "space-between",
                    flex: 1,
                    backgroundColor: '#fafafa'
                },
                player: {
                    margin: "auto"
                },
                paper: {
                    margin: 10
                },
                table: {
                    width: "100%"
                },
                row: {
                    backgroundColor: 'transparent'
                },
                rowSelected: {
                    backgroundColor: '#fafafa'
                },
                leftCol: {
                    width: 60,
                    textAlign: 'center',
                    paddingRight: 0
                },
                leftColIcon: {
                    cursor: 'pointer'
                }
            };
        }
    }]);

    return Editor;
})(_react.Component);

function guid() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}

var _PydioHOCs = PydioHOCs;
var withSelection = _PydioHOCs.withSelection;
var withMenu = _PydioHOCs.withMenu;
var withLoader = _PydioHOCs.withLoader;
var withErrors = _PydioHOCs.withErrors;
var withControls = _PydioHOCs.withControls;

var editors = pydio.Registry.getActiveExtensionByType("editor");
var conf = editors.filter(function (_ref) {
    var id = _ref.id;
    return id === 'editor.soundmanager';
})[0];

var getSelectionFilter = function getSelectionFilter(node) {
    return conf.mimes.indexOf(node.getAjxpMime()) > -1;
};

var getSelection = function getSelection(node) {
    return new Promise(function (resolve, reject) {
        var selection = [];

        node.getParent().getChildren().forEach(function (child) {
            return selection.push(child);
        });
        selection = selection.filter(getSelectionFilter);

        resolve({
            selection: selection,
            currentIndex: selection.reduce(function (currentIndex, current, index) {
                return current === node && index || currentIndex;
            }, 0)
        });
    });
};

var getTime = function getTime(nMSec, bAsString) {

    // convert milliseconds to mm:ss, return as object literal or string
    var nSec = Math.floor(nMSec / 1000),
        min = Math.floor(nSec / 60),
        sec = nSec - min * 60;
    // if (min === 0 && sec === 0) return null; // return 0:00 as null
    return bAsString ? min + ':' + (sec < 10 ? '0' + sec : sec) : { 'min': min, 'sec': sec };
};

exports['default'] = (0, _redux.compose)(withSelection(getSelection), (0, _reactRedux.connect)())(Editor);
module.exports = exports['default'];

},{"./Player":2,"material-ui":"material-ui","pydio/util/hasher":"pydio/util/hasher","react":"react","react-redux":"react-redux","redux":"redux"}],6:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequire(obj) { return obj && obj.__esModule ? obj['default'] : obj; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _editor = require('./editor');

var _editor2 = _interopRequireDefault(_editor);

var _controls = require('./controls');

var Controls = _interopRequireWildcard(_controls);

var _badge = require('./badge');

exports.Badge = _interopRequire(_badge);

var _preview = require('./preview');

exports.Panel = _interopRequire(_preview);
exports.Editor = _editor2['default'];
exports.Controls = Controls;

},{"./badge":3,"./controls":4,"./editor":5,"./preview":8}],7:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SoundObserver = (function (_Observable) {
    _inherits(SoundObserver, _Observable);

    function SoundObserver() {
        _classCallCheck(this, SoundObserver);

        _get(Object.getPrototypeOf(SoundObserver.prototype), "constructor", this).call(this);
        pydio.observe("repository_list_refreshed", function () {});
    }

    _createClass(SoundObserver, [{
        key: "play",
        value: function play(soundID) {
            this.notify("soundplay" + soundID);
        }
    }, {
        key: "pause",
        value: function pause(soundID) {
            this.notify("soundpause" + soundID);
        }
    }, {
        key: "stop",
        value: function stop(soundID) {
            this.notify("soundstop" + soundID);
        }
    }, {
        key: "resume",
        value: function resume(soundID) {
            this.notify("soundresume" + soundID);
        }
    }, {
        key: "finish",
        value: function finish(soundID) {
            this.notify("soundfinish" + soundID);
        }
    }, {
        key: "whileloading",
        value: function whileloading(soundID) {
            this.notify("soundwhileloading" + soundID);
        }
    }, {
        key: "whileplaying",
        value: function whileplaying(soundID) {
            this.notify("soundwhileplaying" + soundID);
        }
    }, {
        key: "bufferchange",
        value: function bufferchange(soundID) {
            this.notify("soundbufferchange" + soundID);
        }
    }], [{
        key: "getInstance",
        value: function getInstance() {
            if (!OpenNodesModel.__INSTANCE) {
                OpenNodesModel.__INSTANCE = new OpenNodesModel();
            }
            return OpenNodesModel.__INSTANCE;
        }
    }]);

    return SoundObserver;
})(Observable);

exports["default"] = SoundObserver;
module.exports = exports["default"];

},{}],8:[function(require,module,exports){
/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Player = require('./Player');

var _Player2 = _interopRequireDefault(_Player);

// The threeSixytPlayer is the same for all badges
// var threeSixtyPlayer = new ThreeSixtyPlayer();

var Preview = (function (_Component) {
    _inherits(Preview, _Component);

    function Preview() {
        _classCallCheck(this, Preview);

        _get(Object.getPrototypeOf(Preview.prototype), 'constructor', this).apply(this, arguments);
    }

    _createClass(Preview, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.loadNode(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.node !== this.props.node) {
                this.loadNode(nextProps);
            }
        }
    }, {
        key: 'loadNode',
        value: function loadNode(props) {
            var pydio = props.pydio;
            var node = props.node;

            this.setState({
                path: node.getPath(),
                url: pydio.Parameters.get('ajxpServerAccess') + '&get_action=audio_proxy&file=' + encodeURIComponent(HasherUtils.base64_encode(node.getPath())),
                mimeType: "audio/" + node.getAjxpMime()
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _ref = this.state || {};

            var mimeType = _ref.mimeType;
            var path = _ref.path;
            var url = _ref.url;

            if (!url) return null;

            return _react2['default'].createElement(_Player2['default'], { id: path, url: url, rich: true, style: { width: 250, height: 200, margin: "auto" }, onReady: function () {} });
        }
    }]);

    return Preview;
})(_react.Component);

exports['default'] = Preview;

function guid() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}
module.exports = exports['default'];

},{"./Player":2,"react":"react"}]},{},[6])(6)
});

//# sourceMappingURL=data:application/json;charset:utf-8;base64,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
