/*
 * Copyright 2007-2013 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _redux = require('redux');

var _Player = require('./Player');

var _Player2 = _interopRequireDefault(_Player);

var PydioSoundManager = (function (_Component) {
    _inherits(PydioSoundManager, _Component);

    function PydioSoundManager(props) {
        _classCallCheck(this, PydioSoundManager);

        _get(Object.getPrototypeOf(PydioSoundManager.prototype), 'constructor', this).call(this, props);

        var pydio = props.pydio;
        var node = props.node;
        var preview = props.preview;

        this.state = {
            url: pydio.Parameters.get('ajxpServerAccess') + '&get_action=audio_proxy&file=' + encodeURIComponent(HasherUtils.base64_encode(node.getPath())) + '&z=' + guid(),
            mimeType: "audio/" + node.getAjxpMime()
        };
    }

    // Static functions

    _createClass(PydioSoundManager, [{
        key: 'render',
        value: function render() {

            return _react2['default'].createElement(
                ExtendedPlayer,
                { rich: !this.props.icon && this.props.rich, onReady: this.props.onLoad },
                _react2['default'].createElement('a', { type: this.state.mimeType, href: this.state.url })
            );
        }
    }], [{
        key: 'getPreviewComponent',
        value: function getPreviewComponent(node) {
            var rich = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

            return {
                element: PydioSoundManager,
                props: {
                    node: node,
                    rich: rich
                }
            };
        }
    }]);

    return PydioSoundManager;
})(_react.Component);

PydioSoundManager.defaultProps = {
    onLoad: function onLoad() {}
};

function guid() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}

var _PydioHOCs = PydioHOCs;
var withMenu = _PydioHOCs.withMenu;
var withLoader = _PydioHOCs.withLoader;
var withErrors = _PydioHOCs.withErrors;
var withControls = _PydioHOCs.withControls;

var ExtendedPlayer = (0, _redux.compose)(withMenu, withErrors)(function (props) {
    return _react2['default'].createElement(_Player2['default'], props);
});

// We need to attach the element to window else it won't be found
window.PydioSoundManager = PydioSoundManager;

exports['default'] = PydioSoundManager;
module.exports = exports['default'];
