/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

import React from 'react'
import PluginEditor from '../core/PluginEditor'
import {RaisedButton, Checkbox} from 'material-ui'

const UpdaterDashboard = React.createClass({

    mixins:[AdminComponents.MessagesConsumerMixin],


    getInitialState: function(){
        return {checks: -1, version:'...', versionDate:''};
    },

    componentDidMount:function(){
        this.checkForUpgrade();
        this.checkCurrentVersion();
    },

    checkCurrentVersion(){
        PydioApi.getClient().request({get_action:'get_version_info'}, (transp)=>{
            if(transp.responseJSON){
                this.setState(transp.responseJSON);
            }
        });
    },

    checkForUpgrade: function(){
        this.setState({loading:true});
        PydioApi.getClient().request({get_action:'get_upgrade_path'}, function(transp){
            this.setState({loading:false});
            if(!this.isMounted()) return;
            var response = transp.responseJSON;
            var length = 0;
            if(response && response.packages.length){
                length = response.packages.length;
                this.setState({packages:response.packages});
                if(response.latest_note){
                    let latest = response.latest_note;
                    latest = pydio.Parameters.get('ajxpServerAccess') + '&get_action=display_upgrade_note';
                    this.setState({src:latest});
                }
            }else{
                this.setState({no_upgrade:true});
            }

            var node = pydio.getContextNode();
            node.getMetadata().set('flag', length);
            AdminComponents.MenuItemListener.getInstance().notify("item_changed");

        }.bind(this));
    },

    performUpgrade: function(){
        if(this.state.checks < 0){
            alert('Please select at least one package!');
            return;
        }
        if(confirm(this.context.getMessage('15', 'updater'))){
            var client = PydioApi.getClient();
            this.setState({src:''}, function(){
                this.setState({src: client._baseUrl + '?secure_token=' + pydio.Parameters.get("SECURE_TOKEN")  + '&get_action=perform_upgrade&package_index=' + this.state.checks});
            }.bind(this));

        }
    },

    onCheckStateChange: function(index, value){
        if(value) this.setState({checks: index});
        else this.setState({checks: index - 1});
    },

    render:function(){

        var list = null;
        const {packages, checks, loading} = this.state;
        if(packages){
            list = (
                <div style={{paddingBottom:30,paddingRight:5}}>
                        <span style={{float:'right'}}>
                            <RaisedButton primary={true} label={this.context.getMessage('4', 'updater')} onTouchTap={this.performUpgrade}/>
                        </span>
                    {this.context.getMessage('16', 'updater')}
                    <div style={{paddingLeft:30}}>{packages.map((p, index) => {
                        return <div><Checkbox style={{listStyle:'inherit'}} key={p} label={PathUtils.getBasename(p)} onCheck={(e,v)=> this.onCheckStateChange(index, v)} checked={index <= checks} /></div>
                    })}</div>
                    <br/>{this.context.getMessage('3', 'updater')}
                </div>
            );
        }else if(this.state && this.state.loading){
            list = (
                <div>{this.context.getMessage('17', 'updater')}</div>
            );
        }else{
            list = (
                <div>
                        <span style={{float:'right'}}>
                            <RaisedButton secondary={true} label={this.context.getMessage('20', 'updater')} onTouchTap={this.checkForUpgrade}/>
                        </span>
                    { (this.state && this.state.no_upgrade) ? this.context.getMessage('18', 'updater') : this.context.getMessage('19', 'updater') }
                </div>
            );
        }

        var updateCheckPane = (
            <div style={{padding:'0 20px'}}>
                <h3>{this.context.getMessage('2', 'updater')}</h3>
                <div style={{paddingBottom:20,paddingRight:5}}>{list}</div>
                <iframe
                    ref="iframe"
                    style={{width:'100%',height:400, border:'1px solid #ccc'}}
                    src={this.state?this.state.src:''}
                ></iframe>
            </div>
        );
        const {version, versionDate} = this.state;
        let additionalDescription;
        if(version === '##VERSION_NUMBER##'){
            additionalDescription = this.context.getMessage('21', 'updater');
        }else if (version !== '...') {
            additionalDescription = this.context.getMessage('22', 'updater').replace('%1', version).replace('%2', versionDate);
        }
        return (
            <div className="update-checker" style={{height:'100%'}}>
                <PluginEditor
                    {...this.props}
                    additionalDescription={additionalDescription}
                    additionalPanes={{top:[updateCheckPane], bottom:[]}}
                />
            </div>
        );
    }

});

export {UpdaterDashboard as default}