/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _MessagesProviderMixin = require('../MessagesProviderMixin');

var _MessagesProviderMixin2 = _interopRequireDefault(_MessagesProviderMixin);

var _Breadcrumb = require('./Breadcrumb');

var _Breadcrumb2 = _interopRequireDefault(_Breadcrumb);

var _search = require('../search');

var _MainFilesList = require('./MainFilesList');

var _MainFilesList2 = _interopRequireDefault(_MainFilesList);

var _EditionPanel = require('./EditionPanel');

var _EditionPanel2 = _interopRequireDefault(_EditionPanel);

var _detailpanesInfoPanel = require('../detailpanes/InfoPanel');

var _detailpanesInfoPanel2 = _interopRequireDefault(_detailpanesInfoPanel);

var _leftnavLeftPanel = require('../leftnav/LeftPanel');

var _leftnavLeftPanel2 = _interopRequireDefault(_leftnavLeftPanel);

var _WelcomeTour = require('./WelcomeTour');

var _WelcomeTour2 = _interopRequireDefault(_WelcomeTour);

var React = require('react');
var Color = require('color');

var _require$requireLib = require('pydio').requireLib('hoc');

var withContextMenu = _require$requireLib.withContextMenu;
var dropProvider = _require$requireLib.dropProvider;

var Action = require('pydio/model/action');

var FSTemplate = React.createClass({
    displayName: 'FSTemplate',

    mixins: [_MessagesProviderMixin2['default']],

    propTypes: {
        pydio: React.PropTypes.instanceOf(Pydio)
    },

    statics: {
        INFO_PANEL_WIDTH: 270
    },

    componentDidMount: function componentDidMount() {
        this.props.pydio.getController().updateGuiActions(this.getPydioActions());
    },

    componentWillUnmount: function componentWillUnmount() {
        this.getPydioActions(true).map((function (key) {
            this.props.pydio.getController().deleteFromGuiActions(key);
        }).bind(this));
    },

    getPydioActions: function getPydioActions() {
        var _this = this;

        var keysOnly = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

        if (keysOnly) {
            return ['toggle_info_panel'];
        }
        var multiAction = new Action({
            name: 'toggle_info_panel',
            icon_class: 'mdi mdi-information',
            text_id: 341,
            title_id: 341,
            text: this.props.pydio.MessageHash[341],
            title: this.props.pydio.MessageHash[341],
            hasAccessKey: false,
            subMenu: false,
            subMenuUpdateImage: false,
            callback: function callback() {
                _this.setState({ infoPanelToggle: !_this.state.infoPanelToggle }, function () {
                    return _this.resizeAfterTransition();
                });
            }
        }, {
            selection: true,
            dir: true,
            file: true,
            actionBar: true,
            actionBarGroup: 'display_toolbar,put',
            contextMenu: true,
            infoPanel: false
        }, { dir: true, file: true }, {}, {});
        var buttons = new Map();
        buttons.set('toggle_info_panel', multiAction);
        return buttons;
    },

    getInitialState: function getInitialState() {
        return {
            infoPanelOpen: false,
            infoPanelToggle: true,
            drawerOpen: false
        };
    },

    resizeAfterTransition: function resizeAfterTransition() {
        var _this2 = this;

        setTimeout(function () {
            if (_this2.refs.list) _this2.refs.list.resize();
        }, 500);
    },

    infoPanelContentChange: function infoPanelContentChange(numberOfCards) {
        var _this3 = this;

        this.setState({ infoPanelOpen: numberOfCards > 0 }, function () {
            return _this3.resizeAfterTransition();
        });
    },

    openDrawer: function openDrawer(event) {
        event.stopPropagation();
        this.setState({ drawerOpen: true });
    },

    closeDrawer: function closeDrawer() {
        if (!this.state.drawerOpen) {
            return;
        }
        this.setState({ drawerOpen: false });
    },

    render: function render() {

        var connectDropTarget = this.props.connectDropTarget || function (c) {
            return c;
        };
        var mobile = this.props.pydio.UI.MOBILE_EXTENSIONS;

        /*
        var isOver = this.props.isOver;
        var canDrop = this.props.canDrop;
        */

        var Color = MaterialUI.Color;
        var appBarColor = Color(this.props.muiTheme.appBar.color);

        var styles = {
            appBarStyle: {
                zIndex: 1,
                backgroundColor: this.props.muiTheme.appBar.color
            },
            buttonsStyle: {
                color: this.props.muiTheme.appBar.textColor
            },
            iconButtonsStyle: {
                color: appBarColor.darken(0.4).toString()
            },
            raisedButtonStyle: {
                height: 30,
                minWidth: 0
            },
            raisedButtonLabelStyle: {
                height: 30,
                lineHeight: '30px'
            },
            infoPanelStyle: {
                backgroundColor: appBarColor.lightness(95).rgb().toString()
            }
        };

        var classes = ['vertical_layout', 'vertical_fit', 'react-fs-template'];
        if (this.state.infoPanelOpen && this.state.infoPanelToggle) classes.push('info-panel-open');
        if (this.state.drawerOpen) classes.push('drawer-open');

        var mainToolbars = ["info_panel", "info_panel_share"];
        var mainToolbarsOthers = ["change", "other"];
        if (this.state.infoPanelOpen && this.state.infoPanelToggle) {
            mainToolbars = ["change_main"];
            mainToolbarsOthers = ["get", "change", "other"];
        }

        var guiPrefs = this.props.pydio.user ? this.props.pydio.user.getPreference('gui_preferences', true) : [];
        var wTourEnabled = this.props.pydio.getPluginConfigs('gui.ajax').get('ENABLE_WELCOME_TOUR');
        var inboxWorkspace = this.props.pydio.user && this.props.pydio.user.activeRepository === 'inbox';

        // Making sure we only pass the style to the parent element
        var _props = this.props;
        var style = _props.style;

        var props = _objectWithoutProperties(_props, ['style']);

        return connectDropTarget(React.createElement(
            'div',
            { style: style, className: classes.join(' '), onTouchTap: this.closeDrawer, onContextMenu: this.props.onContextMenu },
            wTourEnabled && !guiPrefs['WelcomeComponent.Pydio8.TourGuide.FSTemplate'] && React.createElement(_WelcomeTour2['default'], { ref: 'welcome', pydio: this.props.pydio }),
            React.createElement(_leftnavLeftPanel2['default'], { className: 'left-panel', pydio: props.pydio }),
            React.createElement(
                'div',
                { className: 'desktop-container vertical_layout vertical_fit' },
                React.createElement(
                    MaterialUI.Paper,
                    { zDepth: 1, style: styles.appBarStyle, rounded: false },
                    React.createElement(
                        'div',
                        { id: 'workspace_toolbar', style: { display: 'flex' } },
                        React.createElement(
                            'span',
                            { className: 'drawer-button' },
                            React.createElement(MaterialUI.IconButton, { style: { color: 'white' }, iconClassName: 'mdi mdi-menu', onTouchTap: this.openDrawer })
                        ),
                        React.createElement(_Breadcrumb2['default'], _extends({}, props, { startWithSeparator: false })),
                        React.createElement('span', { style: { flex: 1 } }),
                        !inboxWorkspace && React.createElement(_search.SearchForm, props)
                    ),
                    React.createElement(
                        'div',
                        { id: 'main_toolbar' },
                        !inboxWorkspace && React.createElement(PydioComponents.ButtonMenu, _extends({}, props, {
                            buttonStyle: styles.raisedButtonStyle,
                            buttonLabelStyle: styles.raisedButtonLabelStyle,
                            id: 'create-button-menu',
                            toolbars: ["upload", "create"],
                            buttonTitle: this.props.pydio.MessageHash['198'],
                            raised: true,
                            secondary: true,
                            controller: props.pydio.Controller,
                            openOnEvent: 'tutorial-open-create-menu'
                        })),
                        !mobile && React.createElement(PydioComponents.Toolbar, _extends({}, props, {
                            id: 'main-toolbar',
                            toolbars: mainToolbars,
                            groupOtherList: mainToolbarsOthers,
                            renderingType: 'button',
                            buttonStyle: styles.buttonsStyle
                        })),
                        mobile && React.createElement('span', { style: { flex: 1 } }),
                        React.createElement(PydioComponents.ListPaginator, {
                            id: 'paginator-toolbar',
                            dataModel: props.pydio.getContextHolder(),
                            toolbarDisplay: true
                        }),
                        React.createElement(PydioComponents.Toolbar, _extends({}, props, {
                            id: 'display-toolbar',
                            toolbars: ["display_toolbar"],
                            renderingType: 'icon-font',
                            buttonStyle: styles.iconButtonsStyle
                        }))
                    )
                ),
                React.createElement(_MainFilesList2['default'], { ref: 'list', pydio: this.props.pydio })
            ),
            React.createElement(_detailpanesInfoPanel2['default'], _extends({}, props, {
                dataModel: props.pydio.getContextHolder(),
                onContentChange: this.infoPanelContentChange,
                style: styles.infoPanelStyle
            })),
            React.createElement(_EditionPanel2['default'], props),
            React.createElement(
                'span',
                { className: 'context-menu' },
                React.createElement(PydioComponents.ContextMenu, { pydio: this.props.pydio })
            )
        ));
    }
});

exports['default'] = FSTemplate = dropProvider(FSTemplate);
exports['default'] = FSTemplate = withContextMenu(FSTemplate);
exports['default'] = FSTemplate = MaterialUI.Style.muiThemeable()(FSTemplate);

exports['default'] = FSTemplate;
module.exports = exports['default'];
